/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString;

import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.MorphStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MorphPropertyFileUtils {
    public static final String MORPH_STRING_PROPERTIES = "/morphString.properties";
    private static Properties properties = null;

    public static boolean retrievePropertyBoolean(String key, boolean defaultValue) {
        String booleanValue = MorphPropertyFileUtils.retrievePropertyString(key);
        if (booleanValue == null || "".equals(booleanValue)) {
            return defaultValue;
        }
        if (booleanValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (booleanValue.equalsIgnoreCase("false")) {
            return false;
        }
        String logMessage = "Illegal value for boolean property, must be true of false: " + key + ", " + booleanValue;
        throw new RuntimeException(logMessage);
    }

    public static String retrievePropertyString(String key) {
        Properties localProperties = MorphPropertyFileUtils.retrieveProperties();
        String value = localProperties.getProperty(key);
        return value;
    }

    public static synchronized Properties retrieveProperties() {
        if (properties == null) {
            String propertiesFileLocation = MORPH_STRING_PROPERTIES;
            InputStream inputStream = null;
            try {
                inputStream = MorphPropertyFileUtils.class.getResourceAsStream(propertiesFileLocation);
                if (inputStream == null) {
                    throw new RuntimeException("Cant find resource file on classpath: " + propertiesFileLocation);
                }
                Properties tempProperties = new Properties();
                tempProperties.load(inputStream);
                properties = tempProperties;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    public static synchronized Properties retrievePropertiesFromFile(String filePath) {
        InputStream inputStream = null;
        File file = new File(filePath);
        try {
            if (!file.exists()) {
                throw new RuntimeException("Cant find file on classpath: " + MorphStringUtils.fileCanonicalPath(file));
            }
            inputStream = new FileInputStream(file);
            Properties tempProperties = new Properties();
            tempProperties.load(inputStream);
            properties = tempProperties;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem reading file: " + MorphStringUtils.fileCanonicalPath(file), ioe);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

