/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.util;

import edu.internet2.middleware.grouperClientExt.xmpp.EsbEvents;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class JsonUtils {
    private static Pattern jsonPattern = Pattern.compile("^\\s*\\{\\s*\\\"([^\"]+)\\\"\\s*:\\s*(.*)}\\s*$", 32);

    public static Object jsonConvertFrom(Map<String, Class<?>> conversionMap, String json) {
        Matcher matcher = jsonPattern.matcher(json);
        if (!matcher.matches()) {
            throw new RuntimeException("Cant match this json, should start with simple class name: " + json);
        }
        String simpleClassName = matcher.group(1);
        String jsonBody = matcher.group(2);
        Class<?> theClass = conversionMap.get(simpleClassName);
        if (theClass == null) {
            throw new RuntimeException("Not allowed to unmarshal json: " + simpleClassName + ", " + json);
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonBody);
        Object object = JSONObject.toBean((JSONObject)jsonObject, theClass);
        return object;
    }

    public static Object jsonConvertFrom(String json, Class<?> theClass) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        Object object = JSONObject.toBean((JSONObject)jsonObject, theClass);
        return object;
    }

    public static String jsonConvertTo(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                return value == null;
            }
        });
        JSONObject jsonObject = JSONObject.fromObject((Object)object, (JsonConfig)jsonConfig);
        String json = jsonObject.toString();
        return "{\"" + object.getClass().getSimpleName() + "\":" + json + "}";
    }

    public static void jsonConvertTo(Object object, Writer writer) {
        String json = JsonUtils.jsonConvertTo(object);
        try {
            writer.write(json);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String jsonConvertToNoWrap(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                return value == null;
            }
        });
        JSONObject jsonObject = JSONObject.fromObject((Object)object, (JsonConfig)jsonConfig);
        String json = jsonObject.toString();
        return json;
    }

    public static void main(String[] args) {
        String jsonEventString = "{\"esbEvent\":[{\"displayName\":\"test:isc:ait:mchyzer:test\",\"eventType\":\"GROUP_ADD\",\"id\":\"917a3c80afee4e2c8d008e16e743eabe\",\"name\":\"test:isc:ait:mchyzer:test\",\"parentStemId\":\"091f20d5-a29b-4817-95f8-213b9573194d\"}]}";
        EsbEvents esbEvents = (EsbEvents)JsonUtils.jsonConvertFrom(jsonEventString, EsbEvents.class);
        System.out.println(esbEvents.getEsbEvent()[0].getEventType());
    }
}

