/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GcWebServiceError;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupSaveResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupToSave;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGroupSaveRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcGroupSave {
    private String clientVersion;
    private List<WsGroupToSave> groupsToSave = new ArrayList<WsGroupToSave>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private GcTransactionType txType;

    public GcGroupSave assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGroupSave addGroupToSave(WsGroupToSave wsGroupToSave) {
        this.groupsToSave.add(wsGroupToSave);
        return this;
    }

    public GcGroupSave addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGroupSave addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGroupSave assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.groupsToSave) == 0) {
            throw new RuntimeException("Group name is required: " + this);
        }
    }

    public GcGroupSave assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public WsGroupSaveResults execute() {
        this.validate();
        WsGroupSaveResults wsGroupSaveResults = null;
        try {
            WsRestGroupSaveRequest groupSave = new WsRestGroupSaveRequest();
            groupSave.setActAsSubjectLookup(this.actAsSubject);
            groupSave.setTxType(this.txType == null ? null : this.txType.name());
            if (this.includeGroupDetail != null) {
                groupSave.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            groupSave.setWsGroupToSaves(GrouperClientUtils.toArray(this.groupsToSave, WsGroupToSave.class));
            if (this.params.size() > 0) {
                groupSave.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGroupSaveResults = (WsGroupSaveResults)grouperClientWs.executeService("groups", groupSave, "groupSave", this.clientVersion, false);
            String groupSaveResultMessage = "";
            try {
                groupSaveResultMessage = wsGroupSaveResults.getResults()[0].getResultMetadata().getResultMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String resultMessage = wsGroupSaveResults.getResultMetadata().getResultMessage() + "\n" + groupSaveResultMessage;
            grouperClientWs.handleFailure(wsGroupSaveResults, wsGroupSaveResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGroupSaveResults;
    }

    public GcGroupSave assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public static void main(String[] args) {
        WsGroupToSave wsGroupToSave = new WsGroupToSave();
        wsGroupToSave.setSaveMode("INSERT");
        WsGroup wsGroup = new WsGroup();
        wsGroup.setDisplayExtension("a group5");
        wsGroup.setExtension("aGroup5");
        wsGroup.setName("aStem:aGroup5");
        wsGroupToSave.setWsGroup(wsGroup);
        try {
            WsGroupSaveResults wsGroupSaveResults = new GcGroupSave().addGroupToSave(wsGroupToSave).execute();
            System.out.println(wsGroupSaveResults.getResults()[0].getResultMetadata().getResultCode());
        }
        catch (GcWebServiceError gwse) {
            WsGroupSaveResults wsGroupSaveResults = (WsGroupSaveResults)gwse.getContainerResponseObject();
            System.out.println(wsGroupSaveResults.getResults()[0].getResultMetadata().getResultCode());
            gwse.printStackTrace();
        }
    }
}

