/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc;

import edu.internet2.middleware.grouperClient.jdbc.GcBoundDataConversion;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;

public class GcBoundDataConversionImpl
implements GcBoundDataConversion {
    @Override
    public void addBindVariableToStatement(PreparedStatement preparedStatement, Object bindVar, int index) {
        try {
            if (bindVar == null) {
                preparedStatement.setObject(index, null);
                return;
            }
            Class<?> clazz = bindVar.getClass();
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                preparedStatement.setInt(index, (Integer)bindVar);
            } else if (clazz == String.class) {
                preparedStatement.setString(index, (String)bindVar);
            } else if (clazz == Double.TYPE || clazz == Double.class) {
                preparedStatement.setDouble(index, (Double)bindVar);
            } else if (clazz == Long.TYPE || clazz == Long.class) {
                preparedStatement.setLong(index, (Long)bindVar);
            } else if (clazz == Float.TYPE || clazz == Float.class) {
                preparedStatement.setFloat(index, ((Float)bindVar).floatValue());
            } else if (clazz == Byte.TYPE || clazz == Byte.class) {
                preparedStatement.setByte(index, (Byte)bindVar);
            } else if (clazz == byte[].class || clazz == Byte[].class) {
                preparedStatement.setBytes(index, (byte[])bindVar);
            } else if (clazz == Character.TYPE || clazz == Character.class) {
                preparedStatement.setString(index, (String)bindVar);
            } else if (clazz == Short.TYPE || clazz == Short.class) {
                preparedStatement.setShort(index, (Short)bindVar);
            } else if (clazz == BigDecimal.class) {
                preparedStatement.setDouble(index, ((BigDecimal)bindVar).doubleValue());
            } else if (clazz == Timestamp.class) {
                preparedStatement.setTimestamp(index, (Timestamp)bindVar);
            } else if (bindVar instanceof Date) {
                Timestamp timestamp = new Timestamp(((Date)bindVar).getTime());
                preparedStatement.setTimestamp(index, timestamp);
            } else {
                preparedStatement.setObject(index, bindVar);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem attaching param index: " + index + ", param: '" + bindVar + "'", e);
        }
    }

    @Override
    public void setFieldValue(Object instance, Field field, Object value) {
        block17: {
            try {
                if (value == null) {
                    field.set(instance, value);
                    return;
                }
                if (Date.class.isAssignableFrom(field.getType()) || java.sql.Date.class.isAssignableFrom(field.getType())) {
                    value = GrouperClientUtils.toTimestamp(value);
                } else if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                    value = Double.parseDouble(String.valueOf(value));
                } else if (field.getType() == BigDecimal.class) {
                    value = new BigDecimal(String.valueOf(value));
                } else if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                    value = new Long(String.valueOf(value));
                } else if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    value = new Integer(String.valueOf(value));
                } else if (field.getType() == String.class && !(value instanceof String)) {
                    value = String.valueOf(value);
                }
                if (field.getType().isPrimitive()) {
                    field.set(instance, value);
                    break block17;
                }
                try {
                    field.set(instance, field.getType().cast(value));
                }
                catch (RuntimeException e) {
                    GrouperClientUtils.injectInException(e, instance.getClass() + ", " + field.getName() + ", " + value.getClass());
                    throw e;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Issues converting data from oracle to java for field " + field.getName() + " in class " + field.getDeclaringClass() + " from type " + value.getClass() + " to type " + field.getType(), e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T getFieldValue(Class<T> clazz, Object value) {
        if (value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        try {
            if (!(value instanceof Number)) throw new RuntimeException("Not expecting value: " + value.getClass());
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                value = ((Number)value).intValue();
                return (T)value;
            } else if (clazz == Double.TYPE || clazz == Double.class) {
                value = ((Number)value).doubleValue();
                return (T)value;
            } else if (clazz == Long.TYPE || clazz == Long.class) {
                value = ((Number)value).longValue();
                return (T)value;
            } else {
                if (clazz != String.class) throw new RuntimeException("Not expecting value: " + value.getClass());
                value = ((Number)value).toString();
            }
            return (T)value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

