/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcDbVersionable;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableClass;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableHelper;
import edu.internet2.middleware.grouperClient.jdbc.GcSqlAssignPrimaryKey;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncDao;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncGroupDao;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJob;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJobDao;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLog;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLogDao;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMember;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMemberDao;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMembership;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMembershipDao;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.builder.EqualsBuilder;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

@GcPersistableClass(tableName="grouper_sync", defaultFieldPersist=GcPersist.doPersist)
public class GcGrouperSync
implements GcSqlAssignPrimaryKey,
GcDbVersionable {
    @GcPersistableField(persist=GcPersist.dontPersist)
    private int internalObjectsCreatedCount = 0;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncJob> internalCacheSyncJobs = new HashMap<String, GcGrouperSyncJob>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncJob> internalCacheSyncJobsById = new HashMap<String, GcGrouperSyncJob>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Integer batchSize;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Integer maxBindVarsInSelect;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncGroupDao gcGrouperSyncGroupDao = new GcGrouperSyncGroupDao();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncDao gcGrouperSyncDao = new GcGrouperSyncDao();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncMember> internalCacheSyncMembers = new HashMap<String, GcGrouperSyncMember>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncMember> internalCacheSyncMembersById = new HashMap<String, GcGrouperSyncMember>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<MultiKey, GcGrouperSyncMembership> internalCacheSyncMemberships = new HashMap<MultiKey, GcGrouperSyncMembership>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<MultiKey, GcGrouperSyncMembership> internalCacheSyncMembershipsById = new HashMap<MultiKey, GcGrouperSyncMembership>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncLog> internalCacheSyncLogs = new HashMap<String, GcGrouperSyncLog>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSync dbVersion = null;
    public static final String SQL_SYNC_ENGINE = "sqlTableSync";
    private static Log LOG = GrouperClientUtils.retrieveLog(GcGrouperSync.class);
    private Timestamp lastIncrementalSyncRun;
    private Timestamp lastFullSyncRun;
    private Timestamp lastFullMetadataSyncRun;
    private Long incrementalIndex;
    private Timestamp incrementalTimestamp;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private String connectionName;
    @GcPersistableField(primaryKey=true, primaryKeyManuallyAssigned=false)
    private String id;
    private String syncEngine;
    private String provisionerName;
    private Timestamp lastUpdated;
    private Integer groupCount;
    private Integer userCount;
    private Integer recordsCount;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncLogDao gcGrouperSyncLogDao = new GcGrouperSyncLogDao();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncJobDao gcGrouperSyncJobDao = new GcGrouperSyncJobDao();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncMemberDao gcGrouperSyncMemberDao = new GcGrouperSyncMemberDao();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncMembershipDao gcGrouperSyncMembershipDao = new GcGrouperSyncMembershipDao();

    public int getInternalObjectsCreatedCount() {
        return this.internalObjectsCreatedCount;
    }

    public void setInternalObjectsCreatedCount(int internalObjectsCreatedCount1) {
        this.internalObjectsCreatedCount = internalObjectsCreatedCount1;
    }

    public void addObjectCreatedCount(int amountToAdd) {
        this.internalObjectsCreatedCount += amountToAdd;
    }

    public int batchSize() {
        if (this.batchSize == null) {
            int defaultBatchSize = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTableDefault.batchSize", 1000);
            this.batchSize = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTable." + this.provisionerName + ".batchSize", defaultBatchSize);
        }
        return this.batchSize;
    }

    public int maxBindVarsInSelect() {
        if (this.maxBindVarsInSelect == null) {
            int defaultMaxBindVarsInSelect = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTableDefault.maxBindVarsInSelect", 900);
            this.maxBindVarsInSelect = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.syncTable." + this.provisionerName + ".maxBindVarsInSelect", defaultMaxBindVarsInSelect);
        }
        return this.maxBindVarsInSelect;
    }

    public GcGrouperSyncGroupDao getGcGrouperSyncGroupDao() {
        return this.gcGrouperSyncGroupDao;
    }

    @Override
    public void dbVersionReset() {
        this.dbVersion = this.clone();
    }

    @Override
    public boolean dbVersionDifferent() {
        return !this.equalsDeep(this.dbVersion);
    }

    @Override
    public void dbVersionDelete() {
        this.dbVersion = null;
    }

    public GcGrouperSync clone() {
        GcGrouperSync gcGrouperSync = new GcGrouperSync();
        gcGrouperSync.groupCount = this.groupCount;
        gcGrouperSync.id = this.id;
        gcGrouperSync.incrementalIndex = this.incrementalIndex;
        gcGrouperSync.incrementalTimestamp = this.incrementalTimestamp;
        gcGrouperSync.lastFullMetadataSyncRun = this.lastFullMetadataSyncRun;
        gcGrouperSync.lastFullSyncRun = this.lastFullSyncRun;
        gcGrouperSync.lastIncrementalSyncRun = this.lastIncrementalSyncRun;
        gcGrouperSync.provisionerName = this.provisionerName;
        gcGrouperSync.recordsCount = this.recordsCount;
        gcGrouperSync.syncEngine = this.syncEngine;
        gcGrouperSync.userCount = this.userCount;
        return gcGrouperSync;
    }

    public boolean equalsDeep(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GcGrouperSync)) {
            return false;
        }
        GcGrouperSync other = (GcGrouperSync)obj;
        return new EqualsBuilder().append(this.groupCount, other.groupCount).append(this.id, other.id).append(this.incrementalIndex, other.incrementalIndex).append(this.incrementalTimestamp, other.incrementalTimestamp).append(this.lastFullMetadataSyncRun, other.lastFullMetadataSyncRun).append(this.lastFullSyncRun, other.lastFullSyncRun).append(this.lastIncrementalSyncRun, other.lastIncrementalSyncRun).append(this.provisionerName, other.provisionerName).append(this.recordsCount, other.recordsCount).append(this.syncEngine, other.syncEngine).append(this.userCount, other.userCount).isEquals();
    }

    public static void reset() {
        try {
            new GcDbAccess().connectionName("grouper").sql("select * from " + GcPersistableHelper.tableName(GcGrouperSync.class) + " where 1 != 1").select(Integer.class);
        }
        catch (Exception e) {
            return;
        }
        new GcDbAccess().connectionName("grouper").sql("delete from " + GcPersistableHelper.tableName(GcGrouperSync.class)).executeSql();
    }

    public static String defaultConnectionName(String connectionName) {
        return GrouperClientUtils.defaultIfBlank(connectionName, "grouper");
    }

    public Timestamp getLastIncrementalSyncRun() {
        return this.lastIncrementalSyncRun;
    }

    public void setLastIncrementalSyncRun(Timestamp lastIncrementalSyncRun1) {
        this.lastIncrementalSyncRun = lastIncrementalSyncRun1;
    }

    public Timestamp getLastFullSyncRun() {
        return this.lastFullSyncRun;
    }

    public void setLastFullSyncRun(Timestamp lastFullSyncRun1) {
        this.lastFullSyncRun = lastFullSyncRun1;
    }

    public Timestamp getLastFullMetadataSyncRun() {
        return this.lastFullMetadataSyncRun;
    }

    public void setLastFullMetadataSyncRun(Timestamp lastFullMetadataSyncRun1) {
        this.lastFullMetadataSyncRun = lastFullMetadataSyncRun1;
    }

    public Long getIncrementalIndex() {
        return this.incrementalIndex;
    }

    public void setIncrementalIndex(Long incrementalIndexOrMillis1) {
        this.incrementalIndex = incrementalIndexOrMillis1;
    }

    public Timestamp getIncrementalTimestamp() {
        return this.incrementalTimestamp;
    }

    public void setIncrementalTimestamp(Timestamp incrementalTimestamp1) {
        this.incrementalTimestamp = incrementalTimestamp1;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName1) {
        this.connectionName = connectionName1;
    }

    public void storePrepare() {
        this.lastUpdated = new Timestamp(System.currentTimeMillis());
        this.connectionName = GcGrouperSync.defaultConnectionName(this.connectionName);
    }

    public static void main(String[] args) {
        GcGrouperSync theGcGrouperSync2;
        System.out.println("none");
        for (GcGrouperSync theGcGrouperSync2 : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSync.class)) {
            System.out.println(theGcGrouperSync2.toString());
        }
        GcGrouperSync gcGrouperSync = new GcGrouperSync();
        gcGrouperSync.setSyncEngine("temp");
        gcGrouperSync.setProvisionerName("myJob");
        gcGrouperSync.setLastUpdated(new Timestamp(System.currentTimeMillis()));
        gcGrouperSync.setRecordsCount(10);
        gcGrouperSync.setGroupCount(5);
        gcGrouperSync.setUserCount(12);
        gcGrouperSync.setConnectionName("grouper");
        gcGrouperSync.getGcGrouperSyncDao().store();
        System.out.println("stored");
        theGcGrouperSync2 = GcGrouperSyncDao.retrieveByProvisionerName(null, "myJob");
        System.out.println(theGcGrouperSync2.toString());
        gcGrouperSync.setRecordsCount(12);
        gcGrouperSync.getGcGrouperSyncDao().store();
        System.out.println("updated");
        for (GcGrouperSync theGcGrouperSync2 : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSync.class)) {
            System.out.println(theGcGrouperSync2.toString());
        }
        gcGrouperSync.getGcGrouperSyncDao().delete();
        System.out.println("deleted");
        for (GcGrouperSync theGcGrouperSync2 : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSync.class)) {
            System.out.println(theGcGrouperSync2.toString());
        }
        System.out.println("retrieveOrCreate");
        gcGrouperSync = GcGrouperSyncDao.retrieveOrCreateByProvisionerName(null, "myJob");
        System.out.println(gcGrouperSync.toString());
        System.out.println("retrieve");
        theGcGrouperSync2 = GcGrouperSyncDao.retrieveByProvisionerName(null, "myJob");
        System.out.println(gcGrouperSync.toString());
        System.out.println("retrieveOrCreate");
        gcGrouperSync = GcGrouperSyncDao.retrieveOrCreateByProvisionerName(null, "myJob");
        System.out.println(gcGrouperSync.toString());
        System.out.println("deleted");
        gcGrouperSync.getGcGrouperSyncDao().delete();
        for (GcGrouperSync theGcGrouperSync2 : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSync.class)) {
            System.out.println(theGcGrouperSync2.toString());
        }
        int queryCount = GcDbAccess.threadLocalQueryCountRetrieve();
        System.out.println("Query count orig: " + queryCount);
        gcGrouperSync = GcGrouperSyncDao.retrieveOrCreateByProvisionerName(null, "myJob");
        System.out.println(gcGrouperSync.toString());
        queryCount = GcDbAccess.threadLocalQueryCountRetrieve();
        System.out.println("Query count after insert: " + queryCount);
        gcGrouperSync.setLastIncrementalSyncRun(new Timestamp(System.currentTimeMillis()));
        gcGrouperSync.getGcGrouperSyncDao().store();
        queryCount = GcDbAccess.threadLocalQueryCountRetrieve();
        System.out.println("Query count after update with changes: " + queryCount);
        gcGrouperSync = GcGrouperSyncDao.retrieveOrCreateByProvisionerName(null, "myJob");
        System.out.println(gcGrouperSync.toString());
        queryCount = GcDbAccess.threadLocalQueryCountRetrieve();
        System.out.println("Query count before update without changes: " + queryCount);
        gcGrouperSync.getGcGrouperSyncDao().store();
        queryCount = GcDbAccess.threadLocalQueryCountRetrieve();
        System.out.println("Query count after update with no changes: " + queryCount);
    }

    public String toString() {
        return GrouperClientUtils.toStringReflection(this);
    }

    public GcGrouperSync() {
        this.gcGrouperSyncDao.setGcGrouperSync(this);
        this.gcGrouperSyncGroupDao.setGcGrouperSync(this);
        this.gcGrouperSyncLogDao.setGcGrouperSync(this);
        this.gcGrouperSyncJobDao.setGcGrouperSync(this);
        this.gcGrouperSyncMemberDao.setGcGrouperSync(this);
        this.gcGrouperSyncMembershipDao.setGcGrouperSync(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id1) {
        this.id = id1;
    }

    public String getSyncEngine() {
        return this.syncEngine;
    }

    public void setSyncEngine(String syncEngine1) {
        this.syncEngine = syncEngine1;
    }

    public String getProvisionerName() {
        return this.provisionerName;
    }

    public void setProvisionerName(String provisionerName1) {
        this.provisionerName = provisionerName1;
    }

    public Timestamp getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Timestamp lastUpdated1) {
        this.lastUpdated = lastUpdated1;
    }

    public Integer getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(Integer groupCount1) {
        this.groupCount = groupCount1;
    }

    public Integer getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Integer userCount1) {
        this.userCount = userCount1;
    }

    public GcGrouperSyncLogDao getGcGrouperSyncLogDao() {
        return this.gcGrouperSyncLogDao;
    }

    public Integer getRecordsCount() {
        return this.recordsCount;
    }

    public void setRecordsCount(Integer recordsCount1) {
        this.recordsCount = recordsCount1;
    }

    @Override
    public boolean gcSqlAssignNewPrimaryKeyForInsert() {
        if (this.id != null) {
            return false;
        }
        this.id = GrouperClientUtils.uuid();
        return true;
    }

    public GcGrouperSyncJobDao getGcGrouperSyncJobDao() {
        return this.gcGrouperSyncJobDao;
    }

    public GcGrouperSyncMemberDao getGcGrouperSyncMemberDao() {
        return this.gcGrouperSyncMemberDao;
    }

    public GcGrouperSyncMembershipDao getGcGrouperSyncMembershipDao() {
        return this.gcGrouperSyncMembershipDao;
    }

    public GcGrouperSyncDao getGcGrouperSyncDao() {
        return this.gcGrouperSyncDao;
    }
}

