/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLog;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMembership;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GcGrouperSyncLogDao {
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncLog> internalCacheSyncLogs = new HashMap<String, GcGrouperSyncLog>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncLog> internalCacheSyncLogsById = new HashMap<String, GcGrouperSyncLog>();
    private GcGrouperSync gcGrouperSync;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private boolean logRetrievedAllObjectsFromDb = false;

    public GcGrouperSyncLog logCreateByOwnerId(String ownerId) {
        GcGrouperSyncLog gcGrouperSyncLog = new GcGrouperSyncLog();
        gcGrouperSyncLog.setGrouperSync(this.getGcGrouperSync());
        gcGrouperSyncLog.setGrouperSyncOwnerId(ownerId);
        this.internal_logCacheAdd(gcGrouperSyncLog);
        return gcGrouperSyncLog;
    }

    public int logDeleteOldLogs(Integer numberOfMillisOldToDelete) {
        numberOfMillisOldToDelete = GrouperClientUtils.defaultIfNull(numberOfMillisOldToDelete, 604800000);
        List<Timestamp> theTimestamps = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select last_updated from grouper_sync_log where grouper_sync_id = ? and last_updated < ?").addBindVar(this.getGcGrouperSync().getId()).addBindVar(new Timestamp(System.currentTimeMillis() - (long)numberOfMillisOldToDelete.intValue())).selectList(Timestamp.class);
        if (theTimestamps.size() == 0) {
            return 0;
        }
        Collections.sort(theTimestamps);
        Collections.reverse(theTimestamps);
        int batchSize = 5000;
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(theTimestamps, batchSize);
        int count = 0;
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<Timestamp> theBatch = GrouperClientUtils.batchList(theTimestamps, batchSize, batchIndex);
            Timestamp earliestTimestamp = theBatch.get(theBatch.size() - 1);
            int currentCount = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_id = ? and last_updated < ?").addBindVar(this.getGcGrouperSync().getId()).addBindVar(earliestTimestamp).executeSql();
            count += currentCount;
        }
        return count;
    }

    public int logDeleteByOwnerId(String ownerId) {
        this.internal_logCacheDeleteByOwnerId(ownerId);
        return new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_owner_id = ?").bindVars(ownerId).executeSql();
    }

    public int logDeleteByMembershipSyncGroupId(String syncGroupId) {
        this.internal_logCacheDeleteByMembershipSyncGroupId(syncGroupId);
        return new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log gsl where grouper_sync_owner_id in ( select gsm.id from grouper_sync_membership gsm where gsm.grouper_sync_group_id = ? )").bindVars(syncGroupId).executeSql();
    }

    public int logDeleteByMembershipSyncMemberId(String syncMemberId) {
        this.internal_logCacheDeleteByMembershipSyncMemberId(syncMemberId);
        return new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log gsl where grouper_sync_owner_id in ( select gsm.id from grouper_sync_membership gsm where gsm.grouper_sync_member_id = ? )").bindVars(syncMemberId).executeSql();
    }

    public int internal_logDeleteBatchByOwnerIds(Collection<String> ownerIds) {
        int count = 0;
        if (GrouperClientUtils.length(ownerIds) > 0) {
            int[] rowDeleteCounts;
            this.internal_logCacheDeleteByOwnerIds(new HashSet<String>(ownerIds));
            ArrayList<List<Object>> batchBindVars = new ArrayList<List<Object>>();
            for (String ownerId : ownerIds) {
                ArrayList<String> currentBindVarRow = new ArrayList<String>();
                currentBindVarRow.add(ownerId);
                batchBindVars.add(currentBindVarRow);
            }
            for (int rowDeleteCount : rowDeleteCounts = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_owner_id = ?").batchBindVars(batchBindVars).batchSize(this.getGcGrouperSync().batchSize()).executeBatchSql()) {
                count += rowDeleteCount;
            }
        }
        return count;
    }

    public int logDelete(Collection<GcGrouperSyncLog> gcGrouperSyncLogs) {
        int[] rowDeleteCounts;
        int count = 0;
        if (GrouperClientUtils.length(gcGrouperSyncLogs) == 0) {
            return 0;
        }
        ArrayList<List<Object>> batchBindVars = new ArrayList<List<Object>>();
        for (GcGrouperSyncLog gcGrouperSyncLog : gcGrouperSyncLogs) {
            ArrayList<String> currentBindVarRow = new ArrayList<String>();
            currentBindVarRow.add(gcGrouperSyncLog.getId());
            batchBindVars.add(currentBindVarRow);
            this.internal_logCacheDelete(gcGrouperSyncLog);
        }
        String connectionName = gcGrouperSyncLogs.iterator().next().getConnectionName();
        for (int rowDeleteCount : rowDeleteCounts = new GcDbAccess().connectionName(connectionName).sql("delete from grouper_sync_log where id = ?").batchBindVars(batchBindVars).batchSize(this.getGcGrouperSync().batchSize()).executeBatchSql()) {
            count += rowDeleteCount;
        }
        return count;
    }

    public int logDelete(GcGrouperSyncLog gcGrouperSyncLog) {
        if (gcGrouperSyncLog == null) {
            return 0;
        }
        this.internal_logCacheDelete(gcGrouperSyncLog);
        int count = 0;
        int rowDeleteCount = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where id = ?").bindVars(gcGrouperSyncLog.getId()).executeSql();
        return count += rowDeleteCount;
    }

    public int logDeleteAll() {
        this.internalCacheSyncLogs.clear();
        this.internalCacheSyncLogsById.clear();
        int rowDeleteCount = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
        return rowDeleteCount;
    }

    public List<GcGrouperSyncLog> logRetrieveAll() {
        if (!this.logRetrievedAllObjectsFromDb) {
            for (GcGrouperSyncLog gcGrouperSyncLog : this.internal_logRetrieveFromDbAll()) {
                this.internal_logCacheAdd(gcGrouperSyncLog);
            }
            this.logRetrievedAllObjectsFromDb = true;
        }
        return new ArrayList<GcGrouperSyncLog>(this.internalCacheSyncLogs.values());
    }

    public GcGrouperSyncLog logRetrieveById(String gcGrouperSyncLogId) {
        GcGrouperSyncLog gcGrouperSyncLog = this.internalCacheSyncLogsById.get(gcGrouperSyncLogId);
        if (gcGrouperSyncLog == null) {
            gcGrouperSyncLog = this.internal_logRetrieveFromDbById(gcGrouperSyncLogId);
        }
        return gcGrouperSyncLog;
    }

    private void internal_logCacheAdd(GcGrouperSyncLog gcGrouperSyncLog) {
        if (gcGrouperSyncLog.getGrouperSyncOwnerId() != null) {
            this.internalCacheSyncLogs.put(gcGrouperSyncLog.getGrouperSyncOwnerId(), gcGrouperSyncLog);
        }
        if (gcGrouperSyncLog.getId() != null) {
            this.internalCacheSyncLogsById.put(gcGrouperSyncLog.getId(), gcGrouperSyncLog);
        }
    }

    public void internal_logCacheDelete(GcGrouperSyncLog gcGrouperSyncLog) {
        if (gcGrouperSyncLog.getGrouperSyncOwnerId() != null) {
            this.internalCacheSyncLogs.remove(gcGrouperSyncLog.getGrouperSyncOwnerId());
        }
        if (gcGrouperSyncLog.getId() != null) {
            this.internalCacheSyncLogsById.remove(gcGrouperSyncLog.getId());
        }
    }

    public void internal_logCacheDeleteByOwnerId(String ownerId) {
        for (GcGrouperSyncLog gcGrouperSyncLog : new HashSet<GcGrouperSyncLog>(this.internalCacheSyncLogs.values())) {
            if (!GrouperClientUtils.equals(ownerId, gcGrouperSyncLog.getGrouperSyncOwnerId())) continue;
            this.internal_logCacheDelete(gcGrouperSyncLog);
        }
    }

    public void internal_logCacheDeleteByMembershipSyncGroupId(String syncGroupId) {
        for (GcGrouperSyncLog gcGrouperSyncLog : new HashSet<GcGrouperSyncLog>(this.internalCacheSyncLogs.values())) {
            GcGrouperSyncMembership gcGrouperSyncMembership = this.gcGrouperSync.getGcGrouperSyncMembershipDao().internal_membershipRetrieveFromCacheById(gcGrouperSyncLog.getGrouperSyncOwnerId());
            if (gcGrouperSyncMembership == null || !GrouperClientUtils.equals(syncGroupId, gcGrouperSyncMembership.getGrouperSyncGroupId())) continue;
            this.internal_logCacheDelete(gcGrouperSyncLog);
        }
    }

    public void internal_logCacheDeleteByMembershipSyncMemberId(String syncMemberId) {
        for (GcGrouperSyncLog gcGrouperSyncLog : new HashSet<GcGrouperSyncLog>(this.internalCacheSyncLogs.values())) {
            GcGrouperSyncMembership gcGrouperSyncMembership = this.gcGrouperSync.getGcGrouperSyncMembershipDao().internal_membershipRetrieveFromCacheById(gcGrouperSyncLog.getGrouperSyncOwnerId());
            if (gcGrouperSyncMembership == null || !GrouperClientUtils.equals(syncMemberId, gcGrouperSyncMembership.getGrouperSyncMemberId())) continue;
            this.internal_logCacheDelete(gcGrouperSyncLog);
        }
    }

    public void internal_logCacheDeleteByOwnerIds(Set<String> ownerIds) {
        for (GcGrouperSyncLog gcGrouperSyncLog : new HashSet<GcGrouperSyncLog>(this.internalCacheSyncLogs.values())) {
            if (!ownerIds.contains(gcGrouperSyncLog.getGrouperSyncOwnerId())) continue;
            this.internal_logCacheDelete(gcGrouperSyncLog);
        }
    }

    public List<GcGrouperSyncLog> internal_logRetrieveFromDbAll() {
        this.internalCacheSyncLogs.clear();
        this.internalCacheSyncLogsById.clear();
        List<GcGrouperSyncLog> gcGrouperSyncLogList = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_log where grouper_sync_id = ?").addBindVar(this.getGcGrouperSync().getId()).selectList(GcGrouperSyncLog.class);
        for (GcGrouperSyncLog gcGrouperSyncLog : gcGrouperSyncLogList) {
            gcGrouperSyncLog.setGrouperSync(this.getGcGrouperSync());
            this.internal_logCacheAdd(gcGrouperSyncLog);
        }
        return gcGrouperSyncLogList;
    }

    public List<GcGrouperSyncLog> internal_logRetrieveFromDbByOwnerId(String ownerId) {
        List<GcGrouperSyncLog> gcGrouperSyncLogs = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_log where grouper_sync_owner_id = ?").addBindVar(ownerId).selectList(GcGrouperSyncLog.class);
        for (GcGrouperSyncLog gcGrouperSyncLog : gcGrouperSyncLogs) {
            gcGrouperSyncLog.setGrouperSync(this.getGcGrouperSync());
            this.internal_logCacheAdd(gcGrouperSyncLog);
        }
        return gcGrouperSyncLogs;
    }

    public Map<String, GcGrouperSyncLog> internal_logRetrieveFromDbByOwnerIds(Collection<String> grouperGroupIdsCollection) {
        HashMap<String, GcGrouperSyncLog> result = new HashMap<String, GcGrouperSyncLog>();
        if (GrouperClientUtils.length(grouperGroupIdsCollection) == 0) {
            return result;
        }
        ArrayList<String> groupIdsList = new ArrayList<String>(grouperGroupIdsCollection);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(groupIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<String> batchOfGroupIds = GrouperClientUtils.batchList(groupIdsList, batchSize, batchIndex);
            String sql = "select * from grouper_sync_log where grouper_sync_owner_id in ( " + GrouperClientUtils.appendQuestions(batchOfGroupIds.size()) + ")";
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql(sql);
            for (String groupId : batchOfGroupIds) {
                gcDbAccess.addBindVar(groupId);
            }
            List<GcGrouperSyncLog> gcGrouperSyncGroups = gcDbAccess.selectList(GcGrouperSyncLog.class);
            for (GcGrouperSyncLog gcGrouperSyncGroup : GrouperClientUtils.nonNull(gcGrouperSyncGroups)) {
                result.put(gcGrouperSyncGroup.getGrouperSyncOwnerId(), gcGrouperSyncGroup);
                gcGrouperSyncGroup.setGrouperSync(this.getGcGrouperSync());
                this.internal_logCacheAdd(gcGrouperSyncGroup);
            }
        }
        return result;
    }

    public GcGrouperSyncLog internal_logRetrieveFromDbById(String gcGrouperSyncGroupId) {
        GcGrouperSyncLog gcGrouperSyncGroup = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_log where id = ?").addBindVar(gcGrouperSyncGroupId).select(GcGrouperSyncLog.class);
        if (gcGrouperSyncGroup != null) {
            gcGrouperSyncGroup.setGrouperSync(this.getGcGrouperSync());
            this.internal_logCacheAdd(gcGrouperSyncGroup);
        }
        return gcGrouperSyncGroup;
    }

    public Map<String, GcGrouperSyncLog> internal_logRetrieveFromDbByIds(Collection<String> syncLogIdsCollection) {
        HashMap<String, GcGrouperSyncLog> result = new HashMap<String, GcGrouperSyncLog>();
        if (GrouperClientUtils.length(syncLogIdsCollection) == 0) {
            return result;
        }
        ArrayList<String> syncIdsList = new ArrayList<String>(syncLogIdsCollection);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(syncIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<String> batchOfSyncIds = GrouperClientUtils.batchList(syncIdsList, batchSize, batchIndex);
            String sql = "select * from grouper_sync_log where grouper_sync_id = ? and id in ( " + GrouperClientUtils.appendQuestions(batchOfSyncIds.size()) + ")";
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql(sql).addBindVar(this.getGcGrouperSync().getId());
            for (String logId : batchOfSyncIds) {
                gcDbAccess.addBindVar(logId);
            }
            List<GcGrouperSyncLog> gcGrouperSyncLogs = gcDbAccess.selectList(GcGrouperSyncLog.class);
            for (GcGrouperSyncLog gcGrouperSyncLog : GrouperClientUtils.nonNull(gcGrouperSyncLogs)) {
                result.put(gcGrouperSyncLog.getId(), gcGrouperSyncLog);
                gcGrouperSyncLog.setGrouperSync(this.getGcGrouperSync());
                this.internal_logCacheAdd(gcGrouperSyncLog);
            }
        }
        return result;
    }

    public GcGrouperSync getGcGrouperSync() {
        return this.gcGrouperSync;
    }

    public void setGcGrouperSync(GcGrouperSync gcGrouperSync) {
        this.gcGrouperSync = gcGrouperSync;
    }

    public int internal_logStoreAll() {
        return this.internal_logStore(this.internalCacheSyncLogs.values());
    }

    public int internal_logStore(Collection<GcGrouperSyncLog> gcGrouperSyncLogs) {
        if (GrouperClientUtils.length(gcGrouperSyncLogs) == 0) {
            return 0;
        }
        int batchSize = this.getGcGrouperSync().batchSize();
        ArrayList<GcGrouperSyncLog> gcGrouperSyncLogsList = new ArrayList<GcGrouperSyncLog>(gcGrouperSyncLogs);
        for (GcGrouperSyncLog gcGrouperSyncGroup : GrouperClientUtils.nonNull(gcGrouperSyncLogs)) {
            gcGrouperSyncGroup.storePrepare();
        }
        int changes = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).storeBatchToDatabase(gcGrouperSyncLogsList, batchSize);
        for (GcGrouperSyncLog gcGrouperSyncLog : GrouperClientUtils.nonNull(gcGrouperSyncLogs)) {
            this.internal_logCacheAdd(gcGrouperSyncLog);
        }
        return changes;
    }

    public void internal_logStore(GcGrouperSyncLog gcGrouperSyncLog) {
        gcGrouperSyncLog.storePrepare();
        new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).storeToDatabase(gcGrouperSyncLog);
    }
}

