/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcResultSetCallback;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncColumnMetadata;
import edu.internet2.middleware.grouperClient.util.ExpirableCache;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.StringUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GcTableSyncTableMetadata {
    private List<GcTableSyncColumnMetadata> nonPrimaryKey;
    private GcTableSyncColumnMetadata incrementalProgressColumn;
    private List<GcTableSyncColumnMetadata> primaryKeyColumns;
    private Map<String, GcTableSyncColumnMetadata> columnUpperNameToGcColumnMetadata;
    private static ExpirableCache<MultiKey, GcTableSyncTableMetadata> metadataCache = null;
    private String connectionName;
    private String connectionNameOrReadonly;
    private String tableName;
    private List<GcTableSyncColumnMetadata> columnMetadata;
    private List<GcTableSyncColumnMetadata> columns;
    private GcTableSyncColumnMetadata groupColumn;
    private GcTableSyncColumnMetadata changeFlagColumn;
    private GcTableSyncColumnMetadata incrementalAllCoumnsColumn;

    public String queryWherePrimaryKey() {
        if (GrouperClientUtils.length(this.getPrimaryKey()) == 0) {
            throw new RuntimeException("No primary key for '" + this.tableName + "'!");
        }
        boolean first = true;
        StringBuilder result = new StringBuilder();
        for (GcTableSyncColumnMetadata gcTableSyncColumnMetadata : this.getPrimaryKey()) {
            if (!first) {
                result.append(" and ");
            }
            result.append(" ").append(gcTableSyncColumnMetadata.getColumnName()).append(" = ? ");
            first = false;
        }
        return result.toString();
    }

    public String queryUpdateNonPrimaryKey() {
        if (GrouperClientUtils.length(this.getNonPrimaryKey()) == 0) {
            throw new RuntimeException("No non-primary key for '" + this.tableName + "'!");
        }
        boolean first = true;
        StringBuilder result = new StringBuilder();
        for (GcTableSyncColumnMetadata gcTableSyncColumnMetadata : this.getNonPrimaryKey()) {
            if (!first) {
                result.append(" , ");
            }
            result.append(" ").append(gcTableSyncColumnMetadata.getColumnName()).append(" = ? ");
            first = false;
        }
        return result.toString();
    }

    public GcTableSyncColumnMetadata getIncrementalProgressColumn() {
        return this.incrementalProgressColumn;
    }

    public void setIncrementalProgressColumn(GcTableSyncColumnMetadata incrementalProgressColumn1) {
        this.incrementalProgressColumn = incrementalProgressColumn1;
    }

    public void assignIncrementalProgressColumn(String incrementalProgressColumnName) {
        this.incrementalProgressColumn = this.lookupColumn(incrementalProgressColumnName, true);
    }

    public List<GcTableSyncColumnMetadata> lookupColumns(String columnNames) {
        if (StringUtils.isBlank(columnNames)) {
            throw new RuntimeException("Pass in columns for " + this.getConnectionName() + " -> " + this.getTableName());
        }
        ArrayList<GcTableSyncColumnMetadata> result = new ArrayList<GcTableSyncColumnMetadata>();
        if (StringUtils.equals(columnNames, "*")) {
            result.addAll(this.getColumnMetadata());
        } else {
            for (String columnName : GrouperClientUtils.splitTrim(columnNames, ",")) {
                GcTableSyncColumnMetadata gcTableSyncColumnMetadata = this.lookupColumn(columnName, true);
                result.add(gcTableSyncColumnMetadata);
            }
        }
        return result;
    }

    public GcTableSyncColumnMetadata lookupColumn(String columnName, boolean exceptionOnNotFound) {
        GcTableSyncColumnMetadata gcTableSyncColumnMetadata;
        if (this.columnUpperNameToGcColumnMetadata == null) {
            if (GrouperClientUtils.length(this.columnMetadata) == 0) {
                throw new RuntimeException("Cant find table metadata for " + this.connectionName + " -> " + this.tableName + "!");
            }
            HashMap<String, GcTableSyncColumnMetadata> tempColumnUpperNameToGcColumnMetadata = new HashMap<String, GcTableSyncColumnMetadata>();
            for (GcTableSyncColumnMetadata gcTableSyncColumnMetadata2 : this.columnMetadata) {
                tempColumnUpperNameToGcColumnMetadata.put(gcTableSyncColumnMetadata2.getColumnName().toUpperCase(), gcTableSyncColumnMetadata2);
            }
            this.columnUpperNameToGcColumnMetadata = tempColumnUpperNameToGcColumnMetadata;
        }
        if ((gcTableSyncColumnMetadata = this.columnUpperNameToGcColumnMetadata.get(columnName.toUpperCase())) == null && exceptionOnNotFound) {
            throw new RuntimeException("Cant find " + this.connectionName + " -> " + this.tableName + " -> " + columnName);
        }
        return gcTableSyncColumnMetadata;
    }

    private static ExpirableCache<MultiKey, GcTableSyncTableMetadata> metadataCache() {
        if (metadataCache == null) {
            metadataCache = new ExpirableCache(GrouperClientConfig.retrieveConfig().propertyValueInt("tableSyncMetadataCacheMinutes", 10));
        }
        return metadataCache;
    }

    public static GcTableSyncTableMetadata retrieveTableMetadataFromCacheOrDatabase(String connectionName, String tableName) {
        MultiKey multiKey = new MultiKey(connectionName, tableName);
        GcTableSyncTableMetadata gcTableSyncTableMetadata = GcTableSyncTableMetadata.metadataCache().get(multiKey);
        if (gcTableSyncTableMetadata != null) {
            return gcTableSyncTableMetadata;
        }
        gcTableSyncTableMetadata = GcTableSyncTableMetadata.retrieveTableMetadataFromDatabase(connectionName, tableName);
        GcTableSyncTableMetadata.metadataCache().put(multiKey, gcTableSyncTableMetadata);
        return gcTableSyncTableMetadata;
    }

    public static GcTableSyncTableMetadata retrieveTableMetadataFromDatabase(String theConnectionName, String tableName) {
        if (GrouperClientUtils.isBlank(tableName)) {
            throw new RuntimeException("tableName cannot be blank");
        }
        if (GrouperClientUtils.isBlank(theConnectionName)) {
            throw new RuntimeException("connectionName cannot be blank");
        }
        GcTableSyncTableMetadata gcTableSyncTableMetadata = new GcTableSyncTableMetadata();
        gcTableSyncTableMetadata.setConnectionName(theConnectionName);
        gcTableSyncTableMetadata.setTableName(tableName);
        String sql = "select * from " + tableName + " where 1 != 1";
        final ArrayList<GcTableSyncColumnMetadata> gcTableSyncColumnMetadatas = new ArrayList<GcTableSyncColumnMetadata>();
        gcTableSyncTableMetadata.setColumnMetadata(gcTableSyncColumnMetadatas);
        new GcDbAccess().connectionName(theConnectionName).sql(sql).callbackResultSet(new GcResultSetCallback(){

            public Object callback(ResultSet resultSet) throws Exception {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                block5: for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    GcTableSyncColumnMetadata gcTableSyncColumnMetadata = new GcTableSyncColumnMetadata();
                    gcTableSyncColumnMetadatas.add(gcTableSyncColumnMetadata);
                    String columnName = resultSetMetaData.getColumnName(i + 1);
                    int dataType = resultSetMetaData.getColumnType(i + 1);
                    String typeName = resultSetMetaData.getColumnTypeName(i + 1);
                    gcTableSyncColumnMetadata.setColumnIndexZeroIndexed(i);
                    gcTableSyncColumnMetadata.setColumnName(columnName);
                    switch (dataType) {
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            gcTableSyncColumnMetadata.setColumnType(GcTableSyncColumnMetadata.ColumnType.NUMERIC);
                            int precision = resultSetMetaData.getPrecision(i + 1);
                            gcTableSyncColumnMetadata.setPrecision(precision);
                            int scale = resultSetMetaData.getScale(i + 1);
                            gcTableSyncColumnMetadata.setScale(scale);
                            continue block5;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            gcTableSyncColumnMetadata.setColumnType(GcTableSyncColumnMetadata.ColumnType.STRING);
                            int columnDisplaySize = resultSetMetaData.getColumnDisplaySize(i + 1);
                            gcTableSyncColumnMetadata.setColumnDisplaySize(columnDisplaySize);
                            continue block5;
                        }
                        case 91: 
                        case 93: {
                            gcTableSyncColumnMetadata.setColumnType(GcTableSyncColumnMetadata.ColumnType.TIMESTAMP);
                            continue block5;
                        }
                        default: {
                            throw new RuntimeException("Type not supported: " + dataType + ", " + typeName);
                        }
                    }
                }
                Collections.sort(gcTableSyncColumnMetadatas, new Comparator<GcTableSyncColumnMetadata>(){

                    @Override
                    public int compare(GcTableSyncColumnMetadata o1, GcTableSyncColumnMetadata o2) {
                        if (o1 == o2) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return o1.getColumnName().compareTo(o2.getColumnName());
                    }
                });
                return null;
            }
        });
        if (gcTableSyncColumnMetadatas.size() == 0) {
            throw new RuntimeException("Cant find table metadata for '" + tableName + "' in grouper.client.properties database: '" + theConnectionName + "'");
        }
        return gcTableSyncTableMetadata;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getConnectionNameOrReadonly() {
        return this.connectionNameOrReadonly;
    }

    public void setConnectionNameOrReadonly(String connectionNameOrReadonly1) {
        this.connectionNameOrReadonly = connectionNameOrReadonly1;
    }

    public GcTableSyncColumnMetadata getIncrementalAllCoumnsColumn() {
        return this.incrementalAllCoumnsColumn;
    }

    public void setIncrementalAllCoumnsColumn(GcTableSyncColumnMetadata incrementalAllCoumnsColumn1) {
        this.incrementalAllCoumnsColumn = incrementalAllCoumnsColumn1;
    }

    public GcTableSyncColumnMetadata getChangeFlagColumn() {
        return this.changeFlagColumn;
    }

    public void setChangeFlagColumn(GcTableSyncColumnMetadata changeFlagColumn1) {
        this.changeFlagColumn = changeFlagColumn1;
    }

    public List<GcTableSyncColumnMetadata> getColumnMetadata() {
        return this.columnMetadata;
    }

    public void setColumnMetadata(List<GcTableSyncColumnMetadata> columnMetadata1) {
        this.columnMetadata = columnMetadata1;
    }

    public void assignPrimaryKeyColumns(String theColumns) {
        this.primaryKeyColumns = this.lookupColumns(theColumns);
    }

    public List<GcTableSyncColumnMetadata> getColumns() {
        return this.columns;
    }

    public List<GcTableSyncColumnMetadata> getNonPrimaryKey() {
        if (this.nonPrimaryKey == null) {
            ArrayList<GcTableSyncColumnMetadata> result = new ArrayList<GcTableSyncColumnMetadata>();
            result.addAll(this.getColumns());
            result.removeAll(this.getPrimaryKey());
            this.nonPrimaryKey = result;
        }
        return this.nonPrimaryKey;
    }

    public List<GcTableSyncColumnMetadata> getPrimaryKey() {
        return this.primaryKeyColumns;
    }

    public void assignColumns(String theColumns) {
        this.columns = this.lookupColumns(theColumns);
    }

    public String columnListAll() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (GcTableSyncColumnMetadata gcTableSyncColumnMetadata : GrouperClientUtils.nonNull(this.columns)) {
            if (!first) {
                result.append(", ");
            }
            result.append(gcTableSyncColumnMetadata.getColumnName());
            first = false;
        }
        return result.toString();
    }

    public String columnListPrimaryKeyAndChangeFlagAndOptionalIncrementalProgress() {
        StringBuilder result = new StringBuilder();
        HashSet<String> columnNames = new HashSet<String>();
        boolean first = true;
        for (GcTableSyncColumnMetadata gcTableSyncColumnMetadata : GrouperClientUtils.nonNull(this.columns)) {
            if (!first) {
                result.append(", ");
            }
            result.append(gcTableSyncColumnMetadata.getColumnName());
            columnNames.add(gcTableSyncColumnMetadata.getColumnName());
            first = false;
        }
        if (!columnNames.contains(this.getChangeFlagColumn().getColumnName())) {
            result.append(", ");
            result.append(this.getChangeFlagColumn().getColumnName());
            columnNames.add(this.getChangeFlagColumn().getColumnName());
        }
        if (this.getIncrementalAllCoumnsColumn() != null && !columnNames.contains(this.getIncrementalAllCoumnsColumn().getColumnName())) {
            result.append(", ");
            result.append(this.getIncrementalAllCoumnsColumn().getColumnName());
            columnNames.add(this.getChangeFlagColumn().getColumnName());
        }
        return result.toString();
    }

    public String columnListInputtedColumnsAndIncrementalProgressColumn(List<GcTableSyncColumnMetadata> otherTablePrimaryKey) {
        StringBuilder result = new StringBuilder();
        for (GcTableSyncColumnMetadata gcTableSyncColumnMetadataOther : otherTablePrimaryKey) {
            GcTableSyncColumnMetadata gcTableSyncColumnMetadataThis = this.lookupColumn(gcTableSyncColumnMetadataOther.getColumnName(), true);
            result.append(gcTableSyncColumnMetadataThis.getColumnName());
            result.append(", ");
        }
        result.append(this.getIncrementalProgressColumn().getColumnName());
        return result.toString();
    }

    public void setColumns(List<GcTableSyncColumnMetadata> columns1) {
        this.columns = columns1;
    }

    public void assignGroupColumn(String groupColumnName) {
        this.groupColumn = this.lookupColumn(groupColumnName, true);
    }

    public void assignChangeFlagColumn(String changeFlagColumnName) {
        this.changeFlagColumn = this.lookupColumn(changeFlagColumnName, true);
    }

    public GcTableSyncColumnMetadata getGroupColumnMetadata() {
        return this.groupColumn;
    }

    public void assignIncrementalAllCoumnsColumn(String incrementalAllColumnsColumnName) {
        this.incrementalAllCoumnsColumn = this.lookupColumn(incrementalAllColumnsColumnName, true);
    }
}

