/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.common;

import edu.psu.swe.commons.jaxrs.common.Version;
import edu.psu.swe.commons.jaxrs.utilities.ManifestUtil;
import java.io.IOException;
import java.util.jar.Manifest;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="version")
public class VersionResource {
    private static final Logger LOG = LoggerFactory.getLogger(VersionResource.class);
    private Class<? extends Object> clazz;

    public VersionResource() {
        LOG.warn("Version endpoint was not initialized correctly, please add the VersionResource instance to the RestApplication singleton list.");
    }

    public VersionResource(Class<? extends Object> clazz) {
        this.clazz = clazz;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Version getVersion() throws IOException {
        if (this.clazz == null) {
            LOG.warn("unable to determine version information, please add the VersionResource instance to the RestApplication singleton list.");
            throw new NotFoundException("Version endpoint not found");
        }
        Manifest manifest = ManifestUtil.locateManifest(this.clazz);
        Version version = ManifestUtil.getVersionInfo(manifest);
        return version;
    }
}

