/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.exceptions.mappers;

import edu.psu.swe.commons.jaxrs.ErrorMessage;
import edu.psu.swe.commons.jaxrs.exceptions.ConflictException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger log = LoggerFactory.getLogger(WebApplicationExceptionMapper.class);

    public Response toResponse(WebApplicationException e) {
        boolean includeExceptionMessage = false;
        ErrorMessage em = new ErrorMessage(Response.Status.BAD_REQUEST);
        if (e.getClass().equals(BadRequestException.class)) {
            em.setStatus(Response.Status.BAD_REQUEST);
            includeExceptionMessage = true;
            log.info(e.getMessage());
        } else if (e.getClass().equals(NotFoundException.class)) {
            em.setStatus(Response.Status.NOT_FOUND);
            includeExceptionMessage = true;
            log.info(e.getMessage());
        } else if (e.getClass().equals(ForbiddenException.class)) {
            em.setStatus(Response.Status.FORBIDDEN);
            includeExceptionMessage = true;
            log.info(e.getMessage());
        } else if (e.getClass().equals(NotAuthorizedException.class)) {
            em.setStatus(Response.Status.UNAUTHORIZED);
            includeExceptionMessage = true;
            log.info(e.getMessage());
        } else if (e.getClass().equals(ConflictException.class)) {
            em.setStatus(Response.Status.CONFLICT);
            includeExceptionMessage = true;
            log.info(e.getMessage());
        } else {
            em.setStatus(Response.Status.INTERNAL_SERVER_ERROR);
            log.error(e.getMessage(), (Throwable)e);
        }
        if (includeExceptionMessage) {
            em.addErrorMessage(e.getMessage());
        }
        Response response = em.toResponse();
        return response;
    }
}

