/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.filter;

import java.io.IOException;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
public class IncomingLogFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncomingLogFilter.class);
    @Context
    UriInfo uriInfo;
    @Context
    SecurityContext securityContext;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        LocalDateTime requestDate = LocalDateTime.ofInstant(requestContext.getDate().toInstant(), ZoneId.systemDefault());
        String method = requestContext.getMethod();
        MediaType mediaType = requestContext.getMediaType();
        MultivaluedMap pathParams = this.uriInfo.getPathParameters();
        for (Object me : pathParams.entrySet()) {
            LOGGER.info((String)me.getKey());
            for (Object s : (List)me.getValue()) {
                LOGGER.info("    " + (String)s);
            }
        }
        MultivaluedMap headers = requestContext.getHeaders();
        for (Object me : headers.entrySet()) {
            LOGGER.info((String)me.getKey());
            for (Object s : (List)me.getValue()) {
                LOGGER.info("    " + (String)s);
            }
        }
        MultivaluedMap queryParameters = this.uriInfo.getQueryParameters();
        for (Map.Entry me : queryParameters.entrySet()) {
            LOGGER.info((String)me.getKey());
            for (String s : (List)me.getValue()) {
                LOGGER.info("    " + s);
            }
        }
        String absolutePath = this.uriInfo.getAbsolutePath().toString();
        Principal principal = this.securityContext.getUserPrincipal();
        String principalName = principal.getName();
    }
}

