/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.hateoas.interceptor;

import edu.psu.swe.commons.jaxrs.AtomLink;
import edu.psu.swe.commons.jaxrs.hateoas.annotations.AddHateoasLinks;
import edu.psu.swe.commons.jaxrs.hateoas.annotations.Link;
import edu.psu.swe.commons.jaxrs.hateoas.annotations.Links;
import edu.psu.swe.commons.jaxrs.hateoas.model.HateoasModel;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@AddHateoasLinks
public class HateoasWriteInterceptor
implements WriterInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HateoasWriteInterceptor.class);
    @Context
    private UriInfo uriInfo;

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LOGGER.debug("Entered HatoesWriteInterceptor");
        if (context.getEntity() instanceof HateoasModel) {
            this.processLinkAnnotations(context.getEntity());
        } else if (context.getEntity() instanceof List) {
            List objects = (List)context.getEntity();
            for (Object o : objects) {
                if (!(o instanceof HateoasModel)) continue;
                this.processLinkAnnotations(o);
            }
        }
        context.proceed();
    }

    private void processLinkAnnotations(Object object) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = object.getClass().getAnnotations()) {
            if (annotation instanceof Links) {
                Links linksAnnotation = (Links)annotation;
                for (Link linkAnnotation : linksAnnotation.value()) {
                    this.addAtomLink(linkAnnotation, object);
                }
                continue;
            }
            if (!(annotation instanceof Link)) continue;
            this.addAtomLink((Link)annotation, object);
        }
    }

    private void addAtomLink(Link linkAnnotation, Object object) {
        HateoasModel instance = (HateoasModel)object;
        AtomLink atomLink = new AtomLink();
        atomLink.setRelation(linkAnnotation.rel());
        if (atomLink.getTitle() != null) {
            atomLink.setTitle(linkAnnotation.title());
        }
        String path = linkAnnotation.path();
        String pattern = "\\{(.*?)\\}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(path);
        while (m.find()) {
            String methodName = m.group(1);
            try {
                Method method = object.getClass().getMethod(methodName, new Class[0]);
                Object value = method.invoke(object, new Object[0]);
                if (value == null) {
                    return;
                }
                String methodPattern = "\\{" + methodName + "\\}";
                path = path.replaceAll(methodPattern, value.toString());
            }
            catch (Exception e) {
                LOGGER.error("Error find method " + methodName + " : " + e.getMessage());
                return;
            }
        }
        if (path != null && !path.trim().isEmpty()) {
            atomLink.setHyperlink(this.uriInfo.getBaseUri() + path);
            instance.getLinks().add(atomLink);
        }
    }
}

