/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.patch;

import com.fasterxml.jackson.databind.JsonNode;
import edu.psu.swe.commons.jaxrs.patch.JsonReference;
import edu.psu.swe.commons.jaxrs.patch.PatchOperation;
import edu.psu.swe.commons.jaxrs.patch.PropertyTraversalException;
import edu.psu.swe.commons.jaxrs.patch.exception.FailedOperationException;
import edu.psu.swe.commons.jaxrs.patch.exception.PatchOperationFailedException;
import edu.psu.swe.commons.jaxrs.patch.exception.PatchTestFailedException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class PatchRequest {
    ArrayList<PatchOperation> patchOperationList;

    public PatchRequest(List<PatchOperation> patchOperationList) {
        this.patchOperationList = new ArrayList<PatchOperation>(patchOperationList);
    }

    public void apply(Object object) throws PatchOperationFailedException, PatchTestFailedException {
        int operationNumber = 0;
        try {
            for (PatchOperation patchOperation : this.patchOperationList) {
                JsonReference path = patchOperation.getPath().pointer;
                if (path == null) {
                    throw new PatchOperationFailedException(operationNumber, "path is null");
                }
                JsonNode value = patchOperation.getValue();
                switch (patchOperation.getOperation()) {
                    case ADD: {
                        path.add(object, null, value);
                        break;
                    }
                    case COPY: {
                        throw new PatchOperationFailedException(operationNumber, "copy: not implemented");
                    }
                    case MOVE: {
                        throw new PatchOperationFailedException(operationNumber, "move: not implemented");
                    }
                    case REMOVE: {
                        path.remove(object, null, value);
                        break;
                    }
                    case REPLACE: {
                        path.set(object, null, value);
                        break;
                    }
                    case TEST: {
                        if (path.test(object, null, value)) break;
                        throw new PatchTestFailedException(operationNumber, "A test did not pass");
                    }
                }
                ++operationNumber;
            }
        }
        catch (PropertyTraversalException | FailedOperationException operationException) {
            throw new PatchOperationFailedException(operationNumber, (Throwable)operationException);
        }
    }
}

