/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.baseline;

import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.cli.JunkKt;
import io.gitlab.arturbosch.detekt.cli.baseline.Baseline;
import io.gitlab.arturbosch.detekt.cli.baseline.BaselineFormat;
import io.gitlab.arturbosch.detekt.cli.baseline.Blacklist;
import io.gitlab.arturbosch.detekt.cli.baseline.Whitelist;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/cli/baseline/BaselineFacade;", "", "baselineFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "listings", "Lkotlin/Pair;", "Lio/gitlab/arturbosch/detekt/cli/baseline/Whitelist;", "Lio/gitlab/arturbosch/detekt/cli/baseline/Blacklist;", "baselineExists", "", "create", "", "smells", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "filter", "detekt-cli"})
public final class BaselineFacade {
    private final Pair<Whitelist, Blacklist> listings;
    private final Path baselineFile;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Finding> filter(@NotNull List<? extends Finding> smells) {
        List<Finding> list;
        Intrinsics.checkParameterIsNotNull(smells, (String)"smells");
        if (this.listings != null) {
            void var3_2;
            void $this$filterNotTo$iv$iv;
            void $this$filterNotTo$iv$iv2;
            Iterable $this$filterNot$iv = smells;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                Finding finding = (Finding)element$iv$iv;
                boolean bl = false;
                if (((Whitelist)this.listings.getFirst()).getIds().contains(JunkKt.getBaselineId(finding))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List whiteFiltered = (List)destination$iv$iv;
            Iterable $this$filterNot$iv2 = whiteFiltered;
            boolean $i$f$filterNot2 = false;
            destination$iv$iv = $this$filterNot$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo2 = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Finding finding = (Finding)element$iv$iv;
                boolean bl = false;
                if (((Blacklist)this.listings.getSecond()).getIds().contains(JunkKt.getBaselineId(finding))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List blackFiltered = (List)destination$iv$iv2;
            list = var3_2;
        } else {
            list = smells;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void create(@NotNull List<? extends Finding> smells) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(smells, (String)"smells");
        Blacklist blacklist = this.baselineExists() ? new BaselineFormat().read(this.baselineFile).getBlacklist() : new Blacklist(SetsKt.emptySet());
        Iterable $this$map$iv = smells;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Finding finding = (Finding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = JunkKt.getBaselineId((Finding)it);
            collection.add(string);
        }
        SortedSet ids = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
        Baseline smellBaseline = new Baseline(blacklist, new Whitelist(ids));
        Path path = this.baselineFile.getParent();
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            boolean bl2 = false;
            Path it = path2;
            boolean bl3 = false;
            Files.createDirectories(it, new FileAttribute[0]);
        }
        new BaselineFormat().write(smellBaseline, this.baselineFile);
    }

    private final boolean baselineExists() {
        return io.gitlab.arturbosch.detekt.core.JunkKt.exists((Path)this.baselineFile) && io.gitlab.arturbosch.detekt.core.JunkKt.isFile((Path)this.baselineFile);
    }

    public BaselineFacade(@NotNull Path baselineFile) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)baselineFile, (String)"baselineFile");
        this.baselineFile = baselineFile;
        if (this.baselineExists()) {
            Baseline format = new BaselineFormat().read(this.baselineFile);
            pair = TuplesKt.to((Object)format.getWhitelist(), (Object)format.getBlacklist());
        } else {
            pair = null;
        }
        this.listings = pair;
    }
}

