/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.baseline;

import io.gitlab.arturbosch.detekt.cli.baseline.Baseline;
import io.gitlab.arturbosch.detekt.cli.baseline.BaselineHandler;
import io.gitlab.arturbosch.detekt.cli.baseline.InvalidBaselineState;
import io.gitlab.arturbosch.detekt.cli.baseline.XmlExtensionsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0010\u001a\u00020\u000e*\u00020\u00112\u0006\u0010\u000f\u001a\u00020\nH\u0002R$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/cli/baseline/BaselineFormat;", "", "()V", "positions", "Lkotlin/Pair;", "", "Ljavax/xml/stream/XMLStreamException;", "getPositions", "(Ljavax/xml/stream/XMLStreamException;)Lkotlin/Pair;", "read", "Lio/gitlab/arturbosch/detekt/cli/baseline/Baseline;", "path", "Ljava/nio/file/Path;", "write", "", "baseline", "save", "Ljavax/xml/stream/XMLStreamWriter;", "detekt-cli"})
public final class BaselineFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Baseline read(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            Closeable closeable = Files.newInputStream(path, new OpenOption[0]);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                SAXParser reader = SAXParserFactory.newInstance().newSAXParser();
                BaselineHandler handler = new BaselineHandler();
                reader.parse(it, (DefaultHandler)handler);
                Baseline baseline = handler.createBaseline$detekt_cli();
                return baseline;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (SAXParseException error) {
            void line;
            Pair pair = TuplesKt.to((Object)error.getLineNumber(), (Object)error.getColumnNumber());
            int n = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            throw (Throwable)new InvalidBaselineState("Error on position " + (int)line + ':' + column + " while reading the baseline xml file!", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(@NotNull Baseline baseline, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)baseline, (String)"baseline");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            Closeable closeable = Files.newBufferedWriter(path, new OpenOption[0]);
            boolean bl = false;
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl2 = false;
                BufferedWriter bufferedWriter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"it");
                this.save(XmlExtensionsKt.prettyPrinter(XmlExtensionsKt.streamXml(bufferedWriter)), baseline);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (XMLStreamException error) {
            void line;
            Pair<Integer, Integer> pair = this.getPositions(error);
            int n = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            throw (Throwable)new InvalidBaselineState("Error on position " + (int)line + ':' + column + " while writing the baseline xml file!", error);
        }
    }

    private final Pair<Integer, Integer> getPositions(@NotNull XMLStreamException $this$positions) {
        Location location = $this$positions.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)location, (String)"location");
        Integer n = location.getLineNumber();
        Location location2 = $this$positions.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"location");
        return TuplesKt.to((Object)n, (Object)location2.getColumnNumber());
    }

    /*
     * WARNING - void declaration
     */
    private final void save(@NotNull XMLStreamWriter $this$save, Baseline baseline) {
        String it;
        void $this$tag$iv;
        void $this$tag$iv2;
        XMLStreamWriter $this$document$iv = $this$save;
        String version$iv = null;
        String encoding$iv = null;
        boolean $i$f$document = false;
        XMLStreamWriter xMLStreamWriter = $this$document$iv;
        boolean bl = false;
        boolean bl2 = false;
        XMLStreamWriter $this$apply$iv = xMLStreamWriter;
        boolean bl3 = false;
        $this$apply$iv.writeStartDocument();
        XMLStreamWriter $this$document = $this$apply$iv;
        boolean bl4 = false;
        XMLStreamWriter xMLStreamWriter2 = $this$document;
        String name$iv = "SmellBaseline";
        boolean $i$f$tag = false;
        void var17_17 = $this$tag$iv2;
        boolean bl5 = false;
        boolean bl6 = false;
        void $this$apply$iv2 = var17_17;
        boolean bl7 = false;
        $this$apply$iv2.writeStartElement(name$iv);
        void $this$tag = $this$apply$iv2;
        boolean bl8 = false;
        void var24_24 = $this$tag;
        String name$iv2 = "Blacklist";
        boolean $i$f$tag2 = false;
        void var27_27 = $this$tag$iv;
        boolean bl9 = false;
        boolean bl10 = false;
        void $this$apply$iv3 = var27_27;
        $i$a$-apply-XmlExtensionsKt$tag$1$iv = false;
        $this$apply$iv3.writeStartElement(name$iv2);
        void $this$tag2 = $this$apply$iv3;
        boolean bl11 = false;
        Iterable $this$forEach$iv = baseline.getBlacklist().getIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl12 = false;
            XmlExtensionsKt.tag((XMLStreamWriter)$this$tag2, "ID", it);
        }
        $this$apply$iv3.writeEndElement();
        $this$tag$iv = $this$tag;
        name$iv2 = "Whitelist";
        $i$f$tag2 = false;
        var27_27 = $this$tag$iv;
        bl9 = false;
        bl10 = false;
        $this$apply$iv3 = var27_27;
        $i$a$-apply-XmlExtensionsKt$tag$1$iv = false;
        $this$apply$iv3.writeStartElement(name$iv2);
        $this$tag2 = $this$apply$iv3;
        boolean bl13 = false;
        $this$forEach$iv = baseline.getWhitelist().getIds();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl14 = false;
            XmlExtensionsKt.tag((XMLStreamWriter)$this$tag2, "ID", it);
        }
        $this$apply$iv3.writeEndElement();
        $this$apply$iv2.writeEndElement();
        $this$apply$iv.writeEndDocument();
    }
}

