/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.runners;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.cli.BuildFailure;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.ConfigurationsKt;
import io.gitlab.arturbosch.detekt.cli.FilteredDetectionResult;
import io.gitlab.arturbosch.detekt.cli.IssueExtensionKt;
import io.gitlab.arturbosch.detekt.cli.OutputFacade;
import io.gitlab.arturbosch.detekt.cli.baseline.BaselineFacade;
import io.gitlab.arturbosch.detekt.cli.config.ConfigValidatorsKt;
import io.gitlab.arturbosch.detekt.cli.console.ColorizerKt;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import io.gitlab.arturbosch.detekt.core.DetektFacade;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import java.io.Closeable;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersion;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0016J)\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u00140\u0012\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0082\bJ\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/cli/runners/Runner;", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "arguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "outputPrinter", "Ljava/io/PrintStream;", "errorPrinter", "(Lio/gitlab/arturbosch/detekt/cli/CliArgs;Ljava/io/PrintStream;Ljava/io/PrintStream;)V", "checkBaselineCreation", "", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "checkBuildFailureThreshold", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "createSettings", "execute", "measure", "Lkotlin/Pair;", "", "T", "block", "Lkotlin/Function0;", "transformResult", "detekt-cli"})
public final class Runner
implements Executable {
    private final CliArgs arguments;
    private final PrintStream outputPrinter;
    private final PrintStream errorPrinter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute() {
        Closeable closeable = (Closeable)this.createSettings();
        boolean bl = false;
        Throwable throwable = null;
        try {
            void engineRunTime;
            void serviceLoadingTime;
            ProcessingSettings settings = (ProcessingSettings)closeable;
            boolean bl2 = false;
            Runner this_$iv = this;
            boolean $i$f$measure = false;
            long start$iv = System.currentTimeMillis();
            boolean bl3 = false;
            ConfigValidatorsKt.checkConfiguration(settings);
            Unit result$iv = Unit.INSTANCE;
            Pair pair = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
            long checkConfigTime = ((Number)pair.component1()).longValue();
            settings.debug((Function0)new Function0<String>(checkConfigTime){
                final /* synthetic */ long $checkConfigTime;

                @NotNull
                public final String invoke() {
                    return "Checking config took " + this.$checkConfigTime + " ms";
                }
                {
                    this.$checkConfigTime = l;
                    super(0);
                }
            });
            Runner this_$iv2 = this;
            boolean $i$f$measure2 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl4 = false;
            DetektFacade result$iv2 = DetektFacade.Companion.create(settings);
            Pair pair2 = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv2), (Object)result$iv2);
            long l = ((Number)pair2.component1()).longValue();
            DetektFacade facade = (DetektFacade)pair2.component2();
            settings.debug((Function0)new Function0<String>((long)serviceLoadingTime){
                final /* synthetic */ long $serviceLoadingTime;

                @NotNull
                public final String invoke() {
                    return "Loading services took " + this.$serviceLoadingTime + " ms";
                }
                {
                    this.$serviceLoadingTime = l;
                    super(0);
                }
            });
            pair2 = new Ref.LongRef();
            Runner this_$iv3 = this;
            boolean $i$f$measure3 = false;
            long start$iv3 = System.currentTimeMillis();
            boolean bl5 = false;
            Detektion result$iv3 = facade.run();
            Pair pair3 = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv3), (Object)result$iv3);
            pair2.element = ((Number)pair3.component1()).longValue();
            Detektion result = (Detektion)pair3.component2();
            settings.debug((Function0)new Function0<String>((Ref.LongRef)engineRunTime){
                final /* synthetic */ Ref.LongRef $engineRunTime;

                @NotNull
                public final String invoke() {
                    return "Running core engine took " + this.$engineRunTime.element + " ms";
                }
                {
                    this.$engineRunTime = longRef;
                    super(0);
                }
            });
            this.checkBaselineCreation(result);
            result = this.transformResult(result);
            Runner this_$iv4 = this;
            boolean $i$f$measure4 = false;
            long start$iv4 = System.currentTimeMillis();
            boolean bl6 = false;
            new OutputFacade(this.arguments, result, settings).run();
            Unit result$iv4 = Unit.INSTANCE;
            Pair pair4 = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv4), (Object)result$iv4);
            long outputResultsTime = ((Number)pair4.component1()).longValue();
            settings.debug((Function0)new Function0<String>(outputResultsTime){
                final /* synthetic */ long $outputResultsTime;

                @NotNull
                public final String invoke() {
                    return "Writing results took " + this.$outputResultsTime + " ms";
                }
                {
                    this.$outputResultsTime = l;
                    super(0);
                }
            });
            if (!this.arguments.getCreateBaseline()) {
                this.checkBuildFailureThreshold(result, settings);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Detektion transformResult(Detektion result) {
        Path baselineFile = this.arguments.getBaseline();
        return baselineFile != null ? (Detektion)new FilteredDetectionResult(result, new BaselineFacade(baselineFile)) : result;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBaselineCreation(Detektion result) {
        if (this.arguments.getCreateBaseline()) {
            void $this$flatMapTo$iv$iv;
            Map $this$flatMap$iv = result.getFindings();
            boolean $i$f$flatMap = false;
            Map map = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void var8_7 = $this$flatMapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var8_7.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Iterable list$iv$iv = (List)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List smells = (List)destination$iv$iv;
            Path path = this.arguments.getBaseline();
            if (path == null) {
                Intrinsics.throwNpe();
            }
            new BaselineFacade(path).create(smells);
        }
    }

    private final void checkBuildFailureThreshold(Detektion result, ProcessingSettings settings) {
        int amount = IssueExtensionKt.getOrComputeWeightedAmountOfIssues(result, settings.getConfig());
        int maxIssues = IssueExtensionKt.maxIssues(settings.getConfig());
        if (IssueExtensionKt.isValidAndSmallerOrEqual(maxIssues, amount)) {
            throw (Throwable)new BuildFailure(ColorizerKt.red("Build failed with " + amount + " weighted issues (threshold defined was " + maxIssues + ")."));
        }
    }

    private final <T> Pair<Long, T> measure(Function0<? extends T> block) {
        int $i$f$measure = 0;
        long start = System.currentTimeMillis();
        Object result = block.invoke();
        return TuplesKt.to((Object)(System.currentTimeMillis() - start), (Object)result);
    }

    /*
     * WARNING - void declaration
     */
    private final ProcessingSettings createSettings() {
        void settingsLoadTime;
        void configLoadTime;
        CliArgs cliArgs = this.arguments;
        boolean bl = false;
        boolean bl2 = false;
        CliArgs $this$with = cliArgs;
        boolean bl3 = false;
        Runner this_$iv = this;
        boolean $i$f$measure = false;
        long start$iv = System.currentTimeMillis();
        boolean bl4 = false;
        Config result$iv = ConfigurationsKt.loadConfiguration($this$with);
        Pair pair = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
        long l = ((Number)pair.component1()).longValue();
        Config configuration = (Config)pair.component2();
        Runner this_$iv2 = this;
        boolean $i$f$measure2 = false;
        long start$iv2 = System.currentTimeMillis();
        boolean bl5 = false;
        Collection<URI> collection = ConfigurationsKt.extractUris($this$with);
        PrintStream printStream = this.errorPrinter;
        PrintStream printStream2 = this.outputPrinter;
        boolean bl6 = this.arguments.getDebug();
        JvmTarget jvmTarget = $this$with.getJvmTarget();
        ExecutorService executorService = null;
        LanguageVersion languageVersion = $this$with.getLanguageVersion();
        List<String> list = ConfigurationsKt.createClasspath($this$with);
        List<Path> list2 = ConfigurationsKt.createPlugins($this$with);
        boolean bl7 = $this$with.getDisableDefaultRuleSets();
        boolean bl8 = $this$with.getAutoCorrect();
        ProcessingSettings result$iv2 = new ProcessingSettings($this$with.getInputPaths(), configuration, ConfigurationsKt.createFilters($this$with), $this$with.getParallel(), bl7, list2, list, languageVersion, jvmTarget, executorService, printStream2, printStream, bl8, bl6, collection, 512, null);
        Pair pair2 = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv2), (Object)result$iv2);
        long l2 = ((Number)pair2.component1()).longValue();
        ProcessingSettings settings = (ProcessingSettings)pair2.component2();
        settings.debug((Function0)new Function0<String>((long)configLoadTime){
            final /* synthetic */ long $configLoadTime;

            @NotNull
            public final String invoke() {
                return "Loading config took " + this.$configLoadTime + " ms";
            }
            {
                this.$configLoadTime = l;
                super(0);
            }
        });
        settings.debug((Function0)new Function0<String>((long)settingsLoadTime){
            final /* synthetic */ long $settingsLoadTime;

            @NotNull
            public final String invoke() {
                return "Creating settings took " + this.$settingsLoadTime + " ms";
            }
            {
                this.$settingsLoadTime = l;
                super(0);
            }
        });
        return settings;
    }

    public Runner(@NotNull CliArgs arguments, @NotNull PrintStream outputPrinter, @NotNull PrintStream errorPrinter) {
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)outputPrinter, (String)"outputPrinter");
        Intrinsics.checkParameterIsNotNull((Object)errorPrinter, (String)"errorPrinter");
        this.arguments = arguments;
        this.outputPrinter = outputPrinter;
        this.errorPrinter = errorPrinter;
    }

    public /* synthetic */ Runner(CliArgs cliArgs, PrintStream printStream, PrintStream printStream2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            PrintStream printStream3 = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream3, (String)"System.out");
            printStream = printStream3;
        }
        if ((n & 4) != 0) {
            PrintStream printStream4 = System.err;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream4, (String)"System.err");
            printStream2 = printStream4;
        }
        this(cliArgs, printStream, printStream2);
    }
}

