/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.MaxLineLengthRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.ParsedLine;
import com.pinterest.ktlint.ruleset.standard.rules.RangeTree;
import com.pinterest.ktlint.ruleset.standard.rules.TrailingCommaOnCallSiteRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.TrailingCommaOnDeclarationSiteRuleKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016Je\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042K\u0010\u0011\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\n0\u0012H\u0016J\f\u0010\u0019\u001a\u00020\u0004*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/MaxLineLengthRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "ignoreBackTickedIdentifier", "", "maxLineLength", "", "rangeTree", "Lcom/pinterest/ktlint/ruleset/standard/rules/RangeTree;", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isPartOfRawMultiLineString", "Companion", "ktlint-ruleset-standard"})
@SourceDebugExtension(value={"SMAP\nMaxLineLengthRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxLineLengthRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/MaxLineLengthRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MaxLineLengthRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/RangeTree$ArrayView\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n766#2:258\n857#2,2:259\n1855#2,2:261\n233#3,5:263\n1#4:268\n*S KotlinDebug\n*F\n+ 1 MaxLineLengthRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/MaxLineLengthRule\n*L\n73#1:258\n73#1:259,2\n74#1:261,2\n102#1:263,5\n*E\n"})
public final class MaxLineLengthRule
extends StandardRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int maxLineLength;
    @NotNull
    private RangeTree rangeTree;
    private boolean ignoreBackTickedIdentifier;
    @NotNull
    private static final EditorConfigProperty<Boolean> IGNORE_BACKTICKED_IDENTIFIER_PROPERTY;

    public MaxLineLengthRule() {
        Object[] objectArray = new Rule.VisitorModifier[]{new Rule.VisitorModifier.RunAfterRule(TrailingCommaOnCallSiteRuleKt.getTRAILING_COMMA_ON_CALL_SITE_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), new Rule.VisitorModifier.RunAfterRule(TrailingCommaOnDeclarationSiteRuleKt.getTRAILING_COMMA_ON_DECLARATION_SITE_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), Rule.VisitorModifier.RunAsLateAsPossible.INSTANCE};
        Set set = SetsKt.setOf((Object[])objectArray);
        objectArray = new EditorConfigProperty[]{MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY(), IGNORE_BACKTICKED_IDENTIFIER_PROPERTY};
        super("max-line-length", set, SetsKt.setOf((Object[])objectArray));
        this.maxLineLength = ((Number)MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY().getDefaultValue()).intValue();
        this.rangeTree = new RangeTree(null, 1, null);
        this.ignoreBackTickedIdentifier = IGNORE_BACKTICKED_IDENTIFIER_PROPERTY.getDefaultValue();
    }

    @Override
    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.ignoreBackTickedIdentifier = editorConfig.get(IGNORE_BACKTICKED_IDENTIFIER_PROPERTY);
        this.maxLineLength = ((Number)editorConfig.get(MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY())).intValue();
        if (this.maxLineLength == Integer.MAX_VALUE) {
            this.stopTraversalOfAST();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (ASTNodeExtensionKt.isRoot(node)) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            ArrayList<Integer> errorOffset = new ArrayList<Integer>();
            Iterable iterable = MaxLineLengthRuleKt.access$getElementsPerLine(node);
            boolean $i$f$filter = false;
            void var7_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                ParsedLine it = (ParsedLine)element$iv$iv;
                boolean bl = false;
                if (!(it.lineLength(this.ignoreBackTickedIdentifier) > this.maxLineLength)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParsedLine parsedLine = (ParsedLine)element$iv;
                boolean bl = false;
                ASTNode el = (ASTNode)CollectionsKt.last(parsedLine.getElements());
                if (ASTNodeExtensionKt.isPartOf(el, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KDoc.class)) || this.isPartOfRawMultiLineString(el)) continue;
                if (!ASTNodeExtensionKt.isPartOf(el, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                    if (ASTNodeExtensionKt.isPartOf(el, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtPackageDirective.class)) || ASTNodeExtensionKt.isPartOf(el, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtImportDirective.class))) continue;
                    errorOffset.add(parsedLine.getOffset());
                    continue;
                }
                ASTNode prevLeaf2 = ASTNodeExtensionKt.prevCodeSibling(el);
                if (prevLeaf2 == null || prevLeaf2.getStartOffset() < parsedLine.getOffset()) continue;
                errorOffset.add(parsedLine.getOffset());
            }
            this.rangeTree = new RangeTree((List<Integer>)errorOffset);
        } else if (!this.rangeTree.isEmpty() && node.getPsi() instanceof LeafPsiElement) {
            void this_$iv;
            RangeTree.ArrayView errorOffset = this.rangeTree.query(node.getStartOffset(), node.getStartOffset() + node.getTextLength());
            boolean $i$f$forEach = false;
            int i$iv = 0;
            while (i$iv < this_$iv.getSize()) {
                int offset = this_$iv.get(i$iv++);
                boolean bl = false;
                emit.invoke((Object)offset, (Object)("Exceeded max line length (" + this.maxLineLength + ')'), (Object)false);
            }
        }
    }

    private final boolean isPartOfRawMultiLineString(ASTNode $this$isPartOfRawMultiLineString) {
        boolean bl;
        ASTNode aSTNode = ASTNodeExtensionKt.parent($this$isPartOfRawMultiLineString, ElementType.INSTANCE.getSTRING_TEMPLATE(), false);
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it.getFirstChildNode().getText(), (Object)"\"\"\"") && it.textContains('\n');
        } else {
            bl = false;
        }
        return bl;
    }

    static {
        Object[] objectArray = new String[]{"true", "false"};
        IGNORE_BACKTICKED_IDENTIFIER_PROPERTY = new EditorConfigProperty(new PropertyType.LowerCasingPropertyType<Boolean>("ktlint_ignore_back_ticked_identifier", "Defines whether the backticked identifier (``) should be ignored", PropertyType.PropertyValueParser.BOOLEAN_VALUE_PARSER, SetsKt.setOf((Object[])objectArray)), false, null, null, null, null, null, null, null, null, 1020, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/MaxLineLengthRule$Companion;", "", "()V", "IGNORE_BACKTICKED_IDENTIFIER_PROPERTY", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "", "getIGNORE_BACKTICKED_IDENTIFIER_PROPERTY", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorConfigProperty<Boolean> getIGNORE_BACKTICKED_IDENTIFIER_PROPERTY() {
            return IGNORE_BACKTICKED_IDENTIFIER_PROPERTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

