/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.nio.file.Path;

public interface Ec4jPath {
    public String getLastSegment();

    public Ec4jPath getParentPath();

    public boolean isAbsolute();

    public Ec4jPath relativize(Ec4jPath var1);

    public Ec4jPath resolve(String var1);

    public String toString();

    public static class Ec4jPaths {
        private static final Ec4jPath ROOT = new StringPath("/");

        public static Ec4jPath of(Path path) {
            return new NioPath(path);
        }

        public static Ec4jPath of(String path) {
            return new StringPath(path);
        }

        public static Ec4jPath root() {
            return ROOT;
        }

        Ec4jPaths() {
        }

        static class StringPath
        implements Ec4jPath {
            private final String path;

            StringPath(String path) {
                if (path == null || path.isEmpty()) {
                    throw new IllegalArgumentException("Path cannot be null or empty to create a new " + this.getClass().getName());
                }
                if (path.length() > 1 && path.endsWith("/")) {
                    throw new IllegalArgumentException("Path cannot end with a slash '/' to create a new " + this.getClass().getName());
                }
                this.path = path;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                StringPath other = (StringPath)obj;
                return this.path.equals(other.path);
            }

            @Override
            public String getLastSegment() {
                int lastSlash = this.path.lastIndexOf(47);
                return lastSlash >= 0 ? this.path.substring(lastSlash + 1) : this.path;
            }

            @Override
            public Ec4jPath getParentPath() {
                if ("/".equals(this.path)) {
                    return null;
                }
                int lastSlash = this.path.lastIndexOf(47);
                if (lastSlash == 0) {
                    return new StringPath("/");
                }
                if (lastSlash > 0) {
                    return new StringPath(this.path.substring(0, lastSlash));
                }
                return null;
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            @Override
            public boolean isAbsolute() {
                return this.path != null && !this.path.isEmpty() && this.path.charAt(0) == '/';
            }

            @Override
            public Ec4jPath relativize(Ec4jPath other) {
                if (!(other instanceof StringPath)) {
                    throw new IllegalArgumentException(StringPath.class.getName() + " can relativize only instances of " + StringPath.class.getName());
                }
                StringPath otherStringPath = (StringPath)other;
                if ("/".equals(this.path)) {
                    if (otherStringPath.path.startsWith("/") && otherStringPath.path.length() > 1) {
                        return new StringPath(otherStringPath.path.substring(1));
                    }
                    throw new IllegalArgumentException("Cannot relativize path " + otherStringPath + " against resource path " + this.toString());
                }
                int len = this.path.length();
                if (!otherStringPath.path.startsWith(this.path) || otherStringPath.path.length() <= len || otherStringPath.path.charAt(len) != '/') {
                    throw new IllegalArgumentException("Cannot relativize path " + otherStringPath + " against resource path " + this.toString());
                }
                return new StringPath(otherStringPath.path.substring(len + 1));
            }

            @Override
            public Ec4jPath resolve(String name) {
                if (name.indexOf(47) >= 0) {
                    throw new IllegalArgumentException("Cannot resolve names that contain a slash '/'");
                }
                String newPath = "/".equals(this.path) ? "/" + name : this.path + "/" + name;
                return new StringPath(newPath);
            }

            @Override
            public String toString() {
                return this.path;
            }
        }

        static class NioPath
        implements Ec4jPath {
            private static final boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
            private final Path path;
            private String toString;

            NioPath(Path path) {
                this.path = path;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                NioPath other = (NioPath)obj;
                return this.path.equals(other.path);
            }

            @Override
            public String getLastSegment() {
                return this.path.getFileName().toString();
            }

            @Override
            public Ec4jPath getParentPath() {
                Path parent = this.path.getParent();
                return parent == null ? null : new NioPath(parent);
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            @Override
            public boolean isAbsolute() {
                return this.path.isAbsolute();
            }

            @Override
            public Ec4jPath relativize(Ec4jPath other) {
                if (!(other instanceof StringPath)) {
                    throw new IllegalArgumentException(NioPath.class.getName() + " can relativize only instances of " + NioPath.class.getName());
                }
                return new NioPath(this.path.relativize(((NioPath)other).path));
            }

            @Override
            public Ec4jPath resolve(String name) {
                return new NioPath(this.path.resolve(name));
            }

            @Override
            public String toString() {
                if (isWindows) {
                    if (this.toString == null) {
                        StringBuilder result = new StringBuilder();
                        int len = this.path.getNameCount();
                        for (int i = 0; i < len; ++i) {
                            if (i != 0 || this.path.isAbsolute()) {
                                result.append('/');
                            }
                            result.append(this.path.getName(i));
                        }
                        this.toString = result.toString();
                    }
                    return this.toString;
                }
                return this.path.toString();
            }
        }
    }
}

