/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.github.detekt.metrics.LinesOfCodeKt;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\u000fj\b\u0012\u0004\u0012\u00020\t`\u00100\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LargeClass;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "classToLinesCache", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "nestedClassTracking", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "findAllNestedClasses", "Lkotlin/sequences/Sequence;", "startClass", "postVisit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "preVisit", "visitClassOrObject", "classOrObject", "Companion", "detekt-rules-complexity"})
public final class LargeClass
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    private final IdentityHashMap<KtClassOrObject, Integer> classToLinesCache;
    private final IdentityHashMap<KtClassOrObject, HashSet<KtClassOrObject>> nestedClassTracking;
    public static final int DEFAULT_THRESHOLD_CLASS_LENGTH = 600;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    protected void preVisit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.classToLinesCache.clear();
        this.nestedClassTracking.clear();
    }

    /*
     * WARNING - void declaration
     */
    protected void postVisit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Map map = this.classToLinesCache;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void clazz;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            map = (KtClassOrObject)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Integer lines = (Integer)entry2.getValue();
            if (lines < this.getThreshold()) continue;
            Issue issue = this.getIssue();
            void v1 = clazz;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"clazz");
            Entity entity = Entity.Companion.atName((KtNamedDeclaration)v1);
            Integer n = lines;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"lines");
            this.report((Finding)new ThresholdedCodeSmell(issue, entity, new Metric("SIZE", n.intValue(), this.getThreshold(), false, 0, 24, null), "Class " + clazz.getName() + " is too large. Consider splitting it into smaller pieces.", null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        block5: {
            void $this$fold$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            int lines = LinesOfCodeKt.linesOfCode$default((KtElement)((KtElement)classOrObject), null, (int)1, null);
            ((Map)this.classToLinesCache).put(classOrObject, lines);
            Sequence<KtClassOrObject> $this$getStrictParentOfType$iv = (Sequence<KtClassOrObject>)classOrObject;
            boolean $i$f$getStrictParentOfType = false;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            if (ktClassOrObject != null) {
                Object object;
                $this$getStrictParentOfType$iv = ktClassOrObject;
                $i$f$getStrictParentOfType = false;
                bl = false;
                Sequence<KtClassOrObject> it = $this$getStrictParentOfType$iv;
                boolean bl2 = false;
                Map $this$getOrPut$iv = this.nestedClassTracking;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl3 = false;
                    HashSet answer$iv = new HashSet();
                    $this$getOrPut$iv.put(it, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((HashSet)object).add(classOrObject);
            }
            super.visitClassOrObject(classOrObject);
            $this$getStrictParentOfType$iv = this.findAllNestedClasses(classOrObject);
            Integer initial$iv = 0;
            boolean $i$f$fold = false;
            Integer accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void next;
                KtClassOrObject $i$f$getOrPut = (KtClassOrObject)element$iv;
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl4 = false;
                Integer n = this.classToLinesCache.get(next);
                if (n == null) {
                    n = 0;
                }
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"classToLinesCache[next] ?: 0");
                accumulator$iv = acc + n;
            }
            Integer n = accumulator$iv;
            boolean bl5 = false;
            bl = false;
            int it = ((Number)n).intValue();
            boolean bl6 = false;
            Integer n2 = it > 0 ? n : null;
            if (n2 == null) break block5;
            n = n2;
            bl5 = false;
            bl = false;
            it = ((Number)n).intValue();
            boolean bl7 = false;
            ((Map)this.classToLinesCache).put(classOrObject, lines - it);
        }
    }

    private final Sequence<KtClassOrObject> findAllNestedClasses(KtClassOrObject startClass) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KtClassOrObject>, Continuation<? super Unit>, Object>(this, startClass, null){
            private SequenceScope p$;
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ LargeClass this$0;
            final /* synthetic */ KtClassOrObject $startClass;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var22_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$sequence = this.p$;
                        nestedClasses = (HashSet)LargeClass.access$getNestedClassTracking$p(this.this$0).get(this.$startClass);
lbl7:
                        // 2 sources

                        while (true) {
                            var4_5 = nestedClasses;
                            var5_6 = false;
                            var6_8 = false;
                            if (var4_5 == null || var4_5.isEmpty() != false) break block0;
                            this.L$0 = $this$sequence;
                            this.L$1 = nestedClasses;
                            this.label = 1;
                            v0 = $this$sequence.yieldAll((Iterable)nestedClasses, (Continuation)this);
                            if (v0 == var22_2) {
                                return var22_2;
                            }
                            ** GOTO lbl24
                            break;
                        }
                    }
                    case 1: {
                        nestedClasses = (HashSet)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        $this$mapNotNull$iv = nestedClasses;
                        $i$f$mapNotNull = false;
                        var6_7 = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        $i$f$forEach = false;
                        var11_13 = $this$forEach$iv$iv$iv.iterator();
                        while (var11_13.hasNext()) {
                            element$iv$iv = element$iv$iv$iv = var11_13.next();
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            it = (KtClassOrObject)element$iv$iv;
                            $i$a$-mapNotNull-LargeClass$findAllNestedClasses$1$1 = false;
                            if ((HashSet)LargeClass.access$getNestedClassTracking$p(this.this$0).get(it) == null) continue;
                            var18_20 = false;
                            var19_21 = false;
                            it$iv$iv = var17_19;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        nestedClasses = (HashSet)AddToStdlibKt.flattenTo((Iterable)((List)destination$iv$iv), (Collection)new HashSet<E>());
                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = largeClass;
                this.$startClass = ktClassOrObject;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<SequenceScope<? super KtClassOrObject>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                SequenceScope sequenceScope = function2.p$ = (SequenceScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public LargeClass(@NotNull Config config, int threshold) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, threshold);
        this.issue = new Issue("LargeClass", Severity.Maintainability, "One class should have one responsibility. Large classes tend to handle many things at once. Split up large classes into smaller classes that are easier to understand.", Debt.Companion.getTWENTY_MINS());
        this.classToLinesCache = new IdentityHashMap();
        this.nestedClassTracking = new IdentityHashMap();
    }

    public /* synthetic */ LargeClass(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 600;
        }
        this(config, n);
    }

    public LargeClass() {
        this(null, 0, 3, null);
    }

    public static final /* synthetic */ IdentityHashMap access$getNestedClassTracking$p(LargeClass $this) {
        return $this.nestedClassTracking;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LargeClass$Companion;", "", "()V", "DEFAULT_THRESHOLD_CLASS_LENGTH", "", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

