/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedBlockDepth;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "FunctionDepthVisitor", "detekt-rules-complexity"})
public final class NestedBlockDepth
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;

    public NestedBlockDepth(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("NestedBlockDepth", Severity.Maintainability, "Excessive nesting leads to hidden complexity. Prefer extracting code to make it easier to understand.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)4);
    }

    public /* synthetic */ NestedBlockDepth(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="the nested depth required to trigger rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        FunctionDepthVisitor visitor = new FunctionDepthVisitor(this.getThreshold());
        visitor.visitNamedFunction(function);
        if (visitor.isTooDeep()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), new Metric("SIZE", visitor.getMaxDepth(), this.getThreshold(), false, 0, 24, null), "Function " + function.getName() + " is nested too deeply.", null, 16, null));
        }
    }

    public NestedBlockDepth() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NestedBlockDepth.class, "threshold", "getThreshold()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J$\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020&H\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006'"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedBlockDepth$FunctionDepthVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "threshold", "", "(I)V", "depth", "getDepth", "()I", "setDepth", "isTooDeep", "", "()Z", "setTooDeep", "(Z)V", "maxDepth", "getMaxDepth", "setMaxDepth", "getThreshold", "dec", "", "inc", "insideLambdaDo", "lambdaArguments", "", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "function", "Lkotlin/Function0;", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules-complexity"})
    private static final class FunctionDepthVisitor
    extends DetektVisitor {
        private final int threshold;
        private int depth;
        private int maxDepth;
        private boolean isTooDeep;

        public FunctionDepthVisitor(int threshold) {
            this.threshold = threshold;
        }

        public final int getThreshold() {
            return this.threshold;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final void setDepth(int n) {
            this.depth = n;
        }

        public final int getMaxDepth() {
            return this.maxDepth;
        }

        public final void setMaxDepth(int n) {
            this.maxDepth = n;
        }

        public final boolean isTooDeep() {
            return this.isTooDeep;
        }

        public final void setTooDeep(boolean bl) {
            this.isTooDeep = bl;
        }

        private final void inc() {
            FunctionDepthVisitor functionDepthVisitor = this;
            int n = functionDepthVisitor.depth;
            functionDepthVisitor.depth = n + 1;
            if (this.depth >= this.threshold) {
                this.isTooDeep = true;
                if (this.depth > this.maxDepth) {
                    this.maxDepth = this.depth;
                }
            }
        }

        private final void dec() {
            FunctionDepthVisitor functionDepthVisitor = this;
            int n = functionDepthVisitor.depth;
            functionDepthVisitor.depth = n + -1;
        }

        public void visitIfExpression(@NotNull KtIfExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (!(expression.getParent() instanceof KtContainerNodeForControlStructureBody)) {
                this.inc();
                super.visitIfExpression(expression);
                this.dec();
            } else {
                super.visitIfExpression(expression);
            }
        }

        public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
            Intrinsics.checkNotNullParameter((Object)loopExpression, (String)"loopExpression");
            this.inc();
            super.visitLoopExpression(loopExpression);
            this.dec();
        }

        public void visitWhenExpression(@NotNull KtWhenExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.inc();
            super.visitWhenExpression(expression);
            this.dec();
        }

        public void visitTryExpression(@NotNull KtTryExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.inc();
            super.visitTryExpression(expression);
            this.dec();
        }

        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            List list = expression.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expression.lambdaArguments");
            List lambdaArguments = list;
            if (JunkKt.isUsedForNesting((KtCallExpression)expression)) {
                this.insideLambdaDo(lambdaArguments, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ FunctionDepthVisitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        FunctionDepthVisitor.access$inc(this.this$0);
                    }
                }));
                super.visitCallExpression(expression);
                this.insideLambdaDo(lambdaArguments, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ FunctionDepthVisitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        FunctionDepthVisitor.access$dec(this.this$0);
                    }
                }));
            }
        }

        private final void insideLambdaDo(List<KtLambdaArgument> lambdaArguments, Function0<Unit> function) {
            KtLambdaArgument lambdaArgument;
            KtLambdaExpression ktLambdaExpression;
            Collection collection = lambdaArguments;
            boolean bl = false;
            if (!collection.isEmpty() && ((ktLambdaExpression = (lambdaArgument = lambdaArguments.get(0)).getLambdaExpression()) == null ? null : ktLambdaExpression.getBodyExpression()) != null) {
                function.invoke();
            }
        }

        public static final /* synthetic */ void access$inc(FunctionDepthVisitor $this) {
            $this.inc();
        }

        public static final /* synthetic */ void access$dec(FunctionDepthVisitor $this) {
            $this.dec();
        }
    }
}

