/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 I2\u00020\u0001:\u0001IB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u0002092\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u0002092\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020#2\u0006\u0010=\u001a\u00020>H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0011\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000fR!\u0010\u001a\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0011\u0012\u0004\b\u001b\u0010\r\u001a\u0004\b\u001c\u0010\u000fR!\u0010\u001e\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0011\u0012\u0004\b\u001f\u0010\r\u001a\u0004\b \u0010\u000fR!\u0010\"\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u0011\u0012\u0004\b$\u0010\r\u001a\u0004\b%\u0010&R!\u0010(\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010\u0011\u0012\u0004\b)\u0010\r\u001a\u0004\b*\u0010&R!\u0010,\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\u0011\u0012\u0004\b-\u0010\r\u001a\u0004\b.\u0010&R'\u00100\u001a\b\u0012\u0004\u0012\u000202018BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b6\u0010\u0011\u0012\u0004\b3\u0010\r\u001a\u0004\b4\u00105R\u000e\u00107\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/TooManyFunctions;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "thresholdInFiles", "", "getThresholdInFiles$annotations", "()V", "getThresholdInFiles", "()I", "thresholdInFiles$delegate", "Lkotlin/properties/ReadOnlyProperty;", "thresholdInClasses", "getThresholdInClasses$annotations", "getThresholdInClasses", "thresholdInClasses$delegate", "thresholdInInterfaces", "getThresholdInInterfaces$annotations", "getThresholdInInterfaces", "thresholdInInterfaces$delegate", "thresholdInObjects", "getThresholdInObjects$annotations", "getThresholdInObjects", "thresholdInObjects$delegate", "thresholdInEnums", "getThresholdInEnums$annotations", "getThresholdInEnums", "thresholdInEnums$delegate", "ignoreDeprecated", "", "getIgnoreDeprecated$annotations", "getIgnoreDeprecated", "()Z", "ignoreDeprecated$delegate", "ignorePrivate", "getIgnorePrivate$annotations", "getIgnorePrivate", "ignorePrivate$delegate", "ignoreOverridden", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "ignoreOverridden$delegate", "ignoreAnnotatedFunctions", "", "", "getIgnoreAnnotatedFunctions$annotations", "getIgnoreAnnotatedFunctions", "()Ljava/util/List;", "ignoreAnnotatedFunctions$delegate", "amountOfTopLevelFunctions", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "calcFunctions", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isIgnoredFunction", "Companion", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nTooManyFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooManyFunctions.kt\nio/gitlab/arturbosch/detekt/rules/complexity/TooManyFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n808#2,11:179\n1782#2,4:190\n1755#2,3:194\n*S KotlinDebug\n*F\n+ 1 TooManyFunctions.kt\nio/gitlab/arturbosch/detekt/rules/complexity/TooManyFunctions\n*L\n160#1:179,11\n161#1:190,4\n169#1:194,3\n*E\n"})
public final class TooManyFunctions
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty thresholdInFiles$delegate;
    @NotNull
    private final ReadOnlyProperty thresholdInClasses$delegate;
    @NotNull
    private final ReadOnlyProperty thresholdInInterfaces$delegate;
    @NotNull
    private final ReadOnlyProperty thresholdInObjects$delegate;
    @NotNull
    private final ReadOnlyProperty thresholdInEnums$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreDeprecated$delegate;
    @NotNull
    private final ReadOnlyProperty ignorePrivate$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreAnnotatedFunctions$delegate;
    private int amountOfTopLevelFunctions;
    public static final int DEFAULT_THRESHOLD = 11;
    @NotNull
    private static final String DEPRECATED = "Deprecated";

    public TooManyFunctions(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("TooManyFunctions", Severity.Maintainability, "Too many functions inside a/an file/class/object/interface always indicate a violation of the single responsibility principle. Maybe the file/class/object/interface wants to manage too many things at once. Extract functionality which clearly belongs together.", Debt.Companion.getTWENTY_MINS());
        this.thresholdInFiles$delegate = ConfigPropertyKt.config((Object)11);
        this.thresholdInClasses$delegate = ConfigPropertyKt.config((Object)11);
        this.thresholdInInterfaces$delegate = ConfigPropertyKt.config((Object)11);
        this.thresholdInObjects$delegate = ConfigPropertyKt.config((Object)11);
        this.thresholdInEnums$delegate = ConfigPropertyKt.config((Object)11);
        this.ignoreDeprecated$delegate = ConfigPropertyKt.config((Object)false);
        this.ignorePrivate$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreOverridden$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreAnnotatedFunctions$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList());
    }

    public /* synthetic */ TooManyFunctions(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThresholdInFiles() {
        return ((Number)this.thresholdInFiles$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="threshold in files")
    private static /* synthetic */ void getThresholdInFiles$annotations() {
    }

    private final int getThresholdInClasses() {
        return ((Number)this.thresholdInClasses$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    @Configuration(description="threshold in classes")
    private static /* synthetic */ void getThresholdInClasses$annotations() {
    }

    private final int getThresholdInInterfaces() {
        return ((Number)this.thresholdInInterfaces$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    @Configuration(description="threshold in interfaces")
    private static /* synthetic */ void getThresholdInInterfaces$annotations() {
    }

    private final int getThresholdInObjects() {
        return ((Number)this.thresholdInObjects$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
    }

    @Configuration(description="threshold in objects")
    private static /* synthetic */ void getThresholdInObjects$annotations() {
    }

    private final int getThresholdInEnums() {
        return ((Number)this.thresholdInEnums$delegate.getValue((Object)this, $$delegatedProperties[4])).intValue();
    }

    @Configuration(description="threshold in enums")
    private static /* synthetic */ void getThresholdInEnums$annotations() {
    }

    private final boolean getIgnoreDeprecated() {
        return (Boolean)this.ignoreDeprecated$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    @Configuration(description="ignore deprecated functions")
    private static /* synthetic */ void getIgnoreDeprecated$annotations() {
    }

    private final boolean getIgnorePrivate() {
        return (Boolean)this.ignorePrivate$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    @Configuration(description="ignore private functions")
    private static /* synthetic */ void getIgnorePrivate$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[7]);
    }

    @Configuration(description="ignore overridden functions")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    private final List<String> getIgnoreAnnotatedFunctions() {
        return (List)this.ignoreAnnotatedFunctions$delegate.getValue((Object)this, $$delegatedProperties[8]);
    }

    @Configuration(description="ignore functions annotated with these annotations")
    private static /* synthetic */ void getIgnoreAnnotatedFunctions$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        if (this.amountOfTopLevelFunctions >= this.getThresholdInFiles()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atPackageOrFirstDecl(file), new Metric("SIZE", this.amountOfTopLevelFunctions, this.getThresholdInFiles(), false, 0, 24, null), "File '" + file.getName() + "' with '" + this.amountOfTopLevelFunctions + "' functions detected. Defined threshold inside files is set to '" + this.getThresholdInFiles() + '\'', null, 16, null));
        }
        this.amountOfTopLevelFunctions = 0;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function.isTopLevel() && !this.isIgnoredFunction(function)) {
            int n = this.amountOfTopLevelFunctions;
            this.amountOfTopLevelFunctions = n + 1;
        }
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        int amount = this.calcFunctions((KtClassOrObject)klass);
        if (klass.isInterface()) {
            if (amount >= this.getThresholdInInterfaces()) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), new Metric("SIZE", amount, this.getThresholdInInterfaces(), false, 0, 24, null), "Interface '" + klass.getName() + "' with '" + amount + "' functions detected. Defined threshold inside interfaces is set to '" + this.getThresholdInInterfaces() + '\'', null, 16, null));
            }
        } else if (klass.isEnum()) {
            if (amount >= this.getThresholdInEnums()) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), new Metric("SIZE", amount, this.getThresholdInEnums(), false, 0, 24, null), "Enum class '" + klass.getName() + "' with '" + amount + "' functions detected. Defined threshold inside enum classes is set to '" + this.getThresholdInEnums() + '\'', null, 16, null));
            }
        } else if (amount >= this.getThresholdInClasses()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), new Metric("SIZE", amount, this.getThresholdInClasses(), false, 0, 24, null), "Class '" + klass.getName() + "' with '" + amount + "' functions detected. Defined threshold inside classes is set to '" + this.getThresholdInClasses() + '\'', null, 16, null));
        }
        super.visitClass(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        int amount = this.calcFunctions((KtClassOrObject)declaration);
        if (amount >= this.getThresholdInObjects()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)declaration), new Metric("SIZE", amount, this.getThresholdInObjects(), false, 0, 24, null), "Object '" + declaration.getName() + "' with '" + amount + "' functions detected. Defined threshold inside objects is set to '" + this.getThresholdInObjects() + '\'', null, 16, null));
        }
        super.visitObjectDeclaration(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final int calcFunctions(KtClassOrObject classOrObject) {
        int n;
        KtClassBody ktClassBody = classOrObject.getBody();
        if (ktClassBody != null) {
            void $this$count$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            KtClassBody $this$calcFunctions_u24lambda_u241 = ktClassBody;
            boolean bl = false;
            Iterable iterable = $this$calcFunctions_u24lambda_u241.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            void var7_7 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KtNamedFunction it = (KtNamedFunction)element$iv;
                    boolean bl2 = false;
                    if (!(!this.isIgnoredFunction(it)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isIgnoredFunction(KtNamedFunction function) {
        boolean bl;
        String[] stringArray;
        if (this.getIgnoreDeprecated() && KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)((KtAnnotated)function), (String[])(stringArray = new String[]{DEPRECATED}))) {
            bl = true;
        } else if (this.getIgnorePrivate() && KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)function))) {
            bl = true;
        } else if (this.getIgnoreOverridden() && KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function))) {
            bl = true;
        } else {
            boolean bl2;
            block9: {
                Iterable $this$any$iv = this.getIgnoreAnnotatedFunctions();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String[] stringArray2 = new String[]{it};
                        if (!KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)((KtAnnotated)function), (String[])stringArray2)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public TooManyFunctions() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInFiles", "getThresholdInFiles()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInClasses", "getThresholdInClasses()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInInterfaces", "getThresholdInInterfaces()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInObjects", "getThresholdInObjects()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInEnums", "getThresholdInEnums()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "ignoreDeprecated", "getIgnoreDeprecated()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "ignorePrivate", "getIgnorePrivate()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "ignoreAnnotatedFunctions", "getIgnoreAnnotatedFunctions()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/TooManyFunctions$Companion;", "", "<init>", "()V", "DEFAULT_THRESHOLD", "", "DEPRECATED", "", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

