/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000eH\u0002J\u0014\u0010\u0011\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/KDocReferencesNonPublicProperty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "report", "", "property", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isNonPublicInherited", "", "isReferencedInherited", "comment", "", "detekt-rules-documentation"})
public final class KDocReferencesNonPublicProperty
extends Rule {
    @NotNull
    private final Issue issue;

    public KDocReferencesNonPublicProperty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "KDoc comments should not refer to non-public properties.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ KDocReferencesNonPublicProperty(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        PsiElement $this$getTopmostParentOfType$iv = (PsiElement)property;
        boolean $i$f$getTopmostParentOfType = false;
        KtClass enclosingClass = (KtClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)$this$getTopmostParentOfType$iv, KtClass.class);
        KtClass ktClass = enclosingClass;
        String string = ktClass != null && (ktClass = ktClass.getDocComment()) != null ? ktClass.getText() : null;
        if (string == null) {
            return;
        }
        String comment = string;
        if (this.isNonPublicInherited(property) && this.isReferencedInherited(property, comment)) {
            this.report((KtNamedDeclaration)property);
        }
    }

    private final boolean isNonPublicInherited(KtProperty $this$isNonPublicInherited) {
        if (!KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)$this$isNonPublicInherited)) && !KtPsiUtilKt.isProtected((KtModifierListOwner)((KtModifierListOwner)$this$isNonPublicInherited))) {
            return true;
        }
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isNonPublicInherited));
        while (classOrObject instanceof KtObjectDeclaration) {
            if (!KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)classOrObject))) {
                return true;
            }
            classOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)classOrObject));
        }
        return false;
    }

    private final boolean isReferencedInherited(KtProperty $this$isReferencedInherited, String comment) {
        String string = $this$isReferencedInherited.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameAsSafeName.asString()");
        String qualifiedName = string;
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isReferencedInherited));
        while (classOrObject instanceof KtObjectDeclaration) {
            qualifiedName = ((KtObjectDeclaration)classOrObject).getNameAsSafeName().asString() + '.' + qualifiedName;
            classOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)classOrObject));
        }
        return StringsKt.contains$default((CharSequence)comment, (CharSequence)('[' + qualifiedName + ']'), (boolean)false, (int)2, null);
    }

    private final void report(KtNamedDeclaration property) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName(property), "The property " + property.getNameAsSafeName() + " is non-public and should not be referenced from KDoc comments.", null, null, 24, null));
    }

    public KDocReferencesNonPublicProperty() {
        this(null, 1, null);
    }
}

