/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.empty;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.empty.EmptyRule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R!\u0010\u0006\u001a\u00020\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/empty/EmptyCatchBlock;", "Lio/gitlab/arturbosch/detekt/rules/empty/EmptyRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex$annotations", "()V", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "detekt-rules-empty"})
public final class EmptyCatchBlock
extends EmptyRule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty allowedExceptionNameRegex$delegate;

    public EmptyCatchBlock(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, "Empty catch block detected. Empty catch blocks indicate that an exception is ignored and not handled.", "Empty catch block detected. If the exception can be safely ignored, name the exception according to one of the exemptions as per the configuration of this rule.");
        this.allowedExceptionNameRegex$delegate = ConfigPropertyKt.config((Object)"_|(ignore|expected).*", EmptyCatchBlock::allowedExceptionNameRegex_delegate$lambda$0);
    }

    private final Regex getAllowedExceptionNameRegex() {
        return (Regex)this.allowedExceptionNameRegex$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores exception types which match this regex")
    private static /* synthetic */ void getAllowedExceptionNameRegex$annotations() {
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            super.visitCatchSection(catchClause);
            if (AllowedExceptionNamePatternKt.isAllowedExceptionName((KtCatchClause)catchClause, (Regex)this.getAllowedExceptionNameRegex())) {
                return;
            }
            KtExpression ktExpression = catchClause.getCatchBody();
            if (ktExpression == null) break block1;
            this.addFindingIfBlockExprIsEmpty(ktExpression);
        }
    }

    private static final Regex allowedExceptionNameRegex_delegate$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Regex(it);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(EmptyCatchBlock.class, "allowedExceptionNameRegex", "getAllowedExceptionNameRegex()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

