/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtThrowExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/RethrowCaughtException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "detekt-rules-exceptions"})
public final class RethrowCaughtException
extends Rule {
    @NotNull
    private final Issue issue;

    public RethrowCaughtException(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RethrowCaughtException", Severity.CodeSmell, "Do not rethrow a caught exception of the same type.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ RethrowCaughtException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        KtThrowExpression throwExpression2;
        Object[] objectArray;
        Object[] objectArray2;
        Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
        Object object = catchClause.getCatchParameter();
        Object[] objectArray3 = objectArray2 = object == null ? null : object.getName();
        if (objectArray2 == null) {
            return;
        }
        Object[] exceptionName = objectArray = objectArray2;
        object = catchClause.getCatchBody();
        Object[] objectArray4 = objectArray2 = object == null ? null : object.getChildren();
        if (objectArray2 == null) {
            return;
        }
        Object[] statements = objectArray2;
        object = ArraysKt.firstOrNull((Object[])statements);
        KtThrowExpression ktThrowExpression = throwExpression2 = object instanceof KtThrowExpression ? (KtThrowExpression)object : null;
        if (throwExpression2 != null && Intrinsics.areEqual((Object)((object = throwExpression2.getThrownExpression()) == null ? null : object.getText()), (Object)exceptionName)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)throwExpression2), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitCatchSection(catchClause);
    }

    public RethrowCaughtException() {
        this(null, 1, null);
    }
}

