/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/ArrayPrimitive;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isArrayPrimitive", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "it", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "reportArrayPrimitives", "", "typeReference", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitNamedDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Companion", "detekt-rules-performance"})
@SourceDebugExtension(value={"SMAP\nArrayPrimitive.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayPrimitive.kt\nio/gitlab/arturbosch/detekt/rules/performance/ArrayPrimitive\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,95:1\n1#2:96\n278#3,14:97\n228#3:111\n239#3:112\n296#3:113\n1855#4,2:114\n1549#4:120\n1620#4,3:121\n11065#5:116\n11400#5,3:117\n*S KotlinDebug\n*F\n+ 1 ArrayPrimitive.kt\nio/gitlab/arturbosch/detekt/rules/performance/ArrayPrimitive\n*L\n72#1:97,14\n72#1:111\n72#1:112\n72#1:113\n73#1:114,2\n92#1:120\n92#1:121,3\n90#1:116\n90#1:117,3\n*E\n"})
public final class ArrayPrimitive
extends Rule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<String> primitiveTypes;
    @NotNull
    private static final List<FqName> factoryMethodFqNames;
    @NotNull
    private static final List<String> factoryMethodNames;

    public ArrayPrimitive(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ArrayPrimitive", Severity.Performance, "Using `Array<Primitive>` leads to implicit boxing and a performance hit.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ArrayPrimitive(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        CallableDescriptor descriptor;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        KtExpression ktExpression = expression.getCalleeExpression();
        if (!CollectionsKt.contains((Iterable)factoryMethodNames, (Object)(ktExpression != null ? ktExpression.getText() : null))) {
            return;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        Object object = descriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        if (descriptor != null && this.isArrayPrimitive(descriptor)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration) {
        block2: {
            KtTypeReference p0;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            super.visitNamedDeclaration(declaration);
            if (!(declaration instanceof KtCallableDeclaration)) break block2;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)declaration).getTypeReference();
            if (ktTypeReference != null) {
                p0 = ktTypeReference;
                boolean bl = false;
                this.reportArrayPrimitives(p0);
            }
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)declaration).getReceiverTypeReference();
            if (ktTypeReference2 != null) {
                p0 = ktTypeReference2;
                boolean bl = false;
                this.reportArrayPrimitives(p0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportArrayPrimitives(KtTypeReference typeReference) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        PsiElement psiElement = (PsiElement)typeReference;
        Function1 predicate$iv = (Function1)new Function1<KtTypeReference, Boolean>(this){
            final /* synthetic */ ArrayPrimitive this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtTypeReference it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ArrayPrimitive.access$isArrayPrimitive(this.this$0, it);
            }
        };
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var7_10 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var10_14 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtTypeReference, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtTypeReference) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        Iterable $this$forEach$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTypeReference it = (KtTypeReference)element$iv;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isArrayPrimitive(CallableDescriptor descriptor) {
        Object object = descriptor.getReturnType();
        KotlinType type = object != null && (object = object.getArguments()) != null && (object = (TypeProjection)CollectionsKt.singleOrNull((List)object)) != null ? object.getType() : null;
        return CollectionsKt.contains((Iterable)factoryMethodFqNames, (Object)DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)descriptor))) && type != null && KotlinBuiltIns.isPrimitiveType((KotlinType)type);
    }

    private final boolean isArrayPrimitive(KtTypeReference it) {
        String string = it.getText();
        boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"Array<", (boolean)false, (int)2, null) : false;
        if (bl) {
            boolean bl2;
            KtTypeElement ktTypeElement = it.getTypeElement();
            List genericTypeArguments = ktTypeElement != null ? ktTypeElement.getTypeArgumentsAsTypes() : null;
            List list = genericTypeArguments;
            if (list != null && (list = (KtTypeReference)CollectionsKt.singleOrNull((List)list)) != null) {
                List it2 = list;
                boolean bl3 = false;
                bl2 = primitiveTypes.contains(it2.getText());
            } else {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    public ArrayPrimitive() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isArrayPrimitive(ArrayPrimitive $this, KtTypeReference it) {
        return $this.isArrayPrimitive(it);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((PrimitiveType[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (FqName item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var8_10 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTypeName().asString());
        }
        primitiveTypes = (List)destination$iv$iv;
        $this$map$iv = new FqName[]{new FqName("kotlin.arrayOf"), new FqName("kotlin.emptyArray")};
        factoryMethodFqNames = CollectionsKt.listOf((Object[])$this$map$iv);
        $this$map$iv = factoryMethodFqNames;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            FqName item$iv$iv;
            Object item$iv$iv2 = iterator.next();
            item$iv$iv = (FqName)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.shortName().asString());
        }
        factoryMethodNames = (List)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/ArrayPrimitive$Companion;", "", "()V", "factoryMethodFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "factoryMethodNames", "", "primitiveTypes", "detekt-rules-performance"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

