/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0013H\u0002R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantVisibilityModifierRule;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "childrenVisitor", "Lio/gitlab/arturbosch/detekt/rules/style/RedundantVisibilityModifierRule$ChildrenVisitor;", "classVisitor", "Lio/gitlab/arturbosch/detekt/rules/style/RedundantVisibilityModifierRule$ClassVisitor;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isExplicitlyPublic", "", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "isExplicitlyPublicNotOverridden", "ChildrenVisitor", "ClassVisitor", "detekt-rules-style"})
public final class RedundantVisibilityModifierRule
extends Rule {
    @NotNull
    private final Issue issue;
    private final ClassVisitor classVisitor;
    private final ChildrenVisitor childrenVisitor;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean isExplicitlyPublicNotOverridden(KtModifierListOwner $this$isExplicitlyPublicNotOverridden) {
        return this.isExplicitlyPublic($this$isExplicitlyPublicNotOverridden) && !KtModifierListKt.isOverride((KtModifierListOwner)$this$isExplicitlyPublicNotOverridden);
    }

    private final boolean isExplicitlyPublic(KtModifierListOwner $this$isExplicitlyPublic) {
        return $this$isExplicitlyPublic.hasModifier(KtTokens.PUBLIC_KEYWORD);
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        Iterable $this$forEach$iv = file.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl = false;
            it.accept((PsiElementVisitor)this.classVisitor);
            it.acceptChildren((PsiElementVisitor)this.childrenVisitor);
        }
    }

    public RedundantVisibilityModifierRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RedundantVisibilityModifierRule", Severity.Style, "Checks for redundant visibility modifiers. Public is the default visibility for classes. The public modifier is redundant.", Debt.Companion.getFIVE_MINS());
        this.classVisitor = new ClassVisitor();
        this.childrenVisitor = new ChildrenVisitor();
    }

    public /* synthetic */ RedundantVisibilityModifierRule(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public RedundantVisibilityModifierRule() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantVisibilityModifierRule$ClassVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/style/RedundantVisibilityModifierRule;)V", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "detekt-rules-style"})
    private final class ClassVisitor
    extends DetektVisitor {
        public void visitClass(@NotNull KtClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            super.visitClass(klass);
            if (RedundantVisibilityModifierRule.this.isExplicitlyPublic((KtModifierListOwner)klass)) {
                RedundantVisibilityModifierRule.this.report((Finding)new CodeSmell(RedundantVisibilityModifierRule.this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), klass.getName() + " is explicitly marked as public. " + "Public is the default visibility for classes. The public modifier is redundant.", null, null, 24, null));
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/RedundantVisibilityModifierRule$ChildrenVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/style/RedundantVisibilityModifierRule;)V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "detekt-rules-style"})
    private final class ChildrenVisitor
    extends DetektVisitor {
        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            super.visitNamedFunction(function);
            if (RedundantVisibilityModifierRule.this.isExplicitlyPublicNotOverridden((KtModifierListOwner)function)) {
                RedundantVisibilityModifierRule.this.report((Finding)new CodeSmell(RedundantVisibilityModifierRule.this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), function.getName() + " is explicitly marked as public. " + "Functions are public by default so this modifier is redundant.", null, null, 24, null));
            }
        }

        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            super.visitProperty(property);
            if (RedundantVisibilityModifierRule.this.isExplicitlyPublicNotOverridden((KtModifierListOwner)property)) {
                RedundantVisibilityModifierRule.this.report((Finding)new CodeSmell(RedundantVisibilityModifierRule.this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), property.getName() + " is explicitly marked as public. " + "Properties are public by default so this modifier is redundant.", null, null, 24, null));
            }
        }
    }
}

