/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ClassOrdering;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "lengthComparator", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lkotlin/Comparator;", "orderPriority", "", "declaration", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Ljava/lang/Integer;", "visitClassBody", "", "classBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "isInOrder", "", "", "comparator", "detekt-rules-style"})
public final class ClassOrdering
extends Rule {
    @NotNull
    private final Issue issue;
    private final Comparator<KtDeclaration> lengthComparator;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClassBody(@NotNull KtClassBody classBody) {
        Intrinsics.checkNotNullParameter((Object)classBody, (String)"classBody");
        super.visitClassBody(classBody);
        if (!this.isInOrder(classBody.getDeclarations(), this.lengthComparator)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)classBody), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final Integer orderPriority(KtDeclaration declaration) {
        KtDeclaration ktDeclaration = declaration;
        return ktDeclaration instanceof KtProperty ? Integer.valueOf(0) : (ktDeclaration instanceof KtClassInitializer ? Integer.valueOf(0) : (ktDeclaration instanceof KtSecondaryConstructor ? Integer.valueOf(1) : (ktDeclaration instanceof KtNamedFunction ? Integer.valueOf(2) : (ktDeclaration instanceof KtObjectDeclaration ? (((KtObjectDeclaration)declaration).isCompanion() ? Integer.valueOf(3) : null) : null))));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInOrder(Iterable<? extends KtDeclaration> $this$isInOrder, Comparator<KtDeclaration> comparator) {
        Iterable<? extends KtDeclaration> $this$zipWithNext$iv = $this$isInOrder;
        boolean $i$f$zipWithNext = false;
        Iterator<? extends KtDeclaration> iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            CollectionsKt.emptyList();
        } else {
            boolean bl = false;
            List result$iv = new ArrayList();
            KtDeclaration current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                void a;
                KtDeclaration next$iv;
                KtDeclaration ktDeclaration = next$iv = iterator$iv.next();
                KtDeclaration ktDeclaration2 = current$iv;
                List list = result$iv;
                boolean bl2 = false;
                if (comparator.compare((KtDeclaration)a, (KtDeclaration)b) > 0) {
                    return false;
                }
                Unit unit = Unit.INSTANCE;
                list.add(unit);
                current$iv = next$iv;
            }
        }
        return true;
    }

    public ClassOrdering(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Class contents should be in this order: Property declarations/initializer blocks; secondary constructors; method declarations then companion objects.", Debt.Companion.getFIVE_MINS());
        this.lengthComparator = new Comparator<KtDeclaration>(this){
            final /* synthetic */ ClassOrdering this$0;

            public final int compare(@NotNull KtDeclaration str1, @NotNull KtDeclaration str2) {
                Intrinsics.checkNotNullParameter((Object)str1, (String)"str1");
                Intrinsics.checkNotNullParameter((Object)str2, (String)"str2");
                if (ClassOrdering.access$orderPriority(this.this$0, str1) == null || ClassOrdering.access$orderPriority(this.this$0, str2) == null) {
                    return 0;
                }
                return ComparisonsKt.compareValues((Comparable)ClassOrdering.access$orderPriority(this.this$0, str1), (Comparable)ClassOrdering.access$orderPriority(this.this$0, str2));
            }
            {
                this.this$0 = classOrdering;
            }
        };
    }

    public /* synthetic */ ClassOrdering(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ClassOrdering() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Integer access$orderPriority(ClassOrdering $this, KtDeclaration declaration) {
        return $this.orderPriority(declaration);
    }
}

