/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import io.gitlab.arturbosch.detekt.rules.IsPartOfUtilsKt;
import io.gitlab.arturbosch.detekt.rules.style.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/TrailingWhitespace;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "countTrailingWhitespace", "", "line", "", "createMessage", "visit", "", "fileContent", "Lio/gitlab/arturbosch/detekt/rules/style/KtFileContent;", "detekt-rules-style"})
public final class TrailingWhitespace
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(@NotNull KtFileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        int offset = 0;
        Sequence<String> $this$forEachIndexed$iv = fileContent.getContent();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            KtFile file;
            PsiElement ktElement;
            void line;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl2 = false;
            int trailingWhitespaces = this.countTrailingWhitespace((String)line);
            if (!(trailingWhitespaces <= 0 || (ktElement = JunkKt.findFirstKtElementInParents(file = fileContent.getFile(), offset += line.length(), (String)line)) != null && IsPartOfUtilsKt.isPartOfString((PsiElement)ktElement))) {
                Entity entity = Entity.Companion.from((PsiElement)file, offset - trailingWhitespaces);
                boolean bl3 = false;
                boolean bl4 = false;
                Entity entity2 = entity;
                boolean bl5 = false;
                Entity entity3 = Entity.copy$default((Entity)entity2, null, null, (Location)Location.copy$default((Location)entity2.getLocation(), null, (TextLocation)TextLocation.copy$default((TextLocation)entity2.getLocation().getText(), (int)0, (int)offset, (int)1, null), null, (int)5, null), null, (int)11, null);
                this.report((Finding)new CodeSmell(this.getIssue(), entity3, this.createMessage(index), null, null, 24, null));
            }
            ++offset;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int countTrailingWhitespace(String line) {
        int n;
        int n2;
        block2: {
            void $this$indexOfLast$iv;
            CharSequence charSequence = line;
            n2 = line.length();
            boolean $i$f$indexOfLast = false;
            int n3 = $this$indexOfLast$iv.length();
            --n3;
            boolean bl = false;
            while (n3 >= 0) {
                void index$iv;
                char it = $this$indexOfLast$iv.charAt((int)index$iv);
                boolean bl2 = false;
                if (it != ' ' && it != '\t') {
                    n = index$iv;
                    break block2;
                }
                --index$iv;
            }
            n = -1;
        }
        int n4 = n;
        return n2 - n4 - 1;
    }

    private final String createMessage(int line) {
        return "Line " + (line + 1) + " ends with a whitespace.";
    }

    public TrailingWhitespace(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Checks which lines end with a whitespace.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ TrailingWhitespace(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public TrailingWhitespace() {
        this(null, 1, null);
    }
}

