/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "uselessFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull$Conversion;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "isNullable", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Conversion", "detekt-rules-style"})
public final class UselessCallOnNotNull
extends Rule {
    @NotNull
    private final Issue issue;
    private final Map<FqName, Conversion> uselessFqNames;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression) {
        boolean notNullType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitQualifiedExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        FqName fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
        if (fqName == null) {
            return;
        }
        FqName fqName2 = fqName;
        Conversion conversion = this.uselessFqNames.get(fqName2);
        if (conversion == null) {
            return;
        }
        Conversion conversion2 = conversion;
        KtQualifiedExpression ktQualifiedExpression = expression;
        if (!(ktQualifiedExpression instanceof KtSafeQualifiedExpression)) {
            ktQualifiedExpression = null;
        }
        KtSafeQualifiedExpression safeExpression = (KtSafeQualifiedExpression)ktQualifiedExpression;
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)expression.getReceiverExpression(), (BindingContext)this.getBindingContext());
        boolean bl = notNullType = kotlinType != null && !KotlinTypeKt.isNullable((KotlinType)kotlinType);
        if (notNullType || safeExpression != null) {
            String string = fqName2.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqName.shortName().asString()");
            String shortName = string;
            String message = conversion2.getReplacementName() == null ? "Remove redundant call to " + shortName : "Replace " + shortName + " with " + conversion2.getReplacementName();
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitCallExpression(expression);
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
            if (resolvedCall == null) {
                return;
            }
            ResolvedCall resolvedCall2 = resolvedCall;
            FqName fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
            if (fqName == null) {
                return;
            }
            FqName fqName2 = fqName;
            if (Intrinsics.areEqual((Object)fqName2, (Object)new FqName("kotlin.collections.listOfNotNull")) ^ true) {
                return;
            }
            Object v = ((Map.Entry)CollectionsKt.single((Iterable)resolvedCall2.getValueArguments().entrySet())).getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"resolvedCall.valueArguments.entries.single().value");
            List list = ((ResolvedValueArgument)v).getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolvedCall.valueArgume\u2026.single().value.arguments");
            List varargs = list;
            Iterable $this$none$iv = varargs;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ValueArgument it = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    ValueArgument valueArgument = it;
                    Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"it");
                    if (!this.isNullable(valueArgument)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Replace listOfNotNull with listOf", null, null, 24, null));
        }
    }

    private final boolean isNullable(ValueArgument $this$isNullable) {
        KtExpression ktExpression = $this$isNullable.getArgumentExpression();
        return ktExpression != null && (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)this.getBindingContext())) != null && KotlinTypeKt.isNullable((KotlinType)ktExpression);
    }

    public UselessCallOnNotNull(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UselessCallOnNotNull", Severity.Performance, "This call on non-null reference may be reduced or removed. Some calls are intended to be called on nullable collection or text types (e.g. String?). When this call is used on a reference to a non-null type (e.g. String) it is redundant and will have no effect, so it can be removed.", Debt.Companion.getFIVE_MINS());
        this.uselessFqNames = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)new FqName("kotlin.collections.orEmpty"), (Object)new Conversion(null, 1, null)), TuplesKt.to((Object)new FqName("kotlin.sequences.orEmpty"), (Object)new Conversion(null, 1, null)), TuplesKt.to((Object)new FqName("kotlin.text.orEmpty"), (Object)new Conversion(null, 1, null)), TuplesKt.to((Object)new FqName("kotlin.text.isNullOrEmpty"), (Object)new Conversion("isEmpty")), TuplesKt.to((Object)new FqName("kotlin.text.isNullOrBlank"), (Object)new Conversion("isBlank"))});
    }

    public /* synthetic */ UselessCallOnNotNull(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UselessCallOnNotNull() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull$Conversion;", "", "replacementName", "", "(Ljava/lang/String;)V", "getReplacementName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class Conversion {
        @Nullable
        private final String replacementName;

        @Nullable
        public final String getReplacementName() {
            return this.replacementName;
        }

        public Conversion(@Nullable String replacementName) {
            this.replacementName = replacementName;
        }

        public /* synthetic */ Conversion(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        public Conversion() {
            this(null, 1, null);
        }

        @Nullable
        public final String component1() {
            return this.replacementName;
        }

        @NotNull
        public final Conversion copy(@Nullable String replacementName) {
            return new Conversion(replacementName);
        }

        public static /* synthetic */ Conversion copy$default(Conversion conversion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = conversion.replacementName;
            }
            return conversion.copy(string);
        }

        @NotNull
        public String toString() {
            return "Conversion(replacementName=" + this.replacementName + ")";
        }

        public int hashCode() {
            String string = this.replacementName;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Conversion)) break block3;
                    Conversion conversion = (Conversion)object;
                    if (!Intrinsics.areEqual((Object)this.replacementName, (Object)conversion.replacementName)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

