/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\u0016\u001a\u00020\u0011*\u00020\u0017H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkFunctionWithExplicitReturnType", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkFunctionWithInferredReturnType", "createMessage", "", "isInInterface", "", "visitBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitNamedFunction", "canBeUsedAsValue", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "detekt-rules-style"})
public final class OptionalUnit
extends Rule {
    @NotNull
    private final Issue issue;
    private static final String UNIT = "Unit";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function.getFunKeyword() == null) {
            return;
        }
        if (this.isInInterface(function)) {
            return;
        }
        if (function.hasDeclaredReturnType() && function.getColon() != null) {
            this.checkFunctionWithExplicitReturnType(function);
        } else if (!KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function))) {
            this.checkFunctionWithInferredReturnType(function);
        }
        super.visitNamedFunction(function);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void visitBlockExpression(@NotNull KtBlockExpression expression) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List list = expression.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expression.statements");
        List statements = list;
        KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)statements);
        if (ktExpression == null) {
            return;
        }
        KtExpression lastStatement = ktExpression;
        Iterable $this$filter$iv = statements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            KtExpression it = (KtExpression)element$iv$iv;
            boolean bl2 = false;
            if (!(it instanceof KtNameReferenceExpression) || Intrinsics.areEqual((Object)((KtNameReferenceExpression)it).getText(), (Object)UNIT) ^ true) {
                bl = false;
            } else if (Intrinsics.areEqual((Object)it, (Object)lastStatement) ^ true || Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                bl = true;
            } else if (!BindingContextUtilsKt.isUsedAsExpression((KtExpression)it, (BindingContext)this.getBindingContext())) {
                bl = true;
            } else {
                KtExpression prev;
                KtExpression ktExpression2;
                Object v3;
                block11: {
                    Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)it), (boolean)false, (boolean)false);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtExpression)) continue;
                        v3 = element$iv;
                        break block11;
                    }
                    v3 = null;
                }
                bl = (ktExpression2 = (prev = (KtExpression)v3)) != null && (ktExpression2 = CallUtilKt.getType((KtExpression)ktExpression2, (BindingContext)this.getBindingContext())) != null && TypeUtilsKt.isUnit((KotlinType)ktExpression2) && this.canBeUsedAsValue(prev);
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        iterable = $this$onEach$iv;
        boolean bl = false;
        boolean bl3 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl4 = false;
        Iterator iterator = $this$apply$iv.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                super.visitBlockExpression(expression);
                return;
            }
            Object element$iv = iterator.next();
            KtExpression it = (KtExpression)element$iv;
            boolean bl5 = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "A single Unit expression is unnecessary and can safely be removed", null, null, 24, null));
        }
    }

    private final boolean canBeUsedAsValue(KtExpression $this$canBeUsedAsValue) {
        boolean bl;
        KtExpression ktExpression = $this$canBeUsedAsValue;
        if (ktExpression instanceof KtIfExpression) {
            KtExpression elseExpression = ((KtIfExpression)$this$canBeUsedAsValue).getElse();
            bl = elseExpression instanceof KtIfExpression ? this.canBeUsedAsValue(elseExpression) : elseExpression != null;
        } else if (ktExpression instanceof KtWhenExpression) {
            List list = ((KtWhenExpression)$this$canBeUsedAsValue).getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entries");
            KtWhenEntry ktWhenEntry = (KtWhenEntry)CollectionsKt.lastOrNull((List)list);
            bl = (ktWhenEntry != null ? ktWhenEntry.getElseKeyword() : null) != null || WhenChecker.INSTANCE.getMissingCases((KtWhenExpression)$this$canBeUsedAsValue, this.getBindingContext()).isEmpty();
        } else {
            bl = true;
        }
        return bl;
    }

    private final void checkFunctionWithExplicitReturnType(KtNamedFunction function) {
        String typeElementText;
        KtTypeReference typeReference = function.getTypeReference();
        KtTypeReference ktTypeReference = typeReference;
        String string = ktTypeReference != null && (ktTypeReference = ktTypeReference.getTypeElement()) != null ? ktTypeReference.getText() : (typeElementText = null);
        if (Intrinsics.areEqual((Object)typeElementText, (Object)UNIT)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)typeReference), (int)0, (int)2, null), this.createMessage(function), null, null, 24, null));
        }
    }

    private final void checkFunctionWithInferredReturnType(KtNamedFunction function) {
        KtNameReferenceExpression referenceExpression;
        KtExpression ktExpression = function.getBodyExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        if ((referenceExpression = (KtNameReferenceExpression)ktExpression) != null && Intrinsics.areEqual((Object)referenceExpression.getText(), (Object)UNIT)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)referenceExpression), (int)0, (int)2, null), this.createMessage(function), null, null, 24, null));
        }
    }

    private final boolean isInInterface(KtNamedFunction function) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)function;
        boolean $i$f$getStrictParentOfType = false;
        KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
        return ktClass != null ? ktClass.isInterface() : false;
    }

    private final String createMessage(KtNamedFunction function) {
        return "The function " + function.getName() + ' ' + "defines a return type of Unit. This is unnecessary and can safely be removed.";
    }

    public OptionalUnit(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Return type of 'Unit' is unnecessary and can be safely removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalUnit(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public OptionalUnit() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit$Companion;", "", "()V", "UNIT", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

