/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UntilInsteadOfRangeTo;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "report", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "rangeTo", "", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isMinusOneExpression", "", "Companion", "detekt-rules-style"})
public final class UntilInsteadOfRangeTo
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final String rangeToOperator = "..";
    @NotNull
    private static final String rangeTo = "rangeTo";

    public UntilInsteadOfRangeTo(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "A `..` call can be replaced with `until`.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UntilInsteadOfRangeTo(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (Intrinsics.areEqual((Object)expression.getOperationReference().getText(), (Object)rangeToOperator) && this.isMinusOneExpression(expression.getRight())) {
            this.report((KtExpression)expression, rangeToOperator);
        }
        super.visitBinaryExpression(expression);
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression ktExpression = expression.getCalleeExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)rangeTo)) {
            List list = expression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expression.valueArguments");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list);
            if (this.isMinusOneExpression((KtExpression)(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null))) {
                this.report((KtExpression)expression, rangeTo);
            }
        }
        super.visitCallExpression(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMinusOneExpression(KtExpression $this$isMinusOneExpression) {
        if (!($this$isMinusOneExpression instanceof KtBinaryExpression)) return false;
        if (((KtBinaryExpression)$this$isMinusOneExpression).getLeft() == null) return false;
        if (!Intrinsics.areEqual((Object)((KtBinaryExpression)$this$isMinusOneExpression).getOperationToken(), (Object)KtTokens.MINUS)) return false;
        KtExpression ktExpression = ((KtBinaryExpression)$this$isMinusOneExpression).getRight();
        KtConstantExpression ktConstantExpression = ktExpression instanceof KtConstantExpression ? (KtConstantExpression)ktExpression : null;
        if (!Intrinsics.areEqual((Object)(ktConstantExpression != null ? ktConstantExpression.getText() : null), (Object)"1")) return false;
        return true;
    }

    private final void report(KtExpression expression, String rangeTo) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), '\'' + rangeTo + "' call can be replaced with 'until'", null, null, 24, null));
    }

    public UntilInsteadOfRangeTo() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UntilInsteadOfRangeTo$Companion;", "", "()V", "rangeTo", "", "rangeToOperator", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

