/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import java.util.Arrays;

public enum FrameType {
    RESERVED(0),
    SETUP(1, 24),
    LEASE(2, 8),
    KEEPALIVE(3, 16),
    REQUEST_RESPONSE(4, 30),
    REQUEST_FNF(5, 30),
    REQUEST_STREAM(6, 31),
    REQUEST_CHANNEL(7, 31),
    REQUEST_N(8),
    CANCEL(9),
    PAYLOAD(10, 28),
    ERROR(11, 16),
    METADATA_PUSH(12, 8),
    RESUME(13),
    RESUME_OK(14),
    NEXT(160, 28),
    COMPLETE(176),
    NEXT_COMPLETE(192, 28),
    EXT(63, 24);

    static final int ENCODED_SIZE = 6;
    private static final FrameType[] FRAME_TYPES_BY_ENCODED_TYPE;
    private final int encodedType;
    private final int flags;

    private FrameType(int encodedType) {
        this(encodedType, 0);
    }

    private FrameType(int encodedType, int flags) {
        this.encodedType = encodedType;
        this.flags = flags;
    }

    public static FrameType fromEncodedType(int encodedType) {
        FrameType frameType = FRAME_TYPES_BY_ENCODED_TYPE[encodedType];
        if (frameType == null) {
            throw new IllegalArgumentException(String.format("Frame type %d is unknown", encodedType));
        }
        return frameType;
    }

    private static int getMaximumEncodedType() {
        return Arrays.stream(FrameType.values()).mapToInt(frameType -> frameType.encodedType).max().orElse(0);
    }

    public boolean canHaveData() {
        return 16 == (this.flags & 0x10);
    }

    public boolean canHaveMetadata() {
        return 8 == (this.flags & 8);
    }

    public int getEncodedType() {
        return this.encodedType;
    }

    public boolean hasInitialRequestN() {
        return 1 == (this.flags & 1);
    }

    public boolean isFragmentable() {
        return 4 == (this.flags & 4);
    }

    public boolean isRequestType() {
        return 2 == (this.flags & 2);
    }

    static {
        FRAME_TYPES_BY_ENCODED_TYPE = new FrameType[FrameType.getMaximumEncodedType() + 1];
        FrameType[] frameTypeArray = FrameType.values();
        int n = frameTypeArray.length;
        for (int i = 0; i < n; ++i) {
            FrameType frameType;
            FrameType.FRAME_TYPES_BY_ENCODED_TYPE[frameType.encodedType] = frameType = frameTypeArray[i];
        }
    }

    private static class Flags {
        private static final int EMPTY = 0;
        private static final int CAN_HAVE_DATA = 16;
        private static final int CAN_HAVE_METADATA = 8;
        private static final int IS_FRAGMENTABLE = 4;
        private static final int IS_REQUEST_TYPE = 2;
        private static final int HAS_INITIAL_REQUEST_N = 1;

        private Flags() {
        }
    }
}

