/*
 * Decompiled with CFR 0.152.
 */
package name.velikodniy.vitaliy.fixedlength.formatters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import name.velikodniy.vitaliy.fixedlength.FixedLengthException;
import name.velikodniy.vitaliy.fixedlength.annotation.FixedField;
import name.velikodniy.vitaliy.fixedlength.formatters.BigDecimalFormatter;
import name.velikodniy.vitaliy.fixedlength.formatters.DateFormatter;
import name.velikodniy.vitaliy.fixedlength.formatters.IntegerFormatter;
import name.velikodniy.vitaliy.fixedlength.formatters.LocalDateFormatter;
import name.velikodniy.vitaliy.fixedlength.formatters.LocalDateTimeFormatter;
import name.velikodniy.vitaliy.fixedlength.formatters.LocalTimeFormatter;
import name.velikodniy.vitaliy.fixedlength.formatters.LongFormatter;
import name.velikodniy.vitaliy.fixedlength.formatters.ShortFormatter;
import name.velikodniy.vitaliy.fixedlength.formatters.StringFormatter;

public abstract class Formatter<T> {
    private static final Map<Class<? extends Serializable>, Class<? extends Formatter<? extends Serializable>>> DEFAULT_FORMATTERS = new HashMap<Class<? extends Serializable>, Class<? extends Formatter<? extends Serializable>>>();

    public static Map<Class<? extends Serializable>, Class<? extends Formatter<? extends Serializable>>> getDefaultFormatters() {
        return DEFAULT_FORMATTERS;
    }

    public static Formatter<?> instance(Map<Class<? extends Serializable>, Class<? extends Formatter<? extends Serializable>>> formatters, Class<?> type) throws FixedLengthException {
        Class<? extends Formatter<? extends Serializable>> formatterClass = formatters.get(type);
        if (formatterClass != null) {
            try {
                return formatterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new FixedLengthException("Cannot create new instance of formatter " + formatterClass.getName());
            }
        }
        throw new FixedLengthException("Not found formatter for class " + type.getName());
    }

    public T parse(String value, FixedField field) {
        T result = null;
        if (value != null) {
            result = this.asObject(value, field);
        }
        return result;
    }

    public abstract T asObject(String var1, FixedField var2);

    public abstract String asString(T var1, FixedField var2);

    static {
        DEFAULT_FORMATTERS.put(String.class, StringFormatter.class);
        DEFAULT_FORMATTERS.put(Short.TYPE, ShortFormatter.class);
        DEFAULT_FORMATTERS.put(Short.class, ShortFormatter.class);
        DEFAULT_FORMATTERS.put(Integer.TYPE, IntegerFormatter.class);
        DEFAULT_FORMATTERS.put(Integer.class, IntegerFormatter.class);
        DEFAULT_FORMATTERS.put(Long.TYPE, LongFormatter.class);
        DEFAULT_FORMATTERS.put(Long.class, LongFormatter.class);
        DEFAULT_FORMATTERS.put(Date.class, DateFormatter.class);
        DEFAULT_FORMATTERS.put(LocalDate.class, LocalDateFormatter.class);
        DEFAULT_FORMATTERS.put(LocalTime.class, LocalTimeFormatter.class);
        DEFAULT_FORMATTERS.put(LocalDateTime.class, LocalDateTimeFormatter.class);
        DEFAULT_FORMATTERS.put(BigDecimal.class, BigDecimalFormatter.class);
    }
}

