/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.InputOutput;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JobInformations;
import net.bull.javamelody.internal.model.MBeansAccessor;
import net.bull.javamelody.internal.model.PID;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.QuartzAdapter;
import net.bull.javamelody.internal.model.S3;
import net.bull.javamelody.internal.web.MailReport;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.quartz.JobDetail;
import org.quartz.Scheduler;

public final class Action
extends Enum<Action> {
    public static final /* enum */ Action MAIL_TEST = new Action("");
    public static final /* enum */ Action CLEAR_COUNTER = new Action("http");
    public static final /* enum */ Action GC = new Action("systeminfo");
    public static final /* enum */ Action INVALIDATE_SESSIONS = new Action("systeminfo");
    public static final /* enum */ Action INVALIDATE_SESSION = new Action("");
    public static final /* enum */ Action LOGOUT = new Action("");
    public static final /* enum */ Action HEAP_DUMP = new Action("systeminfo");
    public static final /* enum */ Action CLEAR_CACHES = new Action("caches");
    public static final /* enum */ Action CLEAR_CACHE = new Action("caches");
    public static final /* enum */ Action CLEAR_CACHE_KEY = new Action("caches");
    public static final /* enum */ Action CLEAR_JCACHES = new Action("caches");
    public static final /* enum */ Action CLEAR_JCACHE = new Action("caches");
    public static final /* enum */ Action CLEAR_JCACHE_KEY = new Action("caches");
    public static final /* enum */ Action KILL_THREAD = new Action("threads");
    public static final /* enum */ Action SEND_THREAD_INTERRUPT = new Action("threads");
    public static final /* enum */ Action PAUSE_JOB = new Action("jobs");
    public static final /* enum */ Action RESUME_JOB = new Action("jobs");
    public static final /* enum */ Action CLEAR_HOTSPOTS = new Action("");
    public static final /* enum */ Action PURGE_OBSOLETE_FILES = new Action("bottom");
    public static final boolean GC_ENABLED;
    static final String JAVA_VENDOR;
    private static final String ALL = "all";
    private final String contextName;
    private static final /* synthetic */ Action[] $VALUES;

    public static Action[] values() {
        return (Action[])$VALUES.clone();
    }

    public static Action valueOf(String name) {
        return Enum.valueOf(Action.class, name);
    }

    private Action(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName(String counterName) {
        if (this == CLEAR_COUNTER && !ALL.equalsIgnoreCase(counterName)) {
            return counterName;
        }
        return this.contextName;
    }

    public static Action valueOfIgnoreCase(String action) {
        return Action.valueOf(action.toUpperCase(Locale.ENGLISH).trim());
    }

    public static void checkSystemActionsEnabled() {
        if (!Parameters.isSystemActionsEnabled()) {
            throw new IllegalStateException(I18N.getString("Actions_non_activees"));
        }
    }

    public String execute(Collector collector, CollectorServer collectorServer, String counterName, String sessionId, String threadId, String jobId, String cacheId) throws IOException {
        return this.execute(collector, collectorServer, null, counterName, sessionId, threadId, jobId, cacheId, null);
    }

    String execute(Collector collector, CollectorServer collectorServer, HttpSession currentSession, String counterName, String sessionId, String threadId, String jobId, String cacheId) throws IOException {
        return this.execute(collector, collectorServer, currentSession, counterName, sessionId, threadId, jobId, cacheId, null);
    }

    public String execute(Collector collector, CollectorServer collectorServer, HttpSession currentSession, String counterName, String sessionId, String threadId, String jobId, String cacheId, String cacheKey) throws IOException {
        String messageForReport;
        switch (this) {
            case CLEAR_COUNTER: {
                assert (collector != null);
                assert (counterName != null);
                messageForReport = this.clearCounter(collector, counterName);
                break;
            }
            case MAIL_TEST: {
                assert (collector != null);
                messageForReport = this.mailTest(collector, collectorServer);
                break;
            }
            case GC: {
                if (GC_ENABLED) {
                    long kbFreed = this.gc();
                    long stillUsed = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
                    messageForReport = I18N.getFormattedString("ramasse_miette_execute", kbFreed, stillUsed);
                    break;
                }
                messageForReport = I18N.getString("ramasse_miette_desactive");
                break;
            }
            case HEAP_DUMP: {
                if (JAVA_VENDOR.contains("IBM")) {
                    this.ibmHeapDump();
                    messageForReport = I18N.getString("heap_dump_genere_ibm");
                    break;
                }
                File heapDump = this.heapDump();
                File zipFile = new File(heapDump.getParentFile(), heapDump.getName() + ".zip");
                InputOutput.zipFile(heapDump, zipFile);
                InputOutput.deleteFile(heapDump);
                String message = "";
                if (Parameter.HEAP_DUMP_S3_BUCKETNAME.getValue() != null) {
                    try {
                        S3.upload(zipFile, Parameter.HEAP_DUMP_S3_BUCKETNAME.getValue());
                        message = I18N.getFormattedString("heap_dump_uploaded_to_s3", zipFile.getName()) + ' ';
                    }
                    catch (IOException e) {
                        message = "Failed to upload heap dump to S3 - " + e.getMessage() + '\n';
                    }
                }
                String path = zipFile.getPath();
                messageForReport = message + I18N.getFormattedString("heap_dump_genere", path.replace('\\', '/'));
                break;
            }
            case INVALIDATE_SESSIONS: {
                SessionListener.invalidateAllSessionsExceptCurrentSession(currentSession);
                messageForReport = I18N.getString("sessions_http_invalidees");
                break;
            }
            case INVALIDATE_SESSION: {
                assert (sessionId != null);
                SessionListener.invalidateSession(sessionId);
                messageForReport = I18N.getString("session_http_invalidee");
                break;
            }
            case LOGOUT: {
                if (currentSession != null) {
                    SessionListener.invalidateSession(currentSession.getId());
                }
                messageForReport = I18N.getString("logged_out");
                break;
            }
            case CLEAR_CACHES: {
                this.clearCaches();
                messageForReport = I18N.getString("caches_purges");
                break;
            }
            case CLEAR_CACHE: {
                this.clearCache(cacheId);
                messageForReport = I18N.getFormattedString("cache_purge", cacheId);
                break;
            }
            case CLEAR_CACHE_KEY: {
                this.clearCacheKey(cacheId, cacheKey);
                messageForReport = I18N.getFormattedString("cache_key_purge", cacheId, cacheKey);
                break;
            }
            case CLEAR_JCACHES: {
                this.clearJCaches();
                messageForReport = I18N.getString("caches_purges");
                break;
            }
            case CLEAR_JCACHE: {
                this.clearJCache(cacheId);
                messageForReport = I18N.getFormattedString("cache_purge", cacheId);
                break;
            }
            case CLEAR_JCACHE_KEY: {
                this.clearJCacheKey(cacheId, cacheKey);
                messageForReport = I18N.getFormattedString("cache_key_purge", cacheId, cacheKey);
                break;
            }
            case KILL_THREAD: {
                assert (threadId != null);
                messageForReport = this.killThread(threadId);
                break;
            }
            case SEND_THREAD_INTERRUPT: {
                assert (threadId != null);
                messageForReport = this.sendThreadInterrupt(threadId);
                break;
            }
            case PAUSE_JOB: {
                assert (jobId != null);
                messageForReport = this.pauseJob(jobId);
                break;
            }
            case RESUME_JOB: {
                assert (jobId != null);
                messageForReport = this.resumeJob(jobId);
                break;
            }
            case CLEAR_HOTSPOTS: {
                assert (collector.getSamplingProfiler() != null);
                collector.getSamplingProfiler().clear();
                messageForReport = I18N.getString("hotspots_cleared");
                break;
            }
            case PURGE_OBSOLETE_FILES: {
                assert (collector != null);
                collector.deleteObsoleteFiles();
                messageForReport = I18N.getString("fichiers_obsoletes_purges") + '\n' + I18N.getString("Usage_disque") + ": " + (collector.getDiskUsage() / 1024L / 1024L + 1L) + ' ' + I18N.getString("Mo");
                break;
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
        if (messageForReport != null) {
            LOG.debug("Action '" + (Object)((Object)this) + "' executed. Result: " + messageForReport.replace('\n', ' '));
        }
        return messageForReport;
    }

    private String clearCounter(Collector collector, String counterName) {
        String messageForReport;
        if (ALL.equalsIgnoreCase(counterName)) {
            for (Counter counter : collector.getCounters()) {
                collector.clearCounter(counter.getName());
            }
            messageForReport = I18N.getFormattedString("Toutes_statistiques_reinitialisees", counterName);
        } else {
            collector.clearCounter(counterName);
            messageForReport = I18N.getFormattedString("Statistiques_reinitialisees", counterName);
        }
        return messageForReport;
    }

    private String mailTest(Collector collector, CollectorServer collectorServer) {
        if (!Parameters.isPdfEnabled()) {
            throw new IllegalStateException("itext classes not found: add the itext dependency");
        }
        if (Parameter.MAIL_SESSION.getValue() == null) {
            throw new IllegalStateException("mail-session has no value: add the mail-session parameter");
        }
        if (Parameter.ADMIN_EMAILS.getValue() == null) {
            throw new IllegalStateException("admin-emails has no value: add the admin-emails parameter");
        }
        try {
            if (collectorServer == null) {
                new MailReport().sendReportMailForLocalServer(collector, Period.JOUR);
            } else {
                new MailReport().sendReportMail(collector, true, collectorServer.getJavaInformationsByApplication(collector.getApplication()), Period.JOUR);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "Mail sent with pdf report for the day to admins";
    }

    private File heapDump() throws IOException {
        try {
            String path;
            ObjectName objectName = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
            CompositeData vmOption = (CompositeData)MBeansAccessor.invoke(objectName, "getVMOption", new Object[]{"HeapDumpPath"}, new Class[]{String.class});
            String heapDumpPath = vmOption == null ? null : (String)vmOption.get("value");
            if (heapDumpPath == null || heapDumpPath.isEmpty()) {
                path = Parameters.TEMPORARY_DIRECTORY.getPath();
            } else {
                File file = new File(heapDumpPath);
                if (file.exists()) {
                    path = file.isDirectory() ? heapDumpPath : file.getParent();
                } else {
                    if (!file.mkdirs()) {
                        throw new IllegalStateException("Can't create directory " + file.getPath());
                    }
                    path = heapDumpPath;
                }
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault());
            File heapDumpFile = new File(path, "heapdump-" + Parameters.getHostName() + '-' + PID.getPID() + '-' + dateFormat.format(new Date()) + ".hprof");
            if (heapDumpFile.exists()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                return this.heapDump();
            }
            boolean gcBeforeHeapDump = true;
            MBeansAccessor.invoke(objectName, "dumpHeap", new Object[]{heapDumpFile.getPath(), true}, new Class[]{String.class, Boolean.TYPE});
            return heapDumpFile;
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
    }

    private void ibmHeapDump() {
        try {
            Class<?> dumpClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.ibm.jvm.Dump");
            Class<?>[] argTypes = null;
            Method dump = dumpClass.getMethod("HeapDump", argTypes);
            Object[] args = null;
            dump.invoke(null, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private long gc() {
        long before = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        Runtime.getRuntime().gc();
        long after = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return (before - after) / 1024L;
    }

    private void clearCaches() {
        List allCacheManagers = CacheManager.ALL_CACHE_MANAGERS;
        for (CacheManager cacheManager : allCacheManagers) {
            cacheManager.clearAll();
        }
    }

    private void clearCache(String cacheId) {
        List allCacheManagers = CacheManager.ALL_CACHE_MANAGERS;
        for (CacheManager cacheManager : allCacheManagers) {
            Cache cache = cacheManager.getCache(cacheId);
            if (cache == null) continue;
            cache.removeAll();
        }
    }

    private void clearCacheKey(String cacheId, String cacheKey) {
        List allCacheManagers = CacheManager.ALL_CACHE_MANAGERS;
        block0: for (CacheManager cacheManager : allCacheManagers) {
            boolean removed;
            Cache cache = cacheManager.getCache(cacheId);
            if (cache == null || (removed = cache.remove((Serializable)((Object)cacheKey)))) continue;
            for (Object key : cache.getKeys()) {
                if (key == null || !key.toString().equals(cacheKey)) continue;
                cache.remove(key);
                continue block0;
            }
        }
    }

    private void clearJCaches() {
        for (CachingProvider cachingProvider : Caching.getCachingProviders()) {
            javax.cache.CacheManager cacheManager = cachingProvider.getCacheManager();
            for (String cacheName : cacheManager.getCacheNames()) {
                cacheManager.getCache(cacheName).clear();
            }
        }
    }

    private void clearJCache(String cacheId) {
        block0: for (CachingProvider cachingProvider : Caching.getCachingProviders()) {
            javax.cache.CacheManager cacheManager = cachingProvider.getCacheManager();
            for (String cacheName : cacheManager.getCacheNames()) {
                if (!cacheName.equals(cacheId)) continue;
                cacheManager.getCache(cacheId).clear();
                continue block0;
            }
        }
    }

    private void clearJCacheKey(String cacheId, String cacheKey) {
        for (CachingProvider cachingProvider : Caching.getCachingProviders()) {
            javax.cache.CacheManager cacheManager = cachingProvider.getCacheManager();
            block1: for (String cacheName : cacheManager.getCacheNames()) {
                javax.cache.Cache cache;
                boolean removed;
                if (!cacheName.equals(cacheId) || (removed = (cache = cacheManager.getCache(cacheId)).remove((Object)cacheKey))) continue;
                for (Cache.Entry entry : cache) {
                    Object key = entry.getKey();
                    if (key == null || !key.toString().equals(cacheKey)) continue;
                    cache.remove(key);
                    continue block1;
                }
            }
        }
    }

    private String killThread(String globalThreadId) {
        Long threadId = this.getThreadIdFromGlobalThreadIdIfSameJvm(globalThreadId);
        if (threadId != null) {
            List<Thread> threads = JavaInformations.getThreadsFromThreadGroups();
            for (Thread thread : threads) {
                if (thread.getId() != threadId.longValue()) continue;
                if (thread.getName().startsWith("javamelody")) {
                    return "I will not kill myself";
                }
                this.stopThread(thread);
                return I18N.getFormattedString("Thread_tue", thread.getName());
            }
            return I18N.getString("Thread_non_trouve");
        }
        return null;
    }

    private void stopThread(Thread thread) {
        thread.stop();
    }

    private String sendThreadInterrupt(String globalThreadId) {
        Long threadId = this.getThreadIdFromGlobalThreadIdIfSameJvm(globalThreadId);
        if (threadId != null) {
            List<Thread> threads = JavaInformations.getThreadsFromThreadGroups();
            for (Thread thread : threads) {
                if (thread.getId() != threadId.longValue()) continue;
                if (thread.getName().startsWith("javamelody")) {
                    return "I will not interrupt myself";
                }
                thread.interrupt();
                return I18N.getFormattedString("thread_interrupt_sent", thread.getName());
            }
            return I18N.getString("Thread_non_trouve");
        }
        return null;
    }

    private Long getThreadIdFromGlobalThreadIdIfSameJvm(String globalThreadId) {
        String[] values = globalThreadId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(globalThreadId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            return Long.valueOf(values[2]);
        }
        return null;
    }

    private String pauseJob(String jobId) {
        if (ALL.equalsIgnoreCase(jobId)) {
            this.pauseAllJobs();
            return I18N.getString("all_jobs_paused");
        }
        String[] values = jobId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(jobId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            if (this.pauseJobById(Integer.parseInt(values[2]))) {
                return I18N.getString("job_paused");
            }
            return I18N.getString("job_notfound");
        }
        return null;
    }

    private boolean pauseJobById(int myJobId) {
        try {
            QuartzAdapter quartzAdapter = QuartzAdapter.getSingleton();
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                for (JobDetail jobDetail : quartzAdapter.getAllJobsOfScheduler(scheduler)) {
                    if (quartzAdapter.getJobFullName(jobDetail).hashCode() != myJobId) continue;
                    quartzAdapter.pauseJob(jobDetail, scheduler);
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void pauseAllJobs() {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                scheduler.pauseAll();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String resumeJob(String jobId) {
        if (ALL.equalsIgnoreCase(jobId)) {
            this.resumeAllJobs();
            return I18N.getString("all_jobs_resumed");
        }
        String[] values = jobId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(jobId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            if (this.resumeJobById(Integer.parseInt(values[2]))) {
                return I18N.getString("job_resumed");
            }
            return I18N.getString("job_notfound");
        }
        return null;
    }

    private boolean resumeJobById(int myJobId) {
        try {
            QuartzAdapter quartzAdapter = QuartzAdapter.getSingleton();
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                for (JobDetail jobDetail : quartzAdapter.getAllJobsOfScheduler(scheduler)) {
                    if (quartzAdapter.getJobFullName(jobDetail).hashCode() != myJobId) continue;
                    quartzAdapter.resumeJob(jobDetail, scheduler);
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void resumeAllJobs() {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                scheduler.resumeAll();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        $VALUES = new Action[]{MAIL_TEST, CLEAR_COUNTER, GC, INVALIDATE_SESSIONS, INVALIDATE_SESSION, LOGOUT, HEAP_DUMP, CLEAR_CACHES, CLEAR_CACHE, CLEAR_CACHE_KEY, CLEAR_JCACHES, CLEAR_JCACHE, CLEAR_JCACHE_KEY, KILL_THREAD, SEND_THREAD_INTERRUPT, PAUSE_JOB, RESUME_JOB, CLEAR_HOTSPOTS, PURGE_OBSOLETE_FILES};
        GC_ENABLED = !ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-XX:+DisableExplicitGC");
        JAVA_VENDOR = System.getProperty("java.vendor");
    }
}

