/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.CacheInformations;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.JCacheInformations;
import net.bull.javamelody.internal.model.JRobin;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.MemoryInformations;
import net.bull.javamelody.internal.model.TomcatInformations;

class PrometheusController {
    private static final String METRIC_PREFIX = "javamelody_";
    private static final Pattern CAMEL_TO_SNAKE_PATTERN = Pattern.compile("([a-z])([A-Z]+)");
    private static final Pattern SANITIZE_TO_UNDERSCORE_PATTERN = Pattern.compile("[- :]");
    private static final Pattern SANITIZE_REMOVE_PATTERN = Pattern.compile("[^a-z0-9_]");
    private static final String EMPTY_STRING = "";
    private static final String UNDERSCORE = "_";
    private final JavaInformations javaInformations;
    private final Collector collector;
    private final PrintWriter out;
    private final DecimalFormat decimalFormat;

    PrometheusController(List<JavaInformations> javaInformations, Collector collector, PrintWriter out) throws IOException {
        assert (javaInformations != null && !javaInformations.isEmpty());
        assert (collector != null);
        assert (out != null);
        if (javaInformations.size() > 1) {
            throw new IOException("JavaMelody collector server not supported - configure Prometheus to scrape nodes.");
        }
        this.javaInformations = javaInformations.get(0);
        this.collector = collector;
        this.out = out;
        this.decimalFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
        decimalFormatSymbols.setNaN("NaN");
        this.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.decimalFormat.setGroupingUsed(false);
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.decimalFormat.setMaximumFractionDigits(15);
    }

    void report(boolean includeLastValue) throws IOException {
        this.reportOnMemoryInformations(this.javaInformations.getMemoryInformations());
        this.reportOnJavaInformations();
        if (this.javaInformations.getTomcatInformationsList() != null) {
            this.reportOnTomcatInformations();
        }
        if (this.javaInformations.isCacheEnabled()) {
            this.reportOnCacheInformations();
        }
        if (this.javaInformations.isJCacheEnabled()) {
            this.reportOnJCacheInformations();
        }
        this.reportOnCollector();
        if (includeLastValue) {
            this.reportOnLastValues();
        }
    }

    private void reportOnCacheInformations() {
        List<CacheInformations> cacheInformationsList = this.javaInformations.getCacheInformationsList();
        LinkedHashMap<String, CacheInformations> cacheInfos = new LinkedHashMap<String, CacheInformations>(cacheInformationsList.size());
        for (CacheInformations cacheInformations : cacheInformationsList) {
            String fields = "{cache_name=\"" + PrometheusController.sanitizeName(cacheInformations.getName()) + "\"}";
            cacheInfos.put(fields, cacheInformations);
        }
        this.printHeader(MetricType.GAUGE, "cache_in_memory_count", "cache in memory count");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printLongWithFields("cache_in_memory_count", (String)entry.getKey(), ((CacheInformations)entry.getValue()).getInMemoryObjectCount());
        }
        this.printHeader(MetricType.GAUGE, "cache_in_memory_used_pct", "in memory used percent");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printDoubleWithFields("cache_in_memory_used_pct", (String)entry.getKey(), (double)((CacheInformations)entry.getValue()).getInMemoryPercentUsed() / 100.0);
        }
        this.printHeader(MetricType.GAUGE, "cache_in_memory_hits_pct", "cache in memory hit percent");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printDoubleWithFields("cache_in_memory_hits_pct", (String)entry.getKey(), (double)((CacheInformations)entry.getValue()).getInMemoryHitsRatio() / 100.0);
        }
        this.printHeader(MetricType.GAUGE, "cache_on_disk_count", "cache on disk count");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printLongWithFields("cache_on_disk_count", (String)entry.getKey(), ((CacheInformations)entry.getValue()).getOnDiskObjectCount());
        }
        this.printHeader(MetricType.GAUGE, "cache_hits_pct", "cache hits percent");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printDoubleWithFields("cache_hits_pct", (String)entry.getKey(), (double)((CacheInformations)entry.getValue()).getHitsRatio() / 100.0);
        }
        this.printHeader(MetricType.COUNTER, "cache_in_memory_hits_count", "total cache in memory hit count");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printLongWithFields("cache_in_memory_hits_count", (String)entry.getKey(), ((CacheInformations)entry.getValue()).getInMemoryHits());
        }
        this.printHeader(MetricType.COUNTER, "cache_hits_count", "total cache hit count");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printLongWithFields("cache_hits_count", (String)entry.getKey(), ((CacheInformations)entry.getValue()).getCacheHits());
        }
        this.printHeader(MetricType.COUNTER, "cache_misses_count", "total cache misses count");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printLongWithFields("cache_misses_count", (String)entry.getKey(), ((CacheInformations)entry.getValue()).getCacheMisses());
        }
    }

    private void reportOnJCacheInformations() {
        List<JCacheInformations> jcacheInformationsList = this.javaInformations.getJCacheInformationsList();
        LinkedHashMap<String, JCacheInformations> cacheInfos = new LinkedHashMap<String, JCacheInformations>(jcacheInformationsList.size());
        for (JCacheInformations jCacheInformations : jcacheInformationsList) {
            String fields = "{cache_name=\"" + PrometheusController.sanitizeName(jCacheInformations.getName()) + "\"}";
            cacheInfos.put(fields, jCacheInformations);
        }
        this.printHeader(MetricType.GAUGE, "jcache_hits_pct", "cache hits percent");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printDoubleWithFields("jcache_hits_pct", (String)entry.getKey(), (double)((JCacheInformations)entry.getValue()).getHitsRatio() / 100.0);
        }
        this.printHeader(MetricType.COUNTER, "jcache_hits_count", "total cache hit count");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printLongWithFields("jcache_hits_count", (String)entry.getKey(), ((JCacheInformations)entry.getValue()).getCacheHits());
        }
        this.printHeader(MetricType.COUNTER, "jcache_misses_count", "total cache misses count");
        for (Map.Entry entry : cacheInfos.entrySet()) {
            this.printLongWithFields("jcache_misses_count", (String)entry.getKey(), ((JCacheInformations)entry.getValue()).getCacheMisses());
        }
    }

    private void reportOnTomcatInformations() {
        LinkedHashMap<String, TomcatInformations> tcInfos = new LinkedHashMap<String, TomcatInformations>();
        for (TomcatInformations tomcatInformations : this.javaInformations.getTomcatInformationsList()) {
            if (tomcatInformations.getRequestCount() <= 0) continue;
            String fields = "{tomcat_name=\"" + PrometheusController.sanitizeName(tomcatInformations.getName()) + "\"}";
            tcInfos.put(fields, tomcatInformations);
        }
        if (tcInfos.isEmpty()) {
            return;
        }
        this.printHeader(MetricType.GAUGE, "tomcat_threads_max", "tomcat max threads");
        for (Map.Entry entry : tcInfos.entrySet()) {
            this.printLongWithFields("tomcat_threads_max", (String)entry.getKey(), ((TomcatInformations)entry.getValue()).getMaxThreads());
        }
        this.printHeader(MetricType.GAUGE, "tomcat_thread_busy_count", "tomcat currently busy threads");
        for (Map.Entry entry : tcInfos.entrySet()) {
            this.printLongWithFields("tomcat_thread_busy_count", (String)entry.getKey(), ((TomcatInformations)entry.getValue()).getCurrentThreadsBusy());
        }
        this.printHeader(MetricType.COUNTER, "tomcat_received_bytes", "tomcat total received bytes");
        for (Map.Entry entry : tcInfos.entrySet()) {
            this.printLongWithFields("tomcat_received_bytes", (String)entry.getKey(), ((TomcatInformations)entry.getValue()).getBytesReceived());
        }
        this.printHeader(MetricType.COUNTER, "tomcat_sent_bytes", "tomcat total sent bytes");
        for (Map.Entry entry : tcInfos.entrySet()) {
            this.printLongWithFields("tomcat_sent_bytes", (String)entry.getKey(), ((TomcatInformations)entry.getValue()).getBytesSent());
        }
        this.printHeader(MetricType.COUNTER, "tomcat_request_count", "tomcat total request count");
        for (Map.Entry entry : tcInfos.entrySet()) {
            this.printLongWithFields("tomcat_request_count", (String)entry.getKey(), ((TomcatInformations)entry.getValue()).getRequestCount());
        }
        this.printHeader(MetricType.COUNTER, "tomcat_error_count", "tomcat total error count");
        for (Map.Entry entry : tcInfos.entrySet()) {
            this.printLongWithFields("tomcat_error_count", (String)entry.getKey(), ((TomcatInformations)entry.getValue()).getErrorCount());
        }
        this.printHeader(MetricType.COUNTER, "tomcat_processing_time_millis", "tomcat total processing time");
        for (Map.Entry entry : tcInfos.entrySet()) {
            this.printLongWithFields("tomcat_processing_time_millis", (String)entry.getKey(), ((TomcatInformations)entry.getValue()).getProcessingTime());
        }
        this.printHeader(MetricType.GAUGE, "tomcat_max_time_millis", "tomcat max time for single request");
        for (Map.Entry entry : tcInfos.entrySet()) {
            this.printLongWithFields("tomcat_max_time_millis", (String)entry.getKey(), ((TomcatInformations)entry.getValue()).getMaxTime());
        }
    }

    private void reportOnCollector() {
        for (Counter counter : this.collector.getCounters()) {
            if (!counter.isDisplayed()) continue;
            List<CounterRequest> requests = counter.getRequests();
            long hits = 0L;
            long duration = 0L;
            long errors = 0L;
            for (CounterRequest cr : requests) {
                hits += cr.getHits();
                duration += cr.getDurationsSum();
                errors += cr.getSystemErrors();
            }
            String sanitizedName = PrometheusController.sanitizeName(counter.getName());
            this.printLong(MetricType.COUNTER, sanitizedName + "_hits_count", "javamelody counter", hits);
            if (!counter.isErrorCounter() || counter.isJobCounter()) {
                this.printLong(MetricType.COUNTER, sanitizedName + "_errors_count", "javamelody counter", errors);
            }
            if (duration < 0L) continue;
            this.printLong(MetricType.COUNTER, sanitizedName + "_duration_millis", "javamelody counter", duration);
        }
    }

    private void reportOnLastValues() throws IOException {
        Collection<JRobin> jrobins = this.collector.getDisplayedCounterJRobins();
        for (JRobin jrobin : jrobins) {
            this.printDouble(MetricType.GAUGE, "last_value_" + PrometheusController.camelToSnake(jrobin.getName()), "javamelody value per minute", jrobin.getLastValue());
        }
        jrobins = this.collector.getDisplayedOtherJRobins();
        for (JRobin jrobin : jrobins) {
            this.printDouble(MetricType.GAUGE, "last_value_" + PrometheusController.camelToSnake(jrobin.getName()), "javamelody value per minute", jrobin.getLastValue());
        }
    }

    private void reportOnJavaInformations() {
        if (this.javaInformations.getSessionCount() >= 0) {
            this.printLong(MetricType.GAUGE, "sessions_active_count", "active session count", this.javaInformations.getSessionCount());
            this.printLong(MetricType.GAUGE, "sessions_age_avg_minutes", "session avg age in minutes", this.javaInformations.getSessionMeanAgeInMinutes());
        }
        if (!Parameters.isNoDatabase()) {
            this.printLong(MetricType.COUNTER, "transactions_count", "transactions count", this.javaInformations.getTransactionCount());
            this.printLong(MetricType.GAUGE, "connections_used_count", "used connections count", this.javaInformations.getActiveConnectionCount());
            this.printLong(MetricType.GAUGE, "connections_active_count", "active connections", this.javaInformations.getActiveConnectionCount());
            if (this.javaInformations.getMaxConnectionCount() > 0) {
                this.printLong(MetricType.GAUGE, "connections_max_count", "max connections", this.javaInformations.getMaxConnectionCount());
                this.printDouble(MetricType.GAUGE, "connections_used_pct", "used connections percentage", this.javaInformations.getUsedConnectionPercentage());
            }
        }
        if (this.javaInformations.getSystemLoadAverage() >= 0.0) {
            this.printDouble(MetricType.GAUGE, "system_load_avg", "system load average", this.javaInformations.getSystemLoadAverage());
        }
        if (this.javaInformations.getSystemCpuLoad() >= 0.0) {
            this.printDouble(MetricType.GAUGE, "system_cpu_load_pct", "system cpu load", this.javaInformations.getSystemCpuLoad());
        }
        if (this.javaInformations.getUnixOpenFileDescriptorCount() >= 0L) {
            this.printDouble(MetricType.GAUGE, "system_unix_file_descriptors_open_count", "unix open file descriptors count", this.javaInformations.getUnixOpenFileDescriptorCount());
            this.printDouble(MetricType.GAUGE, "system_unix_file_descriptors_max", "unix file descriptors max", this.javaInformations.getUnixMaxFileDescriptorCount());
            this.printDouble(MetricType.GAUGE, "system_unix_file_descriptors_open_pct", "unix open file descriptors percentage", this.javaInformations.getUnixOpenFileDescriptorPercentage());
        }
        if (this.javaInformations.getFreeDiskSpaceInTemp() >= 0L) {
            this.printLong(MetricType.GAUGE, "system_tmp_space_free_bytes", "tmp space available", this.javaInformations.getFreeDiskSpaceInTemp());
        }
        this.printLong(MetricType.GAUGE, "jvm_start_time", "jvm start time", this.javaInformations.getStartDate().getTime());
        this.printLong(MetricType.COUNTER, "jvm_cpu_millis", "jvm cpu millis", this.javaInformations.getProcessCpuTimeMillis());
        this.printLong(MetricType.GAUGE, "system_processors_count", "processors available", this.javaInformations.getAvailableProcessors());
        this.printLong(MetricType.GAUGE, "threads_count", "threads count", this.javaInformations.getThreadCount());
        this.printLong(MetricType.GAUGE, "threads_max_count", "threads peak count", this.javaInformations.getPeakThreadCount());
        this.printLong(MetricType.COUNTER, "threads_started_count", "total threads started", this.javaInformations.getTotalStartedThreadCount());
        this.printLong(MetricType.GAUGE, "threads_active_count", "active thread count", this.javaInformations.getActiveThreadCount());
        if (this.javaInformations.isJobEnabled()) {
            this.printLong(MetricType.GAUGE, "job_executing_count", "executing job count", this.javaInformations.getCurrentlyExecutingJobCount());
        }
    }

    private void reportOnMemoryInformations(MemoryInformations memoryInformations) {
        this.printLong(MetricType.GAUGE, "memory_used_bytes", "used memory in bytes", memoryInformations.getUsedMemory());
        this.printLong(MetricType.GAUGE, "memory_max_bytes", "max memory in bytes", memoryInformations.getMaxMemory());
        this.printDouble(MetricType.GAUGE, "memory_used_pct", "memory used percentage", memoryInformations.getUsedMemoryPercentage());
        if (memoryInformations.getUsedPermGen() > 0L) {
            this.printLong(MetricType.GAUGE, "memory_perm_gen_used_bytes", "used perm gen memory in bytes", memoryInformations.getUsedPermGen());
            if (memoryInformations.getMaxPermGen() > 0L) {
                this.printLong(MetricType.GAUGE, "memory_perm_gen_max_bytes", "max perm gen memory in bytes", memoryInformations.getMaxPermGen());
                this.printDouble(MetricType.GAUGE, "memory_perm_gen_used_pct", "used perm gen memory percentage", memoryInformations.getUsedPermGenPercentage());
            }
        }
        this.printDouble(MetricType.COUNTER, "memory_gc_millis", "gc time millis", memoryInformations.getGarbageCollectionTimeMillis());
    }

    private static String camelToSnake(String camel) {
        return CAMEL_TO_SNAKE_PATTERN.matcher(camel).replaceAll("$1_$2").toLowerCase(Locale.US);
    }

    private static String sanitizeName(String name) {
        String lowerCaseName = name.toLowerCase(Locale.US);
        String separatorReplacedName = SANITIZE_TO_UNDERSCORE_PATTERN.matcher(lowerCaseName).replaceAll(UNDERSCORE);
        return SANITIZE_REMOVE_PATTERN.matcher(separatorReplacedName).replaceAll(EMPTY_STRING);
    }

    private void printLong(MetricType metricType, String name, String description, long value) {
        this.printHeader(metricType, name, description);
        this.printLongWithFields(name, null, value);
    }

    private void printDouble(MetricType metricType, String name, String description, double value) {
        this.printHeader(metricType, name, description);
        this.printDoubleWithFields(name, null, value);
    }

    private void printLongWithFields(String name, String fields, long value) {
        this.print(METRIC_PREFIX);
        this.print(name);
        if (fields != null) {
            this.print(fields);
        }
        this.print(' ');
        this.println(String.valueOf(value));
    }

    private void printDoubleWithFields(String name, String fields, double value) {
        this.print(METRIC_PREFIX);
        this.print(name);
        if (fields != null) {
            this.print(fields);
        }
        this.print(' ');
        this.println(this.decimalFormat.format(value));
    }

    private void printHeader(MetricType metricType, String name, String description) {
        this.print("# HELP ");
        this.print(METRIC_PREFIX);
        this.print(name);
        this.print(' ');
        this.println(description);
        this.print("# TYPE ");
        this.print(METRIC_PREFIX);
        this.print(name);
        this.print(' ');
        this.println(metricType.getCode());
    }

    private void print(String s) {
        this.out.print(s);
    }

    private void print(char c) {
        this.out.print(c);
    }

    private void println(String s) {
        this.out.print(s);
        this.out.print('\n');
    }

    private static enum MetricType {
        GAUGE("gauge"),
        COUNTER("counter");

        private final String code;

        private MetricType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

