/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.CacheInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

public class HtmlCacheInformationsReport
extends HtmlAbstractReport {
    private final List<CacheInformations> cacheInformationsList;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final boolean hitsRatioEnabled;
    private final boolean configurationEnabled;
    private final boolean systemActionsEnabled = Parameters.isSystemActionsEnabled();

    HtmlCacheInformationsReport(List<CacheInformations> cacheInformationsList, Writer writer) {
        super(writer);
        assert (cacheInformationsList != null);
        this.cacheInformationsList = cacheInformationsList;
        this.hitsRatioEnabled = HtmlCacheInformationsReport.isHitsRatioEnabled(cacheInformationsList);
        this.configurationEnabled = HtmlCacheInformationsReport.isConfigurationEnabled(cacheInformationsList);
    }

    @Override
    void toHtml() throws IOException {
        this.writeCaches(this.cacheInformationsList);
        this.write("<div align='right' class='noPrint'>");
        if (!this.hitsRatioEnabled) {
            this.writeln("#caches_statistics_enable#<br/>");
        }
        if (this.systemActionsEnabled) {
            this.writeln("<a href='?action=clear_caches" + HtmlCacheInformationsReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:return confirm('" + HtmlCacheInformationsReport.getStringForJavascript("confirm_purge_caches") + "');\">");
            this.writeln("<img src='?resource=user-trash.png' width='18' height='18' alt=\"#Purge_caches#\" /> #Purge_caches#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writeDirectly("<a href='http://ehcache.org/apidocs/2.9/net/sf/ehcache/config/CacheConfiguration.html#field_summary'");
        this.writeln("target='_blank'>Configuration reference</a></div>");
    }

    private void writeCaches(List<CacheInformations> cacheInformations) throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable(this);
        table.beginTable(HtmlCacheInformationsReport.getString("Caches"));
        this.write("<th>#Cache#</th>");
        if (this.configurationEnabled) {
            this.write("<th class='sorttable_numeric'>#Pourcentage_memoire_utilise#</th>");
        }
        this.write("<th class='sorttable_numeric'>#Nb_objets_en_memoire#</th>");
        this.write("<th class='sorttable_numeric'>#Nb_objets_sur_disque#</th>");
        if (this.hitsRatioEnabled) {
            this.write("<th class='sorttable_numeric'>");
            this.write(HtmlCacheInformationsReport.getString("Efficacite_cache_memoire").replaceAll("\n", "<br/>"));
            this.write("</th><th class='sorttable_numeric'>");
            this.write(HtmlCacheInformationsReport.getString("Efficacite_cache").replaceAll("\n", "<br/>"));
            this.write("</th>");
        }
        if (this.configurationEnabled) {
            this.write("<th>#Configuration#</th>");
        }
        if (this.systemActionsEnabled) {
            this.write("<th class='noPrint'>#Purger#</th>");
        }
        for (CacheInformations cacheInfos : cacheInformations) {
            table.nextRow();
            this.writeCacheInformations(cacheInfos);
        }
        table.endTable();
    }

    private void writeCacheInformations(CacheInformations cacheInformations) throws IOException {
        this.write("<td>");
        this.writeDirectly("<a href='?part=cacheKeys&amp;cacheId=" + HtmlCacheInformationsReport.urlEncode(cacheInformations.getName()) + "'>");
        if (cacheInformations.getName().isEmpty()) {
            this.write("--");
        } else {
            this.writeDirectly(HtmlCacheInformationsReport.htmlEncodeButNotSpace(cacheInformations.getName()));
        }
        this.writeln("</a>");
        String nextColumnAlignRight = "</td> <td align='right'>";
        if (this.configurationEnabled) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(cacheInformations.getInMemoryPercentUsed()));
        }
        this.write("</td> <td align='right'>");
        this.write(this.integerFormat.format(cacheInformations.getInMemoryObjectCount()));
        this.write("</td> <td align='right'>");
        this.write(this.integerFormat.format(cacheInformations.getOnDiskObjectCount()));
        if (this.hitsRatioEnabled) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(cacheInformations.getInMemoryHitsRatio()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(cacheInformations.getHitsRatio()));
        }
        if (this.configurationEnabled) {
            this.write("</td> <td>");
            this.write(cacheInformations.getConfiguration());
        }
        this.write("</td>");
        if (this.systemActionsEnabled) {
            this.write("<td align='center' class='noPrint'>");
            String confirmClearCache = HtmlCacheInformationsReport.javascriptEncode(HtmlCacheInformationsReport.getFormattedString("confirm_purge_cache", cacheInformations.getName()));
            this.writeDirectly("<a href='?action=clear_cache&amp;cacheId=" + HtmlCacheInformationsReport.urlEncode(cacheInformations.getName()) + HtmlCacheInformationsReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:return confirm('" + confirmClearCache + "');\">");
            String title = HtmlCacheInformationsReport.htmlEncode(HtmlCacheInformationsReport.getFormattedString("Purge_cache", cacheInformations.getName()));
            this.writeDirectly("<img src='?resource=user-trash.png' width='16' height='16' alt='" + title + "' title='" + title + "' /></a>");
            this.write("</td>");
        }
    }

    public static boolean isHitsRatioEnabled(List<CacheInformations> cacheInformationsList) {
        for (CacheInformations cacheInformations : cacheInformationsList) {
            if (cacheInformations.getHitsRatio() < 0 && cacheInformations.getInMemoryHitsRatio() < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfigurationEnabled(List<CacheInformations> cacheInformationsList) {
        for (CacheInformations cacheInformations : cacheInformationsList) {
            if (cacheInformations.getConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    void writeCacheWithKeys(String cacheId, boolean withoutHeaders) throws IOException {
        assert (this.cacheInformationsList.size() == 1);
        if (!withoutHeaders) {
            this.writeBackAndRefreshLinksForCache(cacheId);
            this.writeln("<br/>");
            this.writeTitle("caches.png", HtmlCacheInformationsReport.getFormattedString("Keys_cache", HtmlCacheInformationsReport.htmlEncodeButNotSpace(cacheId)));
        }
        this.writeCaches(this.cacheInformationsList);
        this.writeln("<br/><b>#Keys#</b>");
        this.writeCacheKeys(this.cacheInformationsList.get(0));
    }

    private void writeBackAndRefreshLinksForCache(String cacheId) throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeDirectly("<a href='?part=cacheKeys&amp;cacheId=" + HtmlCacheInformationsReport.urlEncode(cacheId) + "'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }

    private void writeCacheKeys(CacheInformations cacheInformations) throws IOException {
        List<?> cacheKeys = cacheInformations.getCacheKeys();
        assert (cacheKeys != null);
        if (cacheKeys.isEmpty()) {
            this.write("<br/>#No_keys#");
            return;
        }
        if (cacheKeys.size() > 20) {
            this.writeln("<div align='right'>" + cacheKeys.size() + " #Keys#</div>");
            this.writeln("<br/>");
        }
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable(this);
        table.beginTable(HtmlCacheInformationsReport.getString("Keys"));
        this.write("<th>#Keys#</th>");
        if (this.systemActionsEnabled) {
            this.write("<th class='noPrint'>#Purger#</th>");
        }
        String cacheNameEncoded = HtmlCacheInformationsReport.urlEncode(cacheInformations.getName());
        String csrfTokenUrlPart = HtmlCacheInformationsReport.getCsrfTokenUrlPart();
        String confirmClearCache = HtmlCacheInformationsReport.javascriptEncode(HtmlCacheInformationsReport.getFormattedString("confirm_purge_cache", cacheInformations.getName()));
        String title = HtmlCacheInformationsReport.htmlEncode(HtmlCacheInformationsReport.getFormattedString("Purge_cache", cacheInformations.getName()));
        for (Object key : cacheKeys) {
            if (key == null) continue;
            String myKey = key.toString();
            table.nextRow();
            this.writeDirectly("<td>");
            this.writeDirectly(HtmlCacheInformationsReport.htmlEncodeButNotSpace(myKey));
            this.writeDirectly("</td>");
            if (!this.systemActionsEnabled) continue;
            this.writeDirectly("<td class='noPrint' style='text-align: center;'>");
            this.writeDirectly("<a href='?part=cacheKeys&amp;action=clear_cache_key&amp;cacheId=");
            this.writeDirectly(cacheNameEncoded);
            this.writeDirectly("&amp;cacheKey=");
            this.writeDirectly(HtmlCacheInformationsReport.urlEncode(myKey));
            this.writeDirectly(csrfTokenUrlPart);
            this.writeDirectly("' onclick=\"javascript:return confirm('");
            this.writeDirectly(confirmClearCache);
            this.writeDirectly("');\">");
            this.writeDirectly("<img src='?resource=user-trash.png' width='16' height='16' alt='");
            this.writeDirectly(title);
            this.writeDirectly("' title='");
            this.writeDirectly(title);
            this.writeDirectly("' /></a>");
            this.writeDirectly("</td>");
        }
        table.endTable();
        this.writeln("<br/>");
        this.writeln("<div align='right'>" + cacheKeys.size() + " #Keys#</div>");
    }
}

