/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.FallbackElaborator;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public abstract class Instruction
extends Expression {
    @Override
    public int getImplementationMethod() {
        return 4;
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    public int getInstructionNameCode() {
        return -1;
    }

    @Override
    public String getExpressionName() {
        int code = this.getInstructionNameCode();
        if (code >= 0 & code < 1024) {
            return StandardNames.getDisplayName(code);
        }
        return super.getExpressionName();
    }

    @Override
    public ItemType getItemType() {
        return Type.ITEM_TYPE;
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public abstract Iterable<Operand> operands();

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        try {
            TailCall tc = this.makeElaborator().elaborateForPush().processLeavingTail(output, context);
            Instruction.dispatchTailCall(tc);
        }
        catch (XPathException err) {
            err.maybeSetFailingExpression(this);
            err.maybeSetContext(context);
            throw err;
        }
    }

    public SourceLocator getSourceLocator() {
        return this.getLocation();
    }

    protected static XPathException dynamicError(Location loc, XPathException error, XPathContext context) {
        if (error instanceof TerminationException) {
            return error;
        }
        error.maybeSetLocation(loc);
        error.maybeSetContext(context);
        return error;
    }

    public static ParameterSet assembleParams(XPathContext context, WithParam[] actualParams) throws XPathException {
        if (actualParams == null || actualParams.length == 0) {
            return null;
        }
        ParameterSet params = new ParameterSet(actualParams.length);
        for (WithParam actualParam : actualParams) {
            params.put(actualParam.getVariableQName(), actualParam.getSelectValue(context), actualParam.isTypeChecked());
        }
        return params;
    }

    public static ParameterSet assembleTunnelParams(XPathContext context, WithParam[] actualParams) throws XPathException {
        ParameterSet existingParams = context.getTunnelParameters();
        if (existingParams == null) {
            return Instruction.assembleParams(context, actualParams);
        }
        if (actualParams == null || actualParams.length == 0) {
            return existingParams;
        }
        ParameterSet newParams = new ParameterSet(existingParams, actualParams.length);
        for (WithParam actualParam : actualParams) {
            newParams.put(actualParam.getVariableQName(), actualParam.getSelectValue(context), false);
        }
        return newParams;
    }

    @Override
    protected int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if (this.alwaysCreatesNewNodes()) {
            p |= 0x400000;
        }
        if (this.mayCreateNewNodes()) {
            return p;
        }
        return p | 0x800000;
    }

    @Override
    public int getNetCost() {
        return 20;
    }

    public boolean mayCreateNewNodes() {
        return false;
    }

    public boolean alwaysCreatesNewNodes() {
        return false;
    }

    protected final boolean someOperandCreatesNewNodes() {
        for (Operand o : this.operands()) {
            Expression child = o.getChildExpression();
            int props = child.getSpecialProperties();
            if ((props & 0x800000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Elaborator elaborator = this.makeElaborator();
        if (elaborator instanceof FallbackElaborator) {
            if ((this.getImplementationMethod() & 4) != 0) {
                return ExpressionTool.getIteratorFromProcessMethod(this, context);
            }
            throw new IllegalStateException("No iterate() method available for expression " + this.toShortString());
        }
        return elaborator.elaborateForPull().iterate(context);
    }

    @Override
    public final UnicodeString evaluateAsString(XPathContext context) throws XPathException {
        Item item = this.evaluateItem(context);
        if (item == null) {
            return EmptyUnicodeString.getInstance();
        }
        return item.getUnicodeStringValue();
    }

    public boolean isXSLT() {
        return this.getPackageData().isXSLT();
    }
}

