/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AtomizedValueIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicateProxy;
import net.sf.saxon.z.IntSetPredicate;

final class SiblingIterator
implements AxisIterator,
LookaheadIterator,
AtomizedValueIterator {
    private final TinyTree tree;
    private int nextNodeNr;
    private final NodeTest test;
    private final TinyNodeImpl startNode;
    private final TinyNodeImpl parentNode;
    private final boolean getChildren;
    private boolean needToAdvance = false;
    private final IntPredicateProxy matcher;

    SiblingIterator(TinyTree tree, TinyNodeImpl node, NodeTest nodeTest, boolean getChildren) {
        this.tree = tree;
        this.test = nodeTest;
        this.matcher = nodeTest == null ? IntSetPredicate.ALWAYS_TRUE : nodeTest.getMatcher(tree);
        this.startNode = node;
        this.getChildren = getChildren;
        if (getChildren) {
            this.parentNode = node;
            this.nextNodeNr = node.nodeNr + 1;
        } else {
            this.parentNode = node.getParent();
            if (this.parentNode == null) {
                this.nextNodeNr = -1;
            } else {
                this.nextNodeNr = tree.next[node.nodeNr];
                while (tree.nodeKind[this.nextNodeNr] == 12) {
                    this.nextNodeNr = tree.next[this.nextNodeNr];
                }
                if (this.nextNodeNr < node.nodeNr) {
                    this.nextNodeNr = -1;
                }
            }
        }
        if (this.nextNodeNr >= 0 && nodeTest != null && !this.matcher.test(this.nextNodeNr)) {
            this.needToAdvance = true;
        }
    }

    @Override
    public NodeInfo next() {
        if (this.needToAdvance) {
            int thisNode = this.nextNodeNr;
            int[] tNext = this.tree.next;
            if (this.test == null) {
                do {
                    this.nextNodeNr = tNext[this.nextNodeNr];
                } while (this.tree.nodeKind[this.nextNodeNr] == 12);
            } else {
                do {
                    this.nextNodeNr = tNext[this.nextNodeNr];
                } while (this.nextNodeNr >= thisNode && !this.matcher.test(this.nextNodeNr));
            }
            if (this.nextNodeNr < thisNode) {
                this.nextNodeNr = -1;
                this.needToAdvance = false;
                return null;
            }
        }
        if (this.nextNodeNr == -1) {
            return null;
        }
        this.needToAdvance = true;
        TinyNodeImpl nextNode = this.tree.getNode(this.nextNodeNr);
        nextNode.setParentNode(this.parentNode);
        return nextNode;
    }

    @Override
    public AtomicSequence nextAtomizedValue() throws XPathException {
        if (this.needToAdvance) {
            int thisNode = this.nextNodeNr;
            int[] tNext = this.tree.next;
            if (this.test == null) {
                do {
                    this.nextNodeNr = tNext[this.nextNodeNr];
                } while (this.tree.nodeKind[this.nextNodeNr] == 12);
            } else {
                do {
                    this.nextNodeNr = tNext[this.nextNodeNr];
                } while (this.nextNodeNr >= thisNode && !this.matcher.test(this.nextNodeNr));
            }
            if (this.nextNodeNr < thisNode) {
                this.nextNodeNr = -1;
                this.needToAdvance = false;
                return null;
            }
        }
        if (this.nextNodeNr == -1) {
            return null;
        }
        this.needToAdvance = true;
        byte kind = this.tree.nodeKind[this.nextNodeNr];
        switch (kind) {
            case 3: {
                return StringValue.makeUntypedAtomic(TinyTextImpl.getStringValue(this.tree, this.nextNodeNr));
            }
            case 4: {
                return StringValue.makeUntypedAtomic(WhitespaceTextImpl.getStringValue(this.tree, this.nextNodeNr));
            }
            case 1: 
            case 17: {
                return this.tree.getTypedValueOfElement(this.nextNodeNr);
            }
            case 7: 
            case 8: {
                return this.tree.getAtomizedValueOfUntypedNode(this.nextNodeNr);
            }
        }
        throw new AssertionError((Object)"Unknown node kind on child axis");
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        int n = this.nextNodeNr;
        if (this.needToAdvance) {
            int[] tNext = this.tree.next;
            if (this.test == null) {
                while (this.tree.nodeKind[n = tNext[n]] == 12) {
                }
            } else {
                while ((n = tNext[n]) >= this.nextNodeNr && !this.matcher.test(n)) {
                }
            }
            if (n < this.nextNodeNr) {
                return false;
            }
        }
        return n != -1;
    }
}

