/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.functions.PushableFunction;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class UnparsedText
extends UnparsedTextFunction
implements PushableFunction {
    private static final int errorValue = 0;

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue hrefVal = (StringValue)arguments[0].head();
        String encoding = this.getArity() == 2 ? arguments[1].head().getStringValue() : null;
        try {
            return SequenceTool.itemOrEmpty(UnparsedText.evalUnparsedText(hrefVal, this.getStaticBaseUriString(), encoding, context));
        }
        catch (XPathException e) {
            e.maybeSetErrorCode("FOUT1170");
            if (this.getArity() == 2) {
                throw e.replacingErrorCode("FOUT1200", "FOUT1190");
            }
            throw e;
        }
    }

    @Override
    public void process(Outputter destination, XPathContext context, Sequence[] arguments) throws XPathException {
        boolean stable = context.getConfiguration().getBooleanProperty(Feature.STABLE_UNPARSED_TEXT);
        if (stable) {
            Sequence result = this.call(context, arguments);
            StringValue value = (StringValue)result.head();
            if (value != null) {
                destination.append(value, Loc.NONE, 0);
            }
        } else {
            StringValue href = (StringValue)arguments[0].head();
            URI absoluteURI = UnparsedText.getAbsoluteURI(href.getStringValue(), this.getStaticBaseUriString(), context);
            String encoding = this.getArity() == 2 ? arguments[1].head().getStringValue() : null;
            UniStringConsumer consumer = destination.getStringReceiver(false, Loc.NONE);
            consumer.open();
            try {
                UnparsedText.readFile(absoluteURI, encoding, consumer, context);
                consumer.close();
            }
            catch (XPathException e) {
                if (this.getArity() == 2 && e.hasErrorCode("FOUT1200")) {
                    e.setErrorCode("FOUT1190");
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringValue evalUnparsedText(StringValue hrefVal, String base, String encoding, XPathContext context) throws XPathException {
        StringValue result;
        boolean stable = context.getConfiguration().getBooleanProperty(Feature.STABLE_UNPARSED_TEXT);
        try {
            UnicodeString content;
            if (hrefVal == null) {
                return null;
            }
            String href = hrefVal.getStringValue();
            URI absoluteURI = UnparsedText.getAbsoluteURI(href, base, context);
            if (stable) {
                Controller controller;
                Controller controller2 = controller = context.getController();
                synchronized (controller2) {
                    UnicodeString existing;
                    HashMap<URI, UnicodeString> cache = (HashMap<URI, UnicodeString>)controller.getUserData("unparsed-text-cache", "");
                    if (cache != null && (existing = (UnicodeString)cache.get(absoluteURI)) != null) {
                        if (existing.length() > 0L && existing.codePointAt(0L) == 0) {
                            throw new XPathException(existing.substring(1L).toString(), "FOUT1170");
                        }
                        return new StringValue(existing);
                    }
                    XPathException error = null;
                    try {
                        UnicodeBuilder consumer = new UnicodeBuilder();
                        UnparsedText.readFile(absoluteURI, encoding, consumer, context);
                        content = consumer.toUnicodeString();
                    }
                    catch (XPathException e) {
                        error = e;
                        content = StringView.tidy(0 + e.getMessage());
                    }
                    if (cache == null) {
                        cache = new HashMap<URI, UnicodeString>();
                        controller.setUserData("unparsed-text-cache", "", cache);
                        cache.put(absoluteURI, content);
                    }
                    if (error != null) {
                        throw error;
                    }
                }
            }
            UnicodeBuilder consumer = new UnicodeBuilder();
            UnparsedText.readFile(absoluteURI, encoding, consumer, context);
            return new StringValue(consumer.toUnicodeString());
            result = new StringValue(content);
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("FOUT1170");
            throw err;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        StringBuilder sb1 = new StringBuilder(256);
        StringBuilder sb2 = new StringBuilder(256);
        File file = new File(args[0]);
        FileInputStream is = new FileInputStream(file);
        while (true) {
            int b;
            if ((b = ((InputStream)is).read()) < 0) break;
            sb1.append(Integer.toHexString(b) + " ");
            sb2.append((char)b + " ");
            if (sb1.length() <= 80) continue;
            System.out.println(sb1);
            System.out.println(sb2);
            sb1 = new StringBuilder(256);
            sb2 = new StringBuilder(256);
        }
        System.out.println(sb1);
        System.out.println(sb2);
        ((InputStream)is).close();
    }
}

