/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNameList;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UnusedFormalParameterRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<Boolean> CHECKALL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkAll").desc("Check all methods, including non-private ones")).defaultValue((Object)false)).build();

    public UnusedFormalParameterRule() {
        this.definePropertyDescriptor(CHECKALL_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.check(node, data);
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (!node.isPrivate() && !((Boolean)this.getProperty(CHECKALL_DESCRIPTOR)).booleanValue()) {
            return data;
        }
        if (!(node.isNative() || node.isAbstract() || this.isSerializationMethod(node) || this.hasOverrideAnnotation(node))) {
            this.check(node, data);
        }
        return data;
    }

    private boolean isSerializationMethod(ASTMethodDeclaration node) {
        ASTType type;
        ASTMethodDeclarator declarator = (ASTMethodDeclarator)node.getFirstDescendantOfType(ASTMethodDeclarator.class);
        List parameters = declarator.findDescendantsOfType(ASTFormalParameter.class);
        return node.isPrivate() && "readObject".equals(node.getName()) && parameters.size() == 1 && this.throwsOneException(node, InvalidObjectException.class) && ((type = ((ASTFormalParameter)parameters.get(0)).getTypeNode()).getType() == ObjectInputStream.class || ObjectInputStream.class.getSimpleName().equals(type.getTypeImage()) || ObjectInputStream.class.getName().equals(type.getTypeImage()));
    }

    private boolean throwsOneException(ASTMethodDeclaration node, Class<? extends Throwable> exception) {
        ASTName n;
        ASTNameList throwsList = node.getThrows();
        return throwsList != null && throwsList.getNumChildren() == 1 && ((n = (ASTName)throwsList.getChild(0)).getType() == exception || exception.getSimpleName().equals(n.getImage()) || exception.getName().equals(n.getImage()));
    }

    private void check(Node node, Object data) {
        Node parent = node.getParent().getParent().getParent();
        if (parent instanceof ASTClassOrInterfaceDeclaration && !((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            Map vars = ((JavaNode)node).getScope().getDeclarations(VariableNameDeclaration.class);
            for (Map.Entry entry : vars.entrySet()) {
                VariableNameDeclaration nameDecl = (VariableNameDeclaration)entry.getKey();
                ASTVariableDeclaratorId declNode = nameDecl.getDeclaratorId();
                if (!declNode.isFormalParameter() || declNode.isExplicitReceiverParameter() || this.actuallyUsed(nameDecl, (List)entry.getValue()) || JavaRuleUtil.isExplicitUnusedVarName(nameDecl.getName())) continue;
                this.addViolation(data, (Node)nameDecl.getNode(), new Object[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", nameDecl.getImage()});
            }
        }
    }

    private boolean actuallyUsed(VariableNameDeclaration nameDecl, List<NameOccurrence> usages) {
        for (NameOccurrence occ : usages) {
            JavaNameOccurrence jocc = (JavaNameOccurrence)occ;
            if (jocc.isOnLeftHandSide()) {
                if (!nameDecl.isArray() || jocc.getLocation().getParent().getParent().getNumChildren() <= 1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean hasOverrideAnnotation(ASTMethodDeclaration node) {
        int childIndex = node.getIndexInParent();
        for (int i = 0; i < childIndex; ++i) {
            JavaNode previousSibling = ((JavaNode)node.getParent()).getChild(i);
            List annotations = previousSibling.findDescendantsOfType(ASTMarkerAnnotation.class);
            for (ASTMarkerAnnotation annotation : annotations) {
                ASTName name = (ASTName)annotation.getFirstChildOfType(ASTName.class);
                if (name == null || !name.hasImageEqualTo("Override") && !name.hasImageEqualTo("java.lang.Override")) continue;
                return true;
            }
        }
        return false;
    }
}

