/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.typeinference;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.java.typeresolution.MethodTypeResolution;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinition;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.Bound;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.BoundOrConstraint;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.Constraint;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.InferenceRuleType;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.Variable;

@Deprecated
@InternalApi
public final class TypeInferenceResolver {
    private TypeInferenceResolver() {
    }

    public static List<JavaTypeDefinition> inferTypes(List<Constraint> constraints, List<Bound> bounds, List<Variable> variables) {
        ArrayList<Bound> newBounds = new ArrayList<Bound>();
        while (!constraints.isEmpty()) {
            List<BoundOrConstraint> reduceResult = constraints.remove(constraints.size() - 1).reduce();
            if (reduceResult == null) {
                return null;
            }
            for (BoundOrConstraint boundOrConstraint : reduceResult) {
                if (boundOrConstraint instanceof Bound) {
                    newBounds.add((Bound)boundOrConstraint);
                    continue;
                }
                if (boundOrConstraint instanceof Constraint) {
                    constraints.add((Constraint)boundOrConstraint);
                    continue;
                }
                throw new IllegalStateException("Unknown BoundOrConstraint subclass");
            }
            constraints.addAll(TypeInferenceResolver.incorporateBounds(bounds, newBounds));
            newBounds.clear();
        }
        Map<Variable, JavaTypeDefinition> resolutionResult = TypeInferenceResolver.resolveVariables(bounds);
        ArrayList<JavaTypeDefinition> result = new ArrayList<JavaTypeDefinition>();
        for (Variable variable : variables) {
            result.add(resolutionResult.get(variable));
        }
        return result;
    }

    public static JavaTypeDefinition lub(List<JavaTypeDefinition> types) {
        for (JavaTypeDefinition type : types) {
            if (!type.isArrayType()) continue;
            return JavaTypeDefinition.forClass(Object.class);
        }
        Set<Class<?>> erasedCandidateSet = TypeInferenceResolver.getErasedCandidateSet(types);
        Set<Class<?>> minimalSet = TypeInferenceResolver.getMinimalErasedCandidateSet(erasedCandidateSet);
        ArrayList<JavaTypeDefinition> candidates = new ArrayList<JavaTypeDefinition>();
        for (Class<?> erasedSupertype : minimalSet) {
            JavaTypeDefinition lci = types.get(0).getAsSuper(erasedSupertype);
            for (JavaTypeDefinition type : types) {
                if (lci == null) {
                    throw new ResolutionFailedException();
                }
                lci = TypeInferenceResolver.intersect(lci, type.getAsSuper(erasedSupertype));
            }
            candidates.add(lci);
        }
        if (candidates.isEmpty()) {
            throw new ResolutionFailedException();
        }
        JavaTypeDefinition result = (JavaTypeDefinition)candidates.get(0);
        for (JavaTypeDefinition candidate : candidates) {
            if (MethodTypeResolution.isSubtypeable(candidate, result)) {
                result = candidate;
                continue;
            }
            if (MethodTypeResolution.isSubtypeable(result, candidate)) continue;
            throw new ResolutionFailedException();
        }
        return result;
    }

    public static JavaTypeDefinition intersect(JavaTypeDefinition first, JavaTypeDefinition second) {
        if (first.equals(second)) {
            return first;
        }
        if (first.getType() == second.getType()) {
            if (!first.isRawType() && !second.isRawType()) {
                return TypeInferenceResolver.merge(first, second);
            }
            return JavaTypeDefinition.forClass(first.getType());
        }
        throw new ResolutionFailedException();
    }

    public static JavaTypeDefinition merge(JavaTypeDefinition first, JavaTypeDefinition second) {
        if (first.getType() != second.getType()) {
            throw new IllegalStateException("Must be called with typedefinitions of the same class");
        }
        if (!first.isGeneric()) {
            return first;
        }
        JavaTypeDefinition[] mergedGeneric = new JavaTypeDefinition[first.getTypeParameterCount()];
        for (int i = 0; i < first.getTypeParameterCount(); ++i) {
            if (MethodTypeResolution.isSubtypeable(first.getGenericType(i), second.getGenericType(i))) {
                mergedGeneric[i] = first.getGenericType(i);
                continue;
            }
            if (MethodTypeResolution.isSubtypeable(second.getGenericType(i), first.getGenericType(i))) {
                mergedGeneric[i] = second.getGenericType(i);
                continue;
            }
            return JavaTypeDefinition.forClass(Object.class);
        }
        return JavaTypeDefinition.forClass(first.getType(), mergedGeneric);
    }

    public static Set<Class<?>> getErasedCandidateSet(List<JavaTypeDefinition> erasedSuperTypeSets) {
        HashSet<Class<Class<?>>> result = new HashSet();
        if (!erasedSuperTypeSets.isEmpty()) {
            result = erasedSuperTypeSets.get(0).getErasedSuperTypeSet();
        }
        for (int i = 1; i < erasedSuperTypeSets.size(); ++i) {
            result.retainAll(erasedSuperTypeSets.get(i).getErasedSuperTypeSet());
        }
        return result;
    }

    public static Set<Class<?>> getMinimalErasedCandidateSet(Set<Class<?>> erasedSet) {
        HashSet result = new HashSet();
        block0: for (Class<?> candidate : erasedSet) {
            for (Class<?> erasedSetMember : erasedSet) {
                if (Objects.equals(candidate, erasedSetMember) || !MethodTypeResolution.isSubtypeable(candidate, erasedSetMember)) continue;
                continue block0;
            }
            result.add(candidate);
        }
        return result;
    }

    public static Map<Variable, JavaTypeDefinition> resolveVariables(List<Bound> bounds) {
        Map<Variable, Set<Variable>> variableDependencies = TypeInferenceResolver.getVariableDependencies(bounds);
        Map<Variable, JavaTypeDefinition> instantiations = TypeInferenceResolver.getInstantiations(bounds);
        ArrayList<Variable> uninstantiatedVariables = new ArrayList<Variable>(TypeInferenceResolver.getUninstantiatedVariables(bounds));
        while (!uninstantiatedVariables.isEmpty()) {
            List<Variable> variablesToResolve = null;
            for (List<Variable> variableSet : new Combinations(uninstantiatedVariables)) {
                if (!TypeInferenceResolver.isProperSubsetOfVariables(variableSet, instantiations, variableDependencies, bounds)) continue;
                variablesToResolve = variableSet;
                break;
            }
            if (variablesToResolve == null) {
                throw new ResolutionFailedException();
            }
            for (Variable var : variablesToResolve) {
                List<JavaTypeDefinition> lowerBounds = TypeInferenceResolver.getLowerBoundsOf(var, bounds);
                instantiations.put(var, TypeInferenceResolver.lub(lowerBounds));
            }
            uninstantiatedVariables.removeAll(variablesToResolve);
        }
        return instantiations;
    }

    public static List<JavaTypeDefinition> getLowerBoundsOf(Variable var, List<Bound> bounds) {
        ArrayList<JavaTypeDefinition> result = new ArrayList<JavaTypeDefinition>();
        for (Bound bound : bounds) {
            if (bound.ruleType() != InferenceRuleType.SUBTYPE || !var.equals(bound.rightVariable())) continue;
            if (bound.isLeftVariable()) {
                throw new ResolutionFailedException();
            }
            result.add(bound.leftProper());
        }
        return result;
    }

    public static boolean isProperSubsetOfVariables(List<Variable> variables, Map<Variable, JavaTypeDefinition> instantiations, Map<Variable, Set<Variable>> dependencies, List<Bound> bounds) {
        for (Variable unresolvedVariable : variables) {
            for (Variable dependency : dependencies.get(unresolvedVariable)) {
                if (instantiations.containsKey(dependency) || Objects.equals(unresolvedVariable, dependency) || TypeInferenceResolver.boundsHaveAnEqualityBetween(variables, dependency, bounds)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean boundsHaveAnEqualityBetween(List<Variable> firstList, Variable second, List<Bound> bounds) {
        for (Bound bound : bounds) {
            for (Variable first : firstList) {
                if (bound.ruleType != InferenceRuleType.EQUALITY || (!first.equals(bound.leftVariable()) || !second.equals(bound.rightVariable())) && (!second.equals(bound.leftVariable()) || !first.equals(bound.rightVariable()))) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<Variable, JavaTypeDefinition> getInstantiations(List<Bound> bounds) {
        HashMap<Variable, JavaTypeDefinition> result = new HashMap<Variable, JavaTypeDefinition>();
        for (Bound bound : bounds) {
            if (bound.ruleType() != InferenceRuleType.EQUALITY) continue;
            if (bound.isLeftVariable() && bound.isRightProper()) {
                result.put(bound.leftVariable(), bound.rightProper());
                continue;
            }
            if (!bound.isLeftProper() || !bound.isRightVariable()) continue;
            result.put(bound.rightVariable(), bound.leftProper());
        }
        return result;
    }

    public static Set<Variable> getUninstantiatedVariables(List<Bound> bounds) {
        Set<Variable> result = TypeInferenceResolver.getMentionedVariables(bounds);
        result.removeAll(TypeInferenceResolver.getInstantiations(bounds).keySet());
        return result;
    }

    public static Map<Variable, Set<Variable>> getVariableDependencies(List<Bound> bounds) {
        HashMap<Variable, Set<Variable>> dependencies = new HashMap<Variable, Set<Variable>>();
        for (Variable mentionedVariable : TypeInferenceResolver.getMentionedVariables(bounds)) {
            HashSet<Variable> set = new HashSet<Variable>();
            set.add(mentionedVariable);
            dependencies.put(mentionedVariable, set);
        }
        for (Bound bound : bounds) {
            if (bound.leftVariable() != null && bound.rightHasMentionedVariable()) {
                if (bound.ruleType != InferenceRuleType.EQUALITY && bound.ruleType() != InferenceRuleType.SUBTYPE) continue;
                ((Set)dependencies.get(bound.leftVariable())).add(bound.getRightMentionedVariable());
                continue;
            }
            if (!bound.leftHasMentionedVariable() || bound.rightVariable() == null || bound.ruleType != InferenceRuleType.EQUALITY && bound.ruleType() != InferenceRuleType.SUBTYPE) continue;
            ((Set)dependencies.get(bound.getLeftMentionedVariable())).add(bound.rightVariable());
        }
        for (int i = 0; i < dependencies.size(); ++i) {
            boolean noMoreChanges = true;
            for (Map.Entry entry : dependencies.entrySet()) {
                for (Variable variable : (Set)entry.getValue()) {
                    if (!((Set)entry.getValue()).addAll((Collection)dependencies.get(variable))) continue;
                    noMoreChanges = false;
                }
            }
            if (noMoreChanges) break;
        }
        return dependencies;
    }

    public static Set<Variable> getMentionedVariables(List<Bound> bounds) {
        HashSet<Variable> result = new HashSet<Variable>();
        for (Bound bound : bounds) {
            bound.addVariablesToSet(result);
        }
        return result;
    }

    public static List<Constraint> incorporateBounds(List<Bound> currentBounds, List<Bound> newBounds) {
        ArrayList<Constraint> newConstraints = new ArrayList<Constraint>();
        for (Bound first : currentBounds) {
            for (Bound second : newBounds) {
                Sides sides = TypeInferenceResolver.getUnequalSides(first, second);
                if (sides == null) continue;
                if (first.ruleType() == InferenceRuleType.EQUALITY && second.ruleType() == InferenceRuleType.EQUALITY) {
                    newConstraints.add(TypeInferenceResolver.copyConstraint(first, second, TypeInferenceResolver.getUnequalSides(first, second), InferenceRuleType.EQUALITY));
                    continue;
                }
                if (first.ruleType() == InferenceRuleType.EQUALITY && second.ruleType() == InferenceRuleType.SUBTYPE) {
                    if (sides.second == Side.RIGHT) {
                        newConstraints.add(TypeInferenceResolver.copyConstraint(first, second, sides, InferenceRuleType.SUBTYPE));
                        continue;
                    }
                    newConstraints.add(TypeInferenceResolver.copyConstraint(second, first, sides.copySwap(), InferenceRuleType.SUBTYPE));
                    continue;
                }
                if (first.ruleType() == InferenceRuleType.SUBTYPE && second.ruleType() == InferenceRuleType.EQUALITY) {
                    if (sides.first == Side.RIGHT) {
                        newConstraints.add(TypeInferenceResolver.copyConstraint(second, first, sides.copySwap(), InferenceRuleType.SUBTYPE));
                        continue;
                    }
                    newConstraints.add(TypeInferenceResolver.copyConstraint(first, second, sides, InferenceRuleType.SUBTYPE));
                    continue;
                }
                if (first.ruleType() != InferenceRuleType.SUBTYPE || second.ruleType() != InferenceRuleType.SUBTYPE) continue;
                if (sides.first == Side.LEFT && sides.second == Side.RIGHT) {
                    newConstraints.add(TypeInferenceResolver.copyConstraint(first, second, sides, InferenceRuleType.SUBTYPE));
                    continue;
                }
                if (sides.first != Side.RIGHT || sides.second != Side.LEFT) continue;
                newConstraints.add(TypeInferenceResolver.copyConstraint(second, first, sides.copySwap(), InferenceRuleType.SUBTYPE));
            }
        }
        currentBounds.addAll(newBounds);
        return newConstraints;
    }

    private static Sides getUnequalSides(BoundOrConstraint first, BoundOrConstraint second) {
        if (first.leftVariable() != null) {
            if (first.leftVariable().equals(second.leftVariable())) {
                return new Sides(Side.RIGHT, Side.RIGHT);
            }
            if (first.leftVariable().equals(second.rightVariable())) {
                return new Sides(Side.RIGHT, Side.LEFT);
            }
        } else if (first.rightVariable() != null) {
            if (first.rightVariable().equals(second.leftVariable())) {
                return new Sides(Side.LEFT, Side.RIGHT);
            }
            if (first.rightVariable().equals(second.rightVariable())) {
                return new Sides(Side.LEFT, Side.LEFT);
            }
        }
        return null;
    }

    private static Constraint copyConstraint(BoundOrConstraint first, BoundOrConstraint second, Sides sides, InferenceRuleType rule) {
        if (sides.first == Side.LEFT) {
            if (sides.second == Side.LEFT) {
                if (first.leftVariable() != null) {
                    if (second.leftVariable() != null) {
                        return new Constraint(first.leftVariable(), second.leftVariable(), rule);
                    }
                    return new Constraint(first.leftVariable(), second.leftProper(), rule);
                }
                if (second.leftVariable() != null) {
                    return new Constraint(first.leftProper(), second.leftVariable(), rule);
                }
                return new Constraint(first.leftProper(), second.leftProper(), rule);
            }
            if (first.leftVariable() != null) {
                if (second.rightVariable() != null) {
                    return new Constraint(first.leftVariable(), second.rightVariable(), rule);
                }
                return new Constraint(first.leftVariable(), second.rightProper(), rule);
            }
            if (second.rightVariable() != null) {
                return new Constraint(first.leftProper(), second.rightVariable(), rule);
            }
            return new Constraint(first.leftProper(), second.rightProper(), rule);
        }
        if (sides.second == Side.LEFT) {
            if (first.rightVariable() != null) {
                if (second.leftVariable() != null) {
                    return new Constraint(first.rightVariable(), second.leftVariable(), rule);
                }
                return new Constraint(first.rightVariable(), second.leftProper(), rule);
            }
            if (second.leftVariable() != null) {
                return new Constraint(first.rightProper(), second.leftVariable(), rule);
            }
            return new Constraint(first.rightProper(), second.leftProper(), rule);
        }
        if (first.rightVariable() != null) {
            if (second.rightVariable() != null) {
                return new Constraint(first.rightVariable(), second.rightVariable(), rule);
            }
            return new Constraint(first.rightVariable(), second.rightProper(), rule);
        }
        if (second.rightVariable() != null) {
            return new Constraint(first.rightProper(), second.rightVariable(), rule);
        }
        return new Constraint(first.rightProper(), second.rightProper(), rule);
    }

    private static class Sides {
        final Side first;
        final Side second;

        Sides(Side first, Side second) {
            this.first = first;
            this.second = second;
        }

        Sides copySwap() {
            return new Sides(this.second, this.first);
        }
    }

    private static enum Side {
        LEFT,
        RIGHT;

    }

    private static class Combinations
    implements Iterable<List<Variable>> {
        private int n;
        private int k;
        private List<Variable> permuteThis;
        private List<Variable> resultList = new ArrayList<Variable>();
        private List<Variable> unmodifyableViewOfResult = Collections.unmodifiableList(this.resultList);

        Combinations(List<Variable> permuteThis) {
            this.permuteThis = permuteThis;
            this.n = permuteThis.size();
            this.k = 0;
        }

        @Override
        public Iterator<List<Variable>> iterator() {
            return new CombinationsIterator();
        }

        private class CombinationsIterator
        implements Iterator<List<Variable>> {
            private BitSet nextBitSet;

            private CombinationsIterator() {
                this.nextBitSet = new BitSet(Combinations.this.n);
                this.advanceToNextK();
            }

            private void advanceToNextK() {
                Combinations.this.k++;
                if (Combinations.this.k > Combinations.this.n) {
                    this.nextBitSet = null;
                } else {
                    this.nextBitSet.clear();
                    this.nextBitSet.set(0, Combinations.this.k);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public boolean hasNext() {
                return this.nextBitSet != null;
            }

            @Override
            public List<Variable> next() {
                BitSet resultBitSet = (BitSet)this.nextBitSet.clone();
                int b = this.nextBitSet.previousClearBit(Combinations.this.n - 1);
                int b1 = this.nextBitSet.previousSetBit(b);
                if (b1 == -1) {
                    this.advanceToNextK();
                } else {
                    this.nextBitSet.clear(b1);
                    this.nextBitSet.set(b1 + 1, b1 + (Combinations.this.n - b) + 1);
                    this.nextBitSet.clear(b1 + (Combinations.this.n - b) + 1, Combinations.this.n);
                }
                Combinations.this.resultList.clear();
                for (int i = 0; i < Combinations.this.n; ++i) {
                    if (!resultBitSet.get(i)) continue;
                    Combinations.this.resultList.add(Combinations.this.permuteThis.get(i));
                }
                return Combinations.this.unmodifyableViewOfResult;
            }
        }
    }

    public static class ResolutionFailedException
    extends RuntimeException {
    }
}

