/*
 * $Id$
 */

package org.apache.maven.mercury.repository.cache.md;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class CachedRawMetadata.
 * 
 * @version $Revision$ $Date$
 */
public class CachedRawMetadata implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * When the metadata was last updated.
     */
    private String lastUpdated;

    /**
     * Field elements.
     */
    private java.util.List elements;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addElement.
     * 
     * @param element
     */
    public void addElement(Element element)
    {
        if ( !(element instanceof Element) )
        {
            throw new ClassCastException( "CachedRawMetadata.addElements(element) parameter must be instanceof " + Element.class.getName() );
        }
        getElements().add( element );
    } //-- void addElement(Element) 

    /**
     * Method getElements.
     * 
     * @return java.util.List
     */
    public java.util.List getElements()
    {
        if ( this.elements == null )
        {
            this.elements = new java.util.ArrayList();
        }
        
        return this.elements;
    } //-- java.util.List getElements() 

    /**
     * Get when the metadata was last updated.
     * 
     * @return String
     */
    public String getLastUpdated()
    {
        return this.lastUpdated;
    } //-- String getLastUpdated() 

    /**
     * Method removeElement.
     * 
     * @param element
     */
    public void removeElement(Element element)
    {
        if ( !(element instanceof Element) )
        {
            throw new ClassCastException( "CachedRawMetadata.removeElements(element) parameter must be instanceof " + Element.class.getName() );
        }
        getElements().remove( element );
    } //-- void removeElement(Element) 

    /**
     * Set group of metadata elements.
     * 
     * @param elements
     */
    public void setElements(java.util.List elements)
    {
        this.elements = elements;
    } //-- void setElements(java.util.List) 

    /**
     * Set when the metadata was last updated.
     * 
     * @param lastUpdated
     */
    public void setLastUpdated(String lastUpdated)
    {
        this.lastUpdated = lastUpdated;
    } //-- void setLastUpdated(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
