/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.analyze;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="analyze-duplicate", aggregator=false, threadSafe=true)
public class AnalyzeDuplicateMojo
extends AbstractMojo {
    public static final String MESSAGE_DUPLICATE_DEP_IN_DEPENDENCIES = "List of duplicate dependencies defined in <dependencies/> in your pom.xml:\n";
    public static final String MESSAGE_DUPLICATE_DEP_IN_DEPMGMT = "List of duplicate dependencies defined in <dependencyManagement/> in your pom.xml:\n";
    @Parameter(property="mdep.analyze.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Model model;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)this.project.getFile());){
            model = pomReader.read((Reader)reader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new MojoExecutionException("Exception: " + e.getMessage(), (Exception)e);
        }
        Set<String> duplicateDependencies = Collections.emptySet();
        if (model.getDependencies() != null) {
            duplicateDependencies = this.findDuplicateDependencies(model.getDependencies());
        }
        Set<String> duplicateDependenciesManagement = Collections.emptySet();
        if (model.getDependencyManagement() != null && model.getDependencyManagement().getDependencies() != null) {
            duplicateDependenciesManagement = this.findDuplicateDependencies(model.getDependencyManagement().getDependencies());
        }
        if (this.getLog().isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            this.createMessage(duplicateDependencies, sb, MESSAGE_DUPLICATE_DEP_IN_DEPENDENCIES);
            this.createMessage(duplicateDependenciesManagement, sb, MESSAGE_DUPLICATE_DEP_IN_DEPMGMT);
            if (sb.length() > 0) {
                this.getLog().info((CharSequence)sb.toString());
            } else {
                this.getLog().info((CharSequence)"No duplicate dependencies found in <dependencies/> or in <dependencyManagement/>");
            }
        }
    }

    private void createMessage(Set<String> duplicateDependencies, StringBuilder sb, String messageDuplicateDepInDependencies) {
        if (!duplicateDependencies.isEmpty()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(messageDuplicateDepInDependencies);
            Iterator<String> it = duplicateDependencies.iterator();
            while (it.hasNext()) {
                String dup = it.next();
                sb.append("\to ").append(dup);
                if (!it.hasNext()) continue;
                sb.append("\n");
            }
        }
    }

    private Set<String> findDuplicateDependencies(List<Dependency> modelDependencies) {
        List modelDependencies2 = modelDependencies.stream().map(Dependency::getManagementKey).collect(Collectors.toList());
        modelDependencies2.removeIf(new HashSet(modelDependencies2)::remove);
        return new LinkedHashSet<String>(modelDependencies2);
    }
}

