/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.utils.ParamArtifact;
import org.apache.maven.plugins.dependency.utils.ResolverUtil;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;

@Mojo(name="list-classes", requiresProject=false, threadSafe=true)
public class ListClassesMojo
extends AbstractMojo {
    private final ResolverUtil resolverUtil;
    private ParamArtifact paramArtifact = new ParamArtifact();
    @Parameter(property="remoteRepositories")
    private List<String> remoteRepositories;
    @Parameter(property="transitive", defaultValue="false")
    private boolean transitive = false;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;

    @Inject
    public ListClassesMojo(ResolverUtil resolverUtil) {
        this.resolverUtil = resolverUtil;
    }

    @Parameter(property="groupId")
    public void setGroupId(String groupId) {
        this.paramArtifact.setGroupId(groupId);
    }

    @Parameter(property="artifactId")
    public void setArtifactId(String artifactId) {
        this.paramArtifact.setArtifactId(artifactId);
    }

    @Parameter(property="version")
    public void setVersion(String version) {
        this.paramArtifact.setVersion(version);
    }

    @Parameter(property="classifier")
    public void setClassifier(String classifier) {
        this.paramArtifact.setClassifier(classifier);
    }

    @Parameter(property="packaging", defaultValue="jar")
    public void setPackaging(String packaging) {
        this.paramArtifact.setPackaging(packaging);
    }

    @Parameter(property="artifact")
    public void setArtifact(String artifact) {
        this.paramArtifact.setArtifact(artifact);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (!this.paramArtifact.isDataSet()) {
            throw new MojoExecutionException("You must specify an artifact OR GAV separately, e.g. -Dartifact=org.apache.maven.plugins:maven-downloader-plugin:1.0 OR -DgroupId=org.apache.maven.plugins -DartifactId=maven-downloader-plugin -Dversion=1.0");
        }
        Artifact artifact = this.resolverUtil.createArtifactFromParams(this.paramArtifact);
        try {
            if (this.transitive) {
                List<Artifact> artifacts = this.resolverUtil.resolveDependencies(artifact, this.resolverUtil.remoteRepositories(this.remoteRepositories));
                for (Artifact a : artifacts) {
                    this.printClassesFromArtifactResult(a.getFile());
                }
            } else {
                Artifact a = this.resolverUtil.resolveArtifact(artifact, this.resolverUtil.remoteRepositories(this.remoteRepositories));
                this.printClassesFromArtifactResult(a.getFile());
            }
        }
        catch (IOException | ArtifactResolutionException | DependencyResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)e);
        }
    }

    private void printClassesFromArtifactResult(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.length() - 6).replace('/', '.');
                this.getLog().info((CharSequence)className);
            }
        }
    }
}

