/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testset;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRequest {
    private final List<File> suiteXmlFiles;
    private final File testSourceDirectory;
    private final String requestedTest;
    private final String requestedTestMethod;

    public TestRequest(List suiteXmlFiles, File testSourceDirectory, String requestedTest) {
        this(suiteXmlFiles, testSourceDirectory, requestedTest, null);
    }

    public TestRequest(List suiteXmlFiles, File testSourceDirectory, String requestedTest, String requestedTestMethod) {
        this.suiteXmlFiles = TestRequest.createFiles(suiteXmlFiles);
        this.testSourceDirectory = testSourceDirectory;
        this.requestedTest = requestedTest;
        this.requestedTestMethod = requestedTestMethod;
    }

    public List<File> getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public String getRequestedTest() {
        return this.requestedTest;
    }

    public String getRequestedTestMethod() {
        return this.requestedTestMethod;
    }

    private static List<File> createFiles(List suiteXmlFiles) {
        if (suiteXmlFiles != null) {
            ArrayList<File> files = new ArrayList<File>();
            for (Object suiteXmlFile : suiteXmlFiles) {
                Object element = suiteXmlFile;
                files.add(element instanceof String ? new File((String)element) : (File)element);
            }
            return files;
        }
        return null;
    }
}

