/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.ajde.ui.BuildConfigNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildConfigModel {
    private BuildConfigNode root = null;
    private String sourceFile;

    public BuildConfigModel(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public BuildConfigNode getNodeForPath(String path) {
        BuildConfigNode upPathMatch = this.searchUpPaths(path);
        if (upPathMatch != null && upPathMatch != this.root) {
            return upPathMatch;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        return this.getNodeForPathHelper(st, this.root);
    }

    private BuildConfigNode searchUpPaths(String path) {
        for (BuildConfigNode node : this.root.getChildren()) {
            if (!node.getName().equals(path)) continue;
            return node;
        }
        return null;
    }

    private BuildConfigNode getNodeForPathHelper(StringTokenizer st, BuildConfigNode node2) {
        BuildConfigNode parent = node2;
        while (st.hasMoreElements()) {
            String pathItem = (String)st.nextElement();
            for (BuildConfigNode node2 : node2.getChildren()) {
                String childName = node2.getName();
                if (!childName.equals(pathItem)) continue;
                return this.getNodeForPathHelper(st, node2);
            }
        }
        return parent;
    }

    public List<BuildConfigNode> getActiveNodes(BuildConfigNode.Kind kind) {
        ArrayList<BuildConfigNode> nodes = new ArrayList<BuildConfigNode>();
        this.getActiveNodesHelper(this.root, kind, nodes);
        return nodes;
    }

    private void getActiveNodesHelper(BuildConfigNode node, BuildConfigNode.Kind kind, List<BuildConfigNode> nodes) {
        for (BuildConfigNode currNode : node.getChildren()) {
            if (currNode.getBuildConfigNodeKind().equals(kind) && currNode.isActive()) {
                nodes.add(currNode);
            }
            this.getActiveNodesHelper(currNode, kind, nodes);
        }
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public BuildConfigNode getRoot() {
        return this.root;
    }

    public void setRoot(BuildConfigNode node) {
        this.root = node;
    }

    public BuildConfigNode findNodeForSourceLine(String sourceFilePath, int lineNumber) {
        BuildConfigNode node = this.findNodeForSourceLineHelper(this.root, sourceFilePath, lineNumber);
        return node;
    }

    private BuildConfigNode findNodeForSourceLineHelper(BuildConfigNode node, String sourceFilePath, int lineNumber) {
        if (this.matches(node, sourceFilePath, lineNumber) && !this.hasMoreSpecificChild(node, sourceFilePath, lineNumber)) {
            return node;
        }
        if (node != null && node.getChildren() != null) {
            Iterator<BuildConfigNode> it = node.getChildren().iterator();
            while (it.hasNext()) {
                BuildConfigNode foundNode = this.findNodeForSourceLineHelper(it.next(), sourceFilePath, lineNumber);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    private boolean matches(BuildConfigNode node, String sourceFilePath, int lineNumber) {
        try {
            return node != null && node.getSourceLocation() != null && node.getSourceLocation().getSourceFile().getCanonicalPath().equals(sourceFilePath) && (node.getSourceLocation().getLine() <= lineNumber && node.getSourceLocation().getEndLine() >= lineNumber || lineNumber <= 1);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean hasMoreSpecificChild(BuildConfigNode node, String sourceFilePath, int lineNumber) {
        for (BuildConfigNode child : node.getChildren()) {
            if (!this.matches(child, sourceFilePath, lineNumber)) continue;
            return true;
        }
        return false;
    }
}

