/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.ajc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigParser {
    Location location;
    protected File relativeDirectory = null;
    protected List<File> files = new LinkedList<File>();
    protected List<File> xmlfiles = new ArrayList<File>();
    private boolean fileParsed = false;
    protected static String CONFIG_MSG = "build config error: ";

    public List<File> getFiles() {
        return this.files;
    }

    public List<File> getXmlFiles() {
        return this.xmlfiles;
    }

    public void parseCommandLine(String[] argsArray) throws ParseException {
        this.location = new CommandLineLocation();
        LinkedList<Arg> args = new LinkedList<Arg>();
        for (int i = 0; i < argsArray.length; ++i) {
            args.add(new Arg(argsArray[i], this.location));
        }
        this.parseArgs(args);
    }

    public void parseConfigFile(File configFile) throws ParseException {
        if (this.fileParsed) {
            throw new ParseException(CONFIG_MSG + "The file has already been parsed.", null);
        }
        this.parseConfigFileHelper(configFile);
    }

    private void parseConfigFileHelper(File configFile) {
        if (!configFile.exists()) {
            this.showError("file does not exist: " + configFile.getPath());
            return;
        }
        LinkedList<Arg> args = new LinkedList<Arg>();
        int lineNum = 0;
        try {
            BufferedReader stream = new BufferedReader(new FileReader(configFile));
            String line = null;
            while ((line = stream.readLine()) != null) {
                ++lineNum;
                if ((line = this.stripWhitespaceAndComments(line)).length() == 0) continue;
                args.add(new Arg(line, new CPSourceLocation(configFile, lineNum)));
            }
            stream.close();
        }
        catch (IOException e) {
            this.location = new CPSourceLocation(configFile, lineNum);
            this.showError("error reading config file: " + e.toString());
        }
        File oldRelativeDirectory = this.relativeDirectory;
        this.relativeDirectory = configFile.getParentFile();
        this.parseArgs(args);
        this.relativeDirectory = oldRelativeDirectory;
        this.fileParsed = true;
    }

    File getCurrentDir() {
        return this.location.getDirectory();
    }

    String stripSingleLineComment(String s, String commentString) {
        int commentStart = s.indexOf(commentString);
        if (commentStart == -1) {
            return s;
        }
        return s.substring(0, commentStart);
    }

    String stripWhitespaceAndComments(String s) {
        s = this.stripSingleLineComment(s, "//");
        s = this.stripSingleLineComment(s, "#");
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            if (s.length() == 1) {
                return "";
            }
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    protected void addFile(File sourceFile) {
        if (!sourceFile.isFile()) {
            this.showError("source file does not exist: " + sourceFile.getPath());
        }
        this.files.add(sourceFile);
    }

    protected void addXmlFile(File xmlFile) {
        if (!xmlFile.isFile()) {
            this.showError("XML file does not exist: " + xmlFile.getPath());
        }
        this.xmlfiles.add(xmlFile);
    }

    void addFileOrPattern(File sourceFile) {
        if (sourceFile.getName().charAt(0) == '*') {
            if (sourceFile.getName().equals("*.java")) {
                this.addFiles(sourceFile.getParentFile(), new FileFilter(){

                    public boolean accept(File f) {
                        return f != null && f.getName().endsWith(".java");
                    }
                });
            } else if (sourceFile.getName().equals("*.aj")) {
                this.addFiles(sourceFile.getParentFile(), new FileFilter(){

                    public boolean accept(File f) {
                        return f != null && f.getName().endsWith(".aj");
                    }
                });
            } else {
                this.addFile(sourceFile);
            }
        } else {
            this.addFile(sourceFile);
        }
    }

    void addFiles(File dir, FileFilter filter) {
        if (dir == null) {
            dir = new File(System.getProperty("user.dir"));
        }
        if (!dir.isDirectory()) {
            this.showError("can't find " + dir.getPath());
        } else {
            File[] files = dir.listFiles(filter);
            if (files.length == 0) {
                this.showWarning("no matching files found in: " + dir);
            }
            for (int i = 0; i < files.length; ++i) {
                this.addFile(files[i]);
            }
        }
    }

    protected void parseOption(String arg, LinkedList args) {
        this.showWarning("unrecognized option: " + arg);
    }

    protected void showWarning(String message) {
        if (this.location != null) {
            message = message + " at " + this.location.toString();
        }
        System.err.println(CONFIG_MSG + message);
    }

    protected void showError(String message) {
        throw new ParseException(CONFIG_MSG + message, this.location);
    }

    void parseArgs(LinkedList args) {
        while (args.size() > 0) {
            this.parseOneArg(args);
        }
    }

    protected Arg removeArg(LinkedList args) {
        if (args.size() == 0) {
            this.showError("value missing");
            return null;
        }
        return (Arg)args.removeFirst();
    }

    protected String removeStringArg(LinkedList args) {
        Arg arg = this.removeArg(args);
        if (arg == null) {
            return null;
        }
        return arg.getValue();
    }

    boolean isXml(String s) {
        return s.endsWith(".xml");
    }

    boolean isSourceFileName(String s) {
        if (s.endsWith(".java")) {
            return true;
        }
        return s.endsWith(".aj");
    }

    void parseOneArg(LinkedList args) {
        Arg arg = this.removeArg(args);
        String v = arg.getValue();
        this.location = arg.getLocation();
        if (v.startsWith("@")) {
            this.parseImportedConfigFile(v.substring(1));
        } else if (v.equals("-argfile")) {
            this.parseConfigFileHelper(this.makeFile(this.removeArg(args).getValue()));
        } else if (this.isSourceFileName(v)) {
            this.addFileOrPattern(this.makeFile(v));
        } else if (this.isXml(v)) {
            this.addXmlFile(this.makeFile(v));
        } else {
            this.parseOption(arg.getValue(), args);
        }
    }

    protected void parseImportedConfigFile(String relativeFilePath) {
        this.parseConfigFileHelper(this.makeFile(relativeFilePath));
    }

    public File makeFile(String name) {
        if (this.relativeDirectory != null) {
            return this.makeFile(this.relativeDirectory, name);
        }
        return this.makeFile(this.getCurrentDir(), name);
    }

    private File makeFile(File dir, String name) {
        boolean isAbsolute;
        File ret = new File(name = name.replace('/', File.separatorChar));
        boolean bl = isAbsolute = ret.isAbsolute() || ret.exists() && ret.getPath().startsWith(File.separator);
        if (!isAbsolute && dir != null) {
            ret = new File(dir, name);
        }
        try {
            ret = ret.getCanonicalFile();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        return ret;
    }

    public static class ParseException
    extends RuntimeException {
        private Location location;

        public ParseException(String message, Location location) {
            super(message);
            this.location = location;
        }

        public int getLine() {
            if (this.location == null) {
                return -1;
            }
            return this.location.getLine();
        }

        public File getFile() {
            if (this.location == null) {
                return null;
            }
            return this.location.getFile();
        }
    }

    static class CommandLineLocation
    extends Location {
        CommandLineLocation() {
        }

        public File getFile() {
            return new File(System.getProperty("user.dir"));
        }

        public File getDirectory() {
            return new File(System.getProperty("user.dir"));
        }

        public int getLine() {
            return -1;
        }

        public String toString() {
            return "command-line";
        }
    }

    static class CPSourceLocation
    extends Location {
        private int line;
        private File file;

        public CPSourceLocation(File file, int line) {
            this.line = line;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public File getDirectory() {
            return this.file.getParentFile();
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return this.file.getPath() + ":" + this.line;
        }
    }

    static abstract class Location {
        Location() {
        }

        public abstract File getFile();

        public abstract File getDirectory();

        public abstract int getLine();

        public abstract String toString();
    }

    protected static class Arg {
        private Location location;
        private String value;

        public Arg(String value, Location location) {
            this.value = value;
            this.location = location;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public String getValue() {
            return this.value;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

