/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.IfMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PseudoToken;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.Pointcut;

public class IfPseudoToken
extends PseudoToken {
    public Expression expr;
    public MethodDeclaration testMethod;
    private IfPointcut pointcut;
    private static final char[] CodeGenerationHint = "CodeGenerationHint".toCharArray();
    private static final char[] FullyQualifiedCodeGenerationHint = "org.aspectj.lang.annotation.control.CodeGenerationHint".toCharArray();
    private static final char[] IfNameSuffix = "ifNameSuffix".toCharArray();

    public IfPseudoToken(Parser parser, Expression expr) {
        super(parser, "if", false);
        this.expr = expr;
    }

    public Pointcut maybeGetParsedPointcut() {
        if (this.expr instanceof FalseLiteral) {
            return IfPointcut.makeIfFalsePointcut(Pointcut.SYMBOLIC);
        }
        if (this.expr instanceof TrueLiteral) {
            return IfPointcut.makeIfTruePointcut(Pointcut.SYMBOLIC);
        }
        this.pointcut = new IfPointcut(new ResolvedMemberImpl(Member.METHOD, UnresolvedType.OBJECT, 0, "if_", "()V"), 0);
        return this.pointcut;
    }

    public int postParse(TypeDeclaration typeDec, MethodDeclaration enclosingDec, int counter) {
        if (this.pointcut == null) {
            return 0;
        }
        this.testMethod = this.makeIfMethod(enclosingDec.compilationResult, enclosingDec, typeDec, counter);
        AstUtil.addMethodDeclaration(typeDec, this.testMethod);
        return 1;
    }

    private MethodDeclaration makeIfMethod(CompilationResult result, MethodDeclaration enclosingDec, TypeDeclaration containingTypeDec, int counter) {
        IfMethodDeclaration ret = new IfMethodDeclaration(result, this.pointcut);
        ret.modifiers = 25;
        ret.returnType = AstUtil.makeTypeReference(TypeBinding.BOOLEAN);
        String nameSuffix = null;
        if (enclosingDec != null && enclosingDec.annotations != null) {
            NormalAnnotation interestingAnnotation = null;
            Annotation[] as = enclosingDec.annotations;
            if (as != null) {
                for (int a = 0; a < as.length && interestingAnnotation == null; ++a) {
                    char[] qualifiedName;
                    if (!(as[a] instanceof NormalAnnotation)) continue;
                    TypeReference tr = as[a].type;
                    if (tr instanceof SingleTypeReference) {
                        if (!CharOperation.equals(CodeGenerationHint, ((SingleTypeReference)tr).token)) continue;
                        interestingAnnotation = (NormalAnnotation)as[a];
                        continue;
                    }
                    if (!(tr instanceof QualifiedTypeReference) || !CharOperation.equals(FullyQualifiedCodeGenerationHint, qualifiedName = CharOperation.concatWith(((QualifiedTypeReference)tr).tokens, '.'))) continue;
                    interestingAnnotation = (NormalAnnotation)as[a];
                }
            }
            if (interestingAnnotation != null) {
                MemberValuePair[] memberValuePairs;
                for (MemberValuePair memberValuePair : memberValuePairs = interestingAnnotation.memberValuePairs) {
                    if (!CharOperation.equals(IfNameSuffix, memberValuePair.name) || !(memberValuePair.value instanceof StringLiteral)) continue;
                    nameSuffix = new String(((StringLiteral)memberValuePair.value).source());
                }
            }
        }
        StringBuffer ifSelector = new StringBuffer();
        ifSelector.append("ajc$if$");
        if (nameSuffix == null || nameSuffix.length() == 0) {
            boolean computedName = false;
            try {
                if (enclosingDec instanceof AdviceDeclaration) {
                    ifSelector.append(((AdviceDeclaration)enclosingDec).adviceSequenceNumberInType).append("$");
                    if (counter != 0) {
                        ifSelector.append(counter);
                        ifSelector.append("$");
                    }
                    ifSelector.append(Integer.toHexString(this.expr.toString().hashCode()));
                    computedName = true;
                } else if (enclosingDec instanceof PointcutDeclaration) {
                    if (counter != 0) {
                        ifSelector.append(counter);
                        ifSelector.append("$");
                    }
                    StringBuilder toHash = new StringBuilder(((PointcutDeclaration)enclosingDec).getPointcutText());
                    toHash.append(this.expr.toString());
                    ifSelector.append(Integer.toHexString(toHash.toString().hashCode()));
                    computedName = true;
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
            if (!computedName) {
                ifSelector.append(Integer.toHexString(this.expr.sourceStart));
            }
        } else {
            ifSelector.append(nameSuffix);
        }
        ret.selector = ifSelector.toString().toCharArray();
        ret.arguments = this.makeArguments(enclosingDec, containingTypeDec);
        ret.statements = new Statement[]{new ReturnStatement(this.expr, this.expr.sourceStart, this.expr.sourceEnd)};
        return ret;
    }

    private Argument[] makeArguments(MethodDeclaration enclosingDec, TypeDeclaration containingTypeDec) {
        Argument[] baseArguments = enclosingDec.arguments;
        int len = baseArguments.length;
        if (enclosingDec instanceof AdviceDeclaration) {
            len = ((AdviceDeclaration)enclosingDec).baseArgumentCount;
        }
        Argument[] ret = new Argument[len];
        for (int i = 0; i < len; ++i) {
            Argument a = baseArguments[i];
            ret[i] = new Argument(a.name, AstUtil.makeLongPos(a.sourceStart, a.sourceEnd), a.type, 16);
        }
        ret = AdviceDeclaration.addTjpArguments(ret, containingTypeDec);
        return ret;
    }
}

