/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.weaver.IEclipseSourceContext;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.Member;

public class EclipseSourceContext
implements IEclipseSourceContext {
    CompilationResult result;
    int offset = 0;

    public EclipseSourceContext(CompilationResult result) {
        this.result = result;
    }

    public EclipseSourceContext(CompilationResult result, int offset) {
        this.result = result;
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    private File getSourceFile() {
        return new File(new String(this.result.fileName));
    }

    public ISourceLocation makeSourceLocation(IHasPosition position) {
        return new EclipseSourceLocation(this.result, position.getStart(), position.getEnd());
    }

    public ISourceLocation makeSourceLocation(int line, int offset) {
        SourceLocation sl = new SourceLocation(this.getSourceFile(), line);
        if (offset > 0) {
            sl.setOffset(offset);
        } else {
            int[] offsets = this.result.lineSeparatorPositions;
            int likelyOffset = 0;
            if (line > 0 && line < offsets.length) {
                likelyOffset = offsets[line - 1];
            }
            sl.setOffset(likelyOffset);
        }
        return sl;
    }

    public void tidy() {
        this.result = null;
    }

    public void removeUnnecessaryProblems(Member member, int problemLineNumber) {
        if (this.result == null) {
            return;
        }
        CategorizedProblem[] probs = this.result.getProblems();
        if (probs != null) {
            for (int i = 0; i < probs.length; ++i) {
                CategorizedProblem problem = probs[i];
                if (problem == null || problem.getID() != 536871097 && problem.getID() != 536871098 || problem.getSourceLineNumber() != problemLineNumber) continue;
                UnusedDeclaredThrownExceptionFilter filter = new UnusedDeclaredThrownExceptionFilter(problem);
                this.result.removeProblems(filter);
            }
        }
    }

    private class UnusedDeclaredThrownExceptionFilter
    implements CompilationResult.ProblemsForRemovalFilter {
        private IProblem problemToRemove;

        public UnusedDeclaredThrownExceptionFilter(IProblem p) {
            this.problemToRemove = p;
        }

        public boolean accept(IProblem p) {
            return p.equals(this.problemToRemove);
        }
    }
}

