/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.internal.Characters;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractCharacterAssert<S extends AbstractCharacterAssert<S>>
extends AbstractComparableAssert<S, Character> {
    @VisibleForTesting
    Characters characters = Characters.instance();

    protected AbstractCharacterAssert(Character actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isEqualTo(char expected) {
        this.characters.assertEqual(this.info, this.actual, Character.valueOf(expected));
        return (S)((AbstractCharacterAssert)this.myself);
    }

    public S isNotEqualTo(char other) {
        this.characters.assertNotEqual(this.info, this.actual, Character.valueOf(other));
        return (S)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public S isLessThan(char other) {
        this.characters.assertLessThan(this.info, (Comparable)this.actual, Character.valueOf(other));
        return (S)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public S isLessThanOrEqualTo(char other) {
        this.characters.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, Character.valueOf(other));
        return (S)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public S isGreaterThan(char other) {
        this.characters.assertGreaterThan(this.info, (Comparable)this.actual, Character.valueOf(other));
        return (S)((AbstractCharacterAssert)this.myself);
    }

    public S inUnicode() {
        this.info.useUnicodeRepresentation();
        return (S)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public S isGreaterThanOrEqualTo(char other) {
        this.characters.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, Character.valueOf(other));
        return (S)((AbstractCharacterAssert)this.myself);
    }

    public S isLowerCase() {
        this.characters.assertLowerCase(this.info, (Character)this.actual);
        return (S)((AbstractCharacterAssert)this.myself);
    }

    public S isUpperCase() {
        this.characters.assertUpperCase(this.info, (Character)this.actual);
        return (S)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public S usingComparator(Comparator<? super Character> customComparator) {
        super.usingComparator(customComparator);
        this.characters = new Characters(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractCharacterAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.characters = Characters.instance();
        return (S)((AbstractCharacterAssert)this.myself);
    }
}

