/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.util.Lists;

public final class Iterables {
    public static boolean isNullOrEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        return !iterable.iterator().hasNext();
    }

    public static int sizeOf(Iterable<?> iterable) {
        if (iterable == null) {
            throw new NullPointerException("Iterable must not be null");
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int size = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            ++size;
            iterator.next();
        }
        return size;
    }

    public static <T> List<T> nonNullElementsIn(Iterable<? extends T> i) {
        if (Iterables.isNullOrEmpty(i)) {
            return Collections.emptyList();
        }
        ArrayList<T> nonNull = new ArrayList<T>();
        for (T element : i) {
            if (element == null) continue;
            nonNull.add(element);
        }
        return nonNull;
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        return Lists.newArrayList(iterable).toArray();
    }

    private Iterables() {
    }
}

